/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.plus.jaas;

import java.security.Principal;
import java.security.acl.Group;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;

public class JAASGroup
implements Group {
    public static final String ROLES = "__roles__";
    private String _name = null;
    private HashSet _members = null;

    public JAASGroup(String n) {
        this._name = n;
        this._members = new HashSet();
    }

    public synchronized boolean addMember(Principal principal) {
        return this._members.add(principal);
    }

    public synchronized boolean removeMember(Principal principal) {
        return this._members.remove(principal);
    }

    public boolean isMember(Principal principal) {
        return this._members.contains(principal);
    }

    public Enumeration members() {
        class MembersEnumeration
        implements Enumeration {
            private Iterator itor;

            public MembersEnumeration(Iterator itor) {
                this.itor = itor;
            }

            public boolean hasMoreElements() {
                return this.itor.hasNext();
            }

            public Object nextElement() {
                return this.itor.next();
            }
        }
        return new MembersEnumeration(this._members.iterator());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof JAASGroup)) {
            return false;
        }
        return ((JAASGroup)object).getName().equals(this.getName());
    }

    public String toString() {
        return this.getName();
    }

    public String getName() {
        return this._name;
    }
}

