/*
 * Decompiled with CFR 0.152.
 */
package com.jerolba.carpet.impl.write;

import com.jerolba.carpet.AnnotatedLevels;
import com.jerolba.carpet.RecordTypeConversionException;
import com.jerolba.carpet.annotation.ParquetBson;
import com.jerolba.carpet.annotation.ParquetEnum;
import com.jerolba.carpet.annotation.ParquetGeography;
import com.jerolba.carpet.annotation.ParquetGeometry;
import com.jerolba.carpet.annotation.ParquetJson;
import com.jerolba.carpet.annotation.ParquetString;
import com.jerolba.carpet.annotation.PrecisionScale;
import com.jerolba.carpet.annotation.Rounding;
import com.jerolba.carpet.impl.JavaType;
import com.jerolba.carpet.impl.NotNullField;
import com.jerolba.carpet.impl.Parameterized;
import com.jerolba.carpet.impl.ParameterizedCollection;
import com.jerolba.carpet.impl.ParameterizedMap;
import com.jerolba.carpet.impl.write.BigDecimalWrite;
import com.jerolba.carpet.impl.write.CarpetWriteConfiguration;
import com.jerolba.carpet.impl.write.DecimalConfig;
import com.jerolba.carpet.impl.write.FieldToColumnMapper;
import com.jerolba.carpet.impl.write.SchemaBuilder;
import java.lang.reflect.RecordComponent;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.parquet.column.schema.EdgeInterpolationAlgorithm;
import org.apache.parquet.schema.ConversionPatterns;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.Types;

class JavaRecord2Schema {
    private static final String KEY = "key";
    private static final String VALUE = "value";
    private static final String ELEMENT = "element";
    private final CarpetWriteConfiguration carpetConfiguration;
    private final FieldToColumnMapper fieldToColumnMapper;

    public JavaRecord2Schema(CarpetWriteConfiguration carpetConfiguration) {
        this.carpetConfiguration = carpetConfiguration;
        this.fieldToColumnMapper = new FieldToColumnMapper(carpetConfiguration.columnNamingStrategy());
    }

    public MessageType createSchema(Class<?> recordClass) {
        return this.build(recordClass, new HashSet());
    }

    private MessageType build(Class<?> recordClass, Set<Class<?>> visited) {
        this.validateNotVisitedRecord(recordClass, visited);
        String groupName = recordClass.getSimpleName();
        List<Type> fields = this.createGroupFields(recordClass, visited);
        return new MessageType(groupName, fields);
    }

    private List<Type> createGroupFields(Class<?> recordClass, Set<Class<?>> visited) {
        ArrayList<Type> fields = new ArrayList<Type>();
        for (RecordComponent attr : recordClass.getRecordComponents()) {
            fields.add(this.buildRecordField(attr, visited));
        }
        return fields;
    }

    private Type buildRecordField(RecordComponent attr, Set<Class<?>> visited) {
        Type.Repetition repetition;
        JavaType javaType;
        String fieldName = this.fieldToColumnMapper.getColumnName(attr);
        Type parquetType = this.buildType(fieldName, javaType = new JavaType(attr), repetition = NotNullField.isNotNull(attr) ? Type.Repetition.REQUIRED : Type.Repetition.OPTIONAL, visited);
        if (parquetType != null) {
            return parquetType;
        }
        if (javaType.isCollection()) {
            return this.createCollectionType(fieldName, Parameterized.getParameterizedCollection(attr), repetition, visited);
        }
        if (javaType.isMap()) {
            return this.createMapType(fieldName, Parameterized.getParameterizedMap(attr), repetition, visited);
        }
        if (attr.getGenericType() instanceof TypeVariable) {
            throw new RecordTypeConversionException(attr.getGenericType().toString() + " generic types not supported");
        }
        throw new RecordTypeConversionException("Field '" + attr.getName() + "' of type " + String.valueOf(attr.getType()) + " not supported");
    }

    private List<Type> buildCompositeChild(Class<?> recordClass, Set<Class<?>> visited) {
        this.validateNotVisitedRecord(recordClass, visited);
        List<Type> fields = this.createGroupFields(recordClass, visited);
        visited.remove(recordClass);
        return fields;
    }

    private Type createCollectionType(String fieldName, ParameterizedCollection collectionClass, Type.Repetition repetition, Set<Class<?>> visited) {
        return switch (this.carpetConfiguration.annotatedLevels()) {
            default -> throw new IncompatibleClassChangeError();
            case AnnotatedLevels.ONE -> this.createCollectionOneLevel(fieldName, collectionClass, visited);
            case AnnotatedLevels.TWO -> this.createCollectionTwoLevel(fieldName, collectionClass, repetition, visited);
            case AnnotatedLevels.THREE -> this.createCollectionThreeLevel(fieldName, collectionClass, repetition, visited);
        };
    }

    private Type createCollectionOneLevel(String fieldName, ParameterizedCollection parametized, Set<Class<?>> visited) {
        if (parametized.isCollection()) {
            throw new RecordTypeConversionException("Recursive collections not supported in annotated 1-level structures");
        }
        if (parametized.isMap()) {
            return this.createMapType(fieldName, parametized.getAsMap(), Type.Repetition.REPEATED, visited);
        }
        return this.buildTypeElement(fieldName, parametized.getActualJavaType(), Type.Repetition.REPEATED, visited);
    }

    private Type createCollectionTwoLevel(String fieldName, ParameterizedCollection parametized, Type.Repetition repetition, Set<Class<?>> visited) {
        Type nested = this.createNestedGeneric(parametized, ELEMENT, Type.Repetition.REPEATED, visited);
        return ConversionPatterns.listType((Type.Repetition)repetition, (String)fieldName, (Type)nested);
    }

    private Type createCollectionThreeLevel(String fieldName, ParameterizedCollection parametized, Type.Repetition repetition, Set<Class<?>> visited) {
        Type.Repetition repetitionCollection = JavaRecord2Schema.getTypeRepetition(parametized.getActualJavaType());
        Type nested = this.createNestedGeneric(parametized, ELEMENT, repetitionCollection, visited);
        return ConversionPatterns.listOfElements((Type.Repetition)repetition, (String)fieldName, (Type)nested);
    }

    private Type createNestedGeneric(ParameterizedCollection parametized, String fieldName, Type.Repetition repetition, Set<Class<?>> visited) {
        if (parametized.isCollection()) {
            return this.createCollectionType(fieldName, parametized.getAsCollection(), repetition, visited);
        }
        if (parametized.isMap()) {
            return this.createMapType(fieldName, parametized.getAsMap(), repetition, visited);
        }
        return this.buildTypeElement(fieldName, parametized.getActualJavaType(), repetition, visited);
    }

    private Type createMapType(String fieldName, ParameterizedMap parametized, Type.Repetition repetition, Set<Class<?>> visited) {
        Type nestedKey = this.buildTypeElement(KEY, parametized.getGenericKey().getActualJavaType(), Type.Repetition.REQUIRED, visited);
        ParameterizedCollection genericValue = parametized.getGenericValue();
        Type.Repetition repetitionValue = JavaRecord2Schema.getTypeRepetition(genericValue.getActualJavaType());
        Type nestedValue = this.createNestedGeneric(genericValue, VALUE, repetitionValue, visited);
        if (nestedKey != null && nestedValue != null) {
            return (Type)((Types.MapBuilder)((Types.MapBuilder)Types.map((Type.Repetition)repetition).key(nestedKey)).value(nestedValue)).named(fieldName);
        }
        throw new RecordTypeConversionException("Unsupported type in Map");
    }

    private Type buildTypeElement(String name, JavaType javaType, Type.Repetition repetition, Set<Class<?>> visited) {
        Type parquetType = this.buildType(name, javaType, repetition, visited);
        if (parquetType == null) {
            throw new RecordTypeConversionException("Unsupported type " + String.valueOf(javaType.getJavaType()));
        }
        return parquetType;
    }

    private Type buildType(String name, JavaType javaType, Type.Repetition repetition, Set<Class<?>> visited) {
        if (javaType.isInteger()) {
            return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)repetition).named(name);
        }
        if (javaType.isLong()) {
            return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)repetition).named(name);
        }
        if (javaType.isFloat()) {
            return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FLOAT, (Type.Repetition)repetition).named(name);
        }
        if (javaType.isDouble()) {
            return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.DOUBLE, (Type.Repetition)repetition).named(name);
        }
        if (javaType.isBoolean()) {
            return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BOOLEAN, (Type.Repetition)repetition).named(name);
        }
        if (javaType.isShort()) {
            return (Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.intType((int)16, (boolean)true))).named(name);
        }
        if (javaType.isByte()) {
            return (Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.intType((int)8, (boolean)true))).named(name);
        }
        if (javaType.isString()) {
            return this.buildStringType(javaType, repetition, name);
        }
        if (javaType.isBinary()) {
            return this.buildBinaryType(javaType, repetition, name);
        }
        if (javaType.isEnum()) {
            return this.buildEnumType(javaType, repetition, name);
        }
        if (javaType.isUuid()) {
            return SchemaBuilder.buildUuidType(repetition, name);
        }
        if (javaType.isBigDecimal()) {
            DecimalConfig decimalConfig = BigDecimalWrite.buildDecimalConfig(javaType.getAnnotation(PrecisionScale.class), javaType.getAnnotation(Rounding.class), this.carpetConfiguration.decimalConfig());
            return SchemaBuilder.buildDecimalTypeItem(repetition, name, decimalConfig);
        }
        if (javaType.isLocalDate()) {
            return SchemaBuilder.buildLocalDateType(repetition, name);
        }
        if (javaType.isLocalTime()) {
            return SchemaBuilder.buildLocalTimeType(repetition, name, this.carpetConfiguration.defaultTimeUnit(), this.carpetConfiguration.defaultTimeIsAdjustedToUTC());
        }
        if (javaType.isLocalDateTime()) {
            return SchemaBuilder.buildLocalDateTimeType(repetition, name, this.carpetConfiguration.defaultTimeUnit());
        }
        if (javaType.isInstant()) {
            return SchemaBuilder.buildInstantType(repetition, name, this.carpetConfiguration.defaultTimeUnit());
        }
        if (javaType.isGeometry()) {
            return this.buildJtsGeometryType(javaType, repetition, name);
        }
        if (javaType.isVariant()) {
            return this.buildUnshreddedVariantType(repetition, name);
        }
        if (javaType.isRecord()) {
            List<Type> childFields = this.buildCompositeChild(javaType.getJavaType(), visited);
            return new GroupType(repetition, name, childFields);
        }
        return null;
    }

    private Type buildUnshreddedVariantType(Type.Repetition repetition, String name) {
        return (Type)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)Types.buildGroup((Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.variantType((byte)1))).addField((Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY, (Type.Repetition)Type.Repetition.REQUIRED).named("metadata"))).addField((Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY, (Type.Repetition)Type.Repetition.REQUIRED).named(VALUE))).named(name);
    }

    private Type buildStringType(JavaType javaType, Type.Repetition repetition, String name) {
        if (javaType.isAnnotatedWith(ParquetJson.class)) {
            return (Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.jsonType())).named(name);
        }
        if (javaType.isAnnotatedWith(ParquetEnum.class)) {
            return (Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.enumType())).named(name);
        }
        return (Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.stringType())).named(name);
    }

    private Type buildBinaryType(JavaType javaType, Type.Repetition repetition, String name) {
        Types.PrimitiveBuilder binary = Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY, (Type.Repetition)repetition);
        if (javaType.isAnnotatedWith(ParquetString.class)) {
            binary = (Types.PrimitiveBuilder)binary.as((LogicalTypeAnnotation)LogicalTypeAnnotation.stringType());
        } else if (javaType.isAnnotatedWith(ParquetEnum.class)) {
            binary = (Types.PrimitiveBuilder)binary.as((LogicalTypeAnnotation)LogicalTypeAnnotation.enumType());
        } else if (javaType.isAnnotatedWith(ParquetJson.class)) {
            binary = (Types.PrimitiveBuilder)binary.as((LogicalTypeAnnotation)LogicalTypeAnnotation.jsonType());
        } else if (javaType.isAnnotatedWith(ParquetBson.class)) {
            binary = (Types.PrimitiveBuilder)binary.as((LogicalTypeAnnotation)LogicalTypeAnnotation.bsonType());
        } else if (javaType.isAnnotatedWith(ParquetGeometry.class)) {
            ParquetGeometry geometry = javaType.getAnnotation(ParquetGeometry.class);
            String csr = geometry.value();
            binary = (Types.PrimitiveBuilder)binary.as((LogicalTypeAnnotation)LogicalTypeAnnotation.geometryType(csr == null || csr.isEmpty() ? null : csr));
        } else if (javaType.isAnnotatedWith(ParquetGeography.class)) {
            ParquetGeography geography = javaType.getAnnotation(ParquetGeography.class);
            binary = (Types.PrimitiveBuilder)binary.as((LogicalTypeAnnotation)LogicalTypeAnnotation.geographyType((String)geography.crs(), (EdgeInterpolationAlgorithm)geography.algorithm().getAlgorithm()));
        }
        return (Type)binary.named(name);
    }

    private Type buildEnumType(JavaType javaType, Type.Repetition repetition, String name) {
        if (javaType.isAnnotatedWith(ParquetString.class)) {
            return (Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.stringType())).named(name);
        }
        return (Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.enumType())).named(name);
    }

    private Type buildJtsGeometryType(JavaType javaType, Type.Repetition repetition, String name) {
        ParquetGeometry geometry = javaType.getAnnotation(ParquetGeometry.class);
        if (geometry != null) {
            String csr = geometry.value();
            return (Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.geometryType(csr == null || csr.isEmpty() ? null : csr))).named(name);
        }
        ParquetGeography geography = javaType.getAnnotation(ParquetGeography.class);
        if (geography != null) {
            return (Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.geographyType((String)geography.crs(), (EdgeInterpolationAlgorithm)geography.algorithm().getAlgorithm()))).named(name);
        }
        throw new RecordTypeConversionException("JTS Geometry field must be annotated with @ParquetGeometry or @ParquetGeography");
    }

    private void validateNotVisitedRecord(Class<?> recordClass, Set<Class<?>> visited) {
        if (!recordClass.isRecord()) {
            throw new RecordTypeConversionException(recordClass.getName() + " must be a java Record");
        }
        if (visited.contains(recordClass)) {
            throw new RecordTypeConversionException("Recusive records are not supported");
        }
        visited.add(recordClass);
    }

    private static Type.Repetition getTypeRepetition(JavaType javaType) {
        return NotNullField.isNotNullAnnotated(javaType.getDeclaredAnnotations()) ? Type.Repetition.REQUIRED : Type.Repetition.OPTIONAL;
    }
}

