/*
 * Decompiled with CFR 0.152.
 */
package com.jerolba.carpet.impl.write;

import com.jerolba.carpet.AnnotatedLevels;
import com.jerolba.carpet.RecordTypeConversionException;
import com.jerolba.carpet.impl.AliasField;
import com.jerolba.carpet.impl.JavaType;
import com.jerolba.carpet.impl.Parameterized;
import com.jerolba.carpet.impl.ParameterizedCollection;
import com.jerolba.carpet.impl.ParameterizedMap;
import com.jerolba.carpet.impl.write.CarpetWriteConfiguration;
import com.jerolba.carpet.impl.write.CollectionsWriters;
import com.jerolba.carpet.impl.write.FieldWriterConsumer;
import com.jerolba.carpet.impl.write.FieldsWriter;
import com.jerolba.carpet.impl.write.RecordField;
import com.jerolba.carpet.impl.write.ReflectionRecordField;
import java.lang.reflect.RecordComponent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.apache.parquet.io.api.RecordConsumer;

class CarpetRecordWriter {
    private final RecordConsumer recordConsumer;
    private final CarpetWriteConfiguration carpetConfiguration;
    private final List<Consumer<Object>> fieldWriters = new ArrayList<Consumer<Object>>();

    public CarpetRecordWriter(RecordConsumer recordConsumer, Class<?> recordClass, CarpetWriteConfiguration carpetConfiguration) {
        this.recordConsumer = recordConsumer;
        this.carpetConfiguration = carpetConfiguration;
        int idx = 0;
        for (RecordComponent attr : recordClass.getRecordComponents()) {
            Object accessor;
            JavaType javaType = new JavaType(attr);
            String parquetFieldName = AliasField.getFieldName(attr);
            Consumer<Object> writer = null;
            if (javaType.isJavaPrimitive() && (accessor = FieldsWriter.buildPrimitiveAccessor(recordClass, attr, javaType)) != null) {
                writer = FieldsWriter.buildPrimitiveJavaConsumer(parquetFieldName, javaType, accessor, idx, recordConsumer);
            }
            if (writer == null) {
                Class<?> type = attr.getType();
                ReflectionRecordField f = new ReflectionRecordField(recordClass, attr, parquetFieldName, idx);
                BiConsumer<RecordConsumer, Object> basicTypeWriter = FieldsWriter.buildSimpleElementConsumer(javaType, recordConsumer, carpetConfiguration);
                if (basicTypeWriter != null) {
                    writer = new FieldWriterConsumer(recordConsumer, f, basicTypeWriter);
                } else if (Collection.class.isAssignableFrom(type)) {
                    writer = this.createCollectionWriter(Parameterized.getParameterizedCollection(attr), f);
                } else if (Map.class.isAssignableFrom(type)) {
                    writer = this.createMapStructureWriter(Parameterized.getParameterizedMap(attr), f);
                } else {
                    throw new RuntimeException(type.getName() + " can not be serialized");
                }
            }
            this.fieldWriters.add(writer);
            ++idx;
        }
    }

    public void write(Object record) {
        for (Consumer<Object> fieldWriter : this.fieldWriters) {
            fieldWriter.accept(record);
        }
    }

    private Consumer<Object> createCollectionWriter(ParameterizedCollection collectionClass, RecordField f) {
        return switch (this.carpetConfiguration.annotatedLevels()) {
            default -> throw new IncompatibleClassChangeError();
            case AnnotatedLevels.ONE -> this.createOneLevelStructureWriter(collectionClass, f);
            case AnnotatedLevels.TWO -> this.createTwoLevelStructureWriter(collectionClass, f);
            case AnnotatedLevels.THREE -> this.createThreeLevelStructureWriter(collectionClass, f);
        };
    }

    private Consumer<Object> createOneLevelStructureWriter(ParameterizedCollection parametized, RecordField field) {
        if (parametized.isCollection()) {
            throw new RecordTypeConversionException("Nested collection in a collection is not supported in single level structure codification");
        }
        BiConsumer<RecordConsumer, Object> elemConsumer = null;
        if (parametized.isMap()) {
            ParameterizedMap parametizedChild = parametized.getAsMap();
            Consumer<Object> childWriter = this.createMapStructureWriter(parametizedChild, null);
            elemConsumer = (consumer, v) -> childWriter.accept(v);
        } else {
            JavaType type = parametized.getActualJavaType();
            elemConsumer = FieldsWriter.buildSimpleElementConsumer(type, this.recordConsumer, this.carpetConfiguration);
        }
        if (elemConsumer == null) {
            throw new RecordTypeConversionException("Unsuported type in collection");
        }
        return new CollectionsWriters.OneLevelCollectionFieldWriter(this.recordConsumer, field, elemConsumer);
    }

    private Consumer<Object> createTwoLevelStructureWriter(ParameterizedCollection parametized, RecordField recordField) {
        BiConsumer<RecordConsumer, Object> elemConsumer = this.buildCollectionWriter(parametized);
        if (elemConsumer == null) {
            throw new RecordTypeConversionException("Unsuported type in collection");
        }
        return CollectionsWriters.twoLevelCollectionRecordFieldWriterFactory(this.recordConsumer, recordField, elemConsumer);
    }

    private Consumer<Object> createThreeLevelStructureWriter(ParameterizedCollection generic, RecordField recordField) {
        BiConsumer<RecordConsumer, Object> elemConsumer = this.buildCollectionWriter(generic);
        if (elemConsumer == null) {
            throw new RecordTypeConversionException("Unsuported type in collection");
        }
        return CollectionsWriters.threeLevelCollectionRecordFieldWriterFactory(this.recordConsumer, recordField, elemConsumer);
    }

    private BiConsumer<RecordConsumer, Object> buildCollectionWriter(ParameterizedCollection generic) {
        if (generic.isCollection()) {
            Consumer<Object> childWriter = this.createCollectionWriter(generic.getAsCollection(), null);
            return (consumer, v) -> childWriter.accept(v);
        }
        if (generic.isMap()) {
            Consumer<Object> childWriter = this.createMapStructureWriter(generic.getAsMap(), null);
            return (consumer, v) -> childWriter.accept(v);
        }
        return FieldsWriter.buildSimpleElementConsumer(generic.getActualJavaType(), this.recordConsumer, this.carpetConfiguration);
    }

    private Consumer<Object> createMapStructureWriter(ParameterizedMap generic, RecordField recordField) {
        JavaType keyType = generic.getGenericKey().getActualJavaType();
        BiConsumer<RecordConsumer, Object> keyConsumer = FieldsWriter.buildSimpleElementConsumer(keyType, this.recordConsumer, this.carpetConfiguration);
        BiConsumer<RecordConsumer, Object> valueConsumer = this.buildCollectionWriter(generic.getGenericValue());
        return CollectionsWriters.mapRecordFieldWriterFactory(this.recordConsumer, recordField, keyConsumer, valueConsumer);
    }
}

