/*
 * Decompiled with CFR 0.152.
 */
package com.jerolba.carpet.impl.read;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.apache.parquet.io.api.Converter;
import org.apache.parquet.io.api.GroupConverter;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.variant.ImmutableMetadata;
import org.apache.parquet.variant.Metadata;
import org.apache.parquet.variant.Variant;
import org.apache.parquet.variant.VariantBuilder;
import org.apache.parquet.variant.VariantConverters;

public class VariantConverter
extends GroupConverter
implements VariantConverters.ParentConverter<VariantBuilder> {
    private final Consumer<Object> consumer;
    private final GroupConverter wrappedConverter;
    private VariantBuilder builder = null;
    private ImmutableMetadata metadata = null;

    public VariantConverter(GroupType asGroupType, Consumer<Object> consumer) {
        this.consumer = consumer;
        this.wrappedConverter = VariantConverters.newVariantConverter((GroupType)asGroupType, this::setMetadata, (VariantConverters.ParentConverter)this);
    }

    public boolean isPrimitive() {
        return false;
    }

    private void setMetadata(ByteBuffer metadataBuffer) {
        if (this.metadata == null || this.metadata.getEncodedBuffer() != metadataBuffer) {
            this.metadata = new ImmutableMetadata(metadataBuffer);
        }
        this.builder = new VariantBuilder((Metadata)this.metadata);
    }

    public void build(Consumer<VariantBuilder> buildConsumer) {
        buildConsumer.accept(this.builder);
    }

    public Converter getConverter(int fieldIndex) {
        return this.wrappedConverter.getConverter(fieldIndex);
    }

    public void start() {
        this.wrappedConverter.start();
    }

    public void end() {
        this.wrappedConverter.end();
        this.builder.appendNullIfEmpty();
        Variant variant = this.builder.build();
        this.consumer.accept(variant);
        this.builder = null;
    }
}

