/*
 * Decompiled with CFR 0.152.
 */
package com.jerolba.carpet.impl.read;

import com.jerolba.carpet.CloseableIterator;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.NoSuchElementException;
import org.apache.parquet.hadoop.ParquetReader;

public class ParquetRecordIterator<T>
implements CloseableIterator<T> {
    private final ParquetReader<T> reader;
    private T nextRecord;

    public ParquetRecordIterator(ParquetReader<T> reader) throws IOException {
        this.reader = reader;
        this.nextRecord = reader.read();
    }

    @Override
    public boolean hasNext() {
        return this.nextRecord != null;
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        T res = this.nextRecord;
        try {
            this.nextRecord = this.reader.read();
            if (this.nextRecord == null) {
                this.uncheckedCloseReader();
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return res;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
        this.nextRecord = null;
    }

    public void uncheckedCloseReader() {
        try {
            this.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

