/*
 * Decompiled with CFR 0.152.
 */
package com.jerolba.carpet.impl.read;

import com.jerolba.carpet.impl.JavaType;
import com.jerolba.carpet.impl.read.converter.BinaryConverter;
import com.jerolba.carpet.impl.read.converter.DecimalConverter;
import com.jerolba.carpet.impl.read.converter.EnumConverter;
import com.jerolba.carpet.impl.read.converter.GeometryConverter;
import com.jerolba.carpet.impl.read.converter.InstantConverter;
import com.jerolba.carpet.impl.read.converter.LocalDateConverter;
import com.jerolba.carpet.impl.read.converter.LocalDateTimeConverter;
import com.jerolba.carpet.impl.read.converter.LocalTimeConverter;
import com.jerolba.carpet.impl.read.converter.StringConverter;
import com.jerolba.carpet.impl.read.converter.ToByteConverter;
import com.jerolba.carpet.impl.read.converter.ToShortConverter;
import com.jerolba.carpet.impl.read.converter.UuidToStringConverter;
import com.jerolba.carpet.impl.read.converter.UuidToUuidConverter;
import java.util.function.Consumer;
import org.apache.parquet.io.api.Converter;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;

class LogicalTypeConverters {
    LogicalTypeConverters() {
    }

    public static Converter buildFromLogicalTypeConverter(JavaType type, Type parquetField, Consumer<Object> consumer) {
        LogicalTypeAnnotation logicalTypeAnnotation = parquetField.getLogicalTypeAnnotation();
        if (logicalTypeAnnotation == null) {
            return null;
        }
        PrimitiveType.PrimitiveTypeName primitiveTypeName = parquetField.asPrimitiveType().getPrimitiveTypeName();
        if (logicalTypeAnnotation.equals(LogicalTypeAnnotation.stringType())) {
            return LogicalTypeConverters.converterForStringOrEnumType(type, consumer);
        }
        if (logicalTypeAnnotation.equals(LogicalTypeAnnotation.enumType())) {
            return LogicalTypeConverters.converterForStringOrEnumType(type, consumer);
        }
        if (logicalTypeAnnotation instanceof LogicalTypeAnnotation.IntLogicalTypeAnnotation) {
            LogicalTypeAnnotation.IntLogicalTypeAnnotation intType = (LogicalTypeAnnotation.IntLogicalTypeAnnotation)logicalTypeAnnotation;
            return LogicalTypeConverters.converterForIntType(type, consumer, intType);
        }
        if (logicalTypeAnnotation.equals(LogicalTypeAnnotation.dateType())) {
            return LogicalTypeConverters.converterForDateType(type, consumer, primitiveTypeName);
        }
        if (logicalTypeAnnotation instanceof LogicalTypeAnnotation.TimeLogicalTypeAnnotation) {
            LogicalTypeAnnotation.TimeLogicalTypeAnnotation time = (LogicalTypeAnnotation.TimeLogicalTypeAnnotation)logicalTypeAnnotation;
            return LogicalTypeConverters.converterForTimestampType(type, consumer, primitiveTypeName, time);
        }
        if (logicalTypeAnnotation instanceof LogicalTypeAnnotation.TimestampLogicalTypeAnnotation) {
            LogicalTypeAnnotation.TimestampLogicalTypeAnnotation timeStamp = (LogicalTypeAnnotation.TimestampLogicalTypeAnnotation)logicalTypeAnnotation;
            return LogicalTypeConverters.converterForTimestampType(type, consumer, primitiveTypeName, timeStamp);
        }
        if (logicalTypeAnnotation instanceof LogicalTypeAnnotation.DecimalLogicalTypeAnnotation) {
            LogicalTypeAnnotation.DecimalLogicalTypeAnnotation decimalType = (LogicalTypeAnnotation.DecimalLogicalTypeAnnotation)logicalTypeAnnotation;
            return LogicalTypeConverters.converterForDecimalType(type, consumer, primitiveTypeName, decimalType);
        }
        if (logicalTypeAnnotation.equals(LogicalTypeAnnotation.uuidType())) {
            return LogicalTypeConverters.converterForUuidType(type, consumer, primitiveTypeName);
        }
        if (logicalTypeAnnotation.equals(LogicalTypeAnnotation.jsonType())) {
            return LogicalTypeConverters.converterForJsonType(type, consumer);
        }
        if (logicalTypeAnnotation.equals(LogicalTypeAnnotation.bsonType())) {
            return LogicalTypeConverters.converterForBsonType(type, consumer);
        }
        if (logicalTypeAnnotation instanceof LogicalTypeAnnotation.GeometryLogicalTypeAnnotation || logicalTypeAnnotation instanceof LogicalTypeAnnotation.GeographyLogicalTypeAnnotation) {
            return LogicalTypeConverters.converterForGeospatial(type, consumer);
        }
        return null;
    }

    private static Converter converterForStringOrEnumType(JavaType type, Consumer<Object> consumer) {
        if (type == null || type.isString()) {
            return new StringConverter(consumer);
        }
        if (type.isBinary()) {
            return new BinaryConverter(consumer);
        }
        if (type.isEnum()) {
            return new EnumConverter(consumer, type.getJavaType());
        }
        return null;
    }

    private static Converter converterForJsonType(JavaType type, Consumer<Object> consumer) {
        if (type == null || type.isString()) {
            return new StringConverter(consumer);
        }
        if (type.isBinary()) {
            return new BinaryConverter(consumer);
        }
        return null;
    }

    private static Converter converterForBsonType(JavaType type, Consumer<Object> consumer) {
        if (type == null || type.isBinary()) {
            return new BinaryConverter(consumer);
        }
        return null;
    }

    private static Converter converterForIntType(JavaType type, Consumer<Object> consumer, LogicalTypeAnnotation.IntLogicalTypeAnnotation intType) {
        if (intType.getBitWidth() == 8 && (type == null || type.isByte())) {
            return new ToByteConverter(consumer);
        }
        if (intType.getBitWidth() == 16 && (type == null || type.isShort())) {
            return new ToShortConverter(consumer);
        }
        return null;
    }

    private static Converter converterForUuidType(JavaType type, Consumer<Object> consumer, PrimitiveType.PrimitiveTypeName primitiveTypeName) {
        if (primitiveTypeName == PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY) {
            if (type == null || type.isUuid()) {
                return new UuidToUuidConverter(consumer);
            }
            if (type.isString()) {
                return new UuidToStringConverter(consumer);
            }
        }
        return null;
    }

    private static Converter converterForDateType(JavaType type, Consumer<Object> consumer, PrimitiveType.PrimitiveTypeName primitiveTypeName) {
        if (primitiveTypeName == PrimitiveType.PrimitiveTypeName.INT32 && (type == null || type.isLocalDate())) {
            return new LocalDateConverter(consumer);
        }
        return null;
    }

    private static Converter converterForTimestampType(JavaType type, Consumer<Object> consumer, PrimitiveType.PrimitiveTypeName primitiveTypeName, LogicalTypeAnnotation.TimeLogicalTypeAnnotation time) {
        if (!(primitiveTypeName != PrimitiveType.PrimitiveTypeName.INT32 && primitiveTypeName != PrimitiveType.PrimitiveTypeName.INT64 || type != null && !type.isLocalTime())) {
            return new LocalTimeConverter(consumer, time.getUnit());
        }
        return null;
    }

    private static Converter converterForTimestampType(JavaType type, Consumer<Object> consumer, PrimitiveType.PrimitiveTypeName primitiveTypeName, LogicalTypeAnnotation.TimestampLogicalTypeAnnotation timeStamp) {
        if (primitiveTypeName == PrimitiveType.PrimitiveTypeName.INT64) {
            if (type == null) {
                if (timeStamp.isAdjustedToUTC()) {
                    return new InstantConverter(consumer, timeStamp.getUnit());
                }
                return new LocalDateTimeConverter(consumer, timeStamp.getUnit());
            }
            if (type.isLocalDateTime()) {
                return new LocalDateTimeConverter(consumer, timeStamp.getUnit());
            }
            if (type.isInstant()) {
                return new InstantConverter(consumer, timeStamp.getUnit());
            }
        }
        return null;
    }

    private static Converter converterForDecimalType(JavaType type, Consumer<Object> consumer, PrimitiveType.PrimitiveTypeName typeName, LogicalTypeAnnotation.DecimalLogicalTypeAnnotation decimalType) {
        if (type == null || type.isBigDecimal()) {
            return new DecimalConverter(consumer, typeName, decimalType.getScale());
        }
        return null;
    }

    private static Converter converterForGeospatial(JavaType type, Consumer<Object> consumer) {
        if (type == null || type.isGeometry()) {
            return new GeometryConverter(consumer);
        }
        return null;
    }
}

