/*
 * Decompiled with CFR 0.152.
 */
package com.jerolba.carpet.impl;

import com.jerolba.carpet.RecordTypeConversionException;
import com.jerolba.carpet.impl.ParameterizedCollection;
import com.jerolba.carpet.impl.ParameterizedMap;
import java.lang.reflect.AnnotatedParameterizedType;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.RecordComponent;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Collection;
import java.util.Map;
import java.util.function.BiFunction;

public class Parameterized {
    public static ParameterizedCollection getParameterizedCollection(RecordComponent attr) {
        return Parameterized.getParameterizedCollection(attr.getAnnotatedType());
    }

    public static ParameterizedCollection getParameterizedCollection(Field attr) {
        return Parameterized.getParameterizedCollection(attr.getAnnotatedType());
    }

    public static ParameterizedCollection getParameterizedCollection(AnnotatedType annotatedTypeCollection) {
        return Parameterized.parametizeTo(annotatedTypeCollection, ParameterizedCollection::new);
    }

    public static boolean isCollection(Type type) {
        return Parameterized.typeIsAssignableFrom(type, Collection.class);
    }

    public static ParameterizedMap getParameterizedMap(RecordComponent attr) {
        return Parameterized.getParameterizedMap(attr.getAnnotatedType());
    }

    public static ParameterizedMap getParameterizedMap(Field attr) {
        return Parameterized.getParameterizedMap(attr.getAnnotatedType());
    }

    public static ParameterizedMap getParameterizedMap(AnnotatedType annotatedTypeMap) {
        return Parameterized.parametizeTo(annotatedTypeMap, ParameterizedMap::new);
    }

    public static boolean isMap(Type type) {
        return Parameterized.typeIsAssignableFrom(type, Map.class);
    }

    public static Class<?> getClassFromType(Type type, String usageForError) {
        ParameterizedType parameterizedType;
        Type rawType;
        if (type instanceof Class) {
            Class finalType = (Class)type;
            return finalType;
        }
        if (type instanceof ParameterizedType && (rawType = (parameterizedType = (ParameterizedType)type).getRawType()) instanceof Class) {
            Class finalType = (Class)rawType;
            return finalType;
        }
        if (type instanceof TypeVariable) {
            TypeVariable finalType = (TypeVariable)type;
            throw new RecordTypeConversionException(finalType.getName() + " generic type not supported " + usageForError);
        }
        throw new RecordTypeConversionException("Invalid type " + String.valueOf(type) + " " + usageForError);
    }

    private static boolean typeIsAssignableFrom(Type type, Class<?> toAssign) {
        ParameterizedType paramType;
        Type collectionActualType;
        if (type instanceof ParameterizedType && (collectionActualType = (paramType = (ParameterizedType)type).getRawType()) instanceof Class) {
            Class finalType = (Class)collectionActualType;
            return toAssign.isAssignableFrom(finalType);
        }
        return false;
    }

    private static <T> T parametizeTo(AnnotatedType annotatedType, BiFunction<Type, AnnotatedParameterizedType, T> constructor) {
        AnnotatedParameterizedType paramType;
        Type type;
        if (annotatedType instanceof AnnotatedParameterizedType && (type = (paramType = (AnnotatedParameterizedType)annotatedType).getType()) instanceof ParameterizedType) {
            ParameterizedType rawType = (ParameterizedType)type;
            Type raw = rawType.getRawType();
            return constructor.apply(raw, paramType);
        }
        throw new RecordTypeConversionException("Unsupported type in collection: " + String.valueOf(annotatedType));
    }
}

