/*
 * Decompiled with CFR 0.152.
 */
package com.jerolba.carpet;

import com.jerolba.carpet.RecordTypeConversionException;
import com.jerolba.carpet.impl.read.SchemaValidation;
import com.jerolba.carpet.io.FileSystemInputFile;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import org.apache.parquet.ParquetReadOptions;
import org.apache.parquet.column.schema.EdgeInterpolationAlgorithm;
import org.apache.parquet.conf.ParquetConfiguration;
import org.apache.parquet.conf.PlainParquetConfiguration;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.io.InputFile;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;

public class CarpetRecordGenerator {
    private static final BasicTypeInfo BYTE_TYPE = new BasicTypeInfo("byte", "Byte");
    private static final BasicTypeInfo SHORT_TYPE = new BasicTypeInfo("short", "Short");
    private static final BasicTypeInfo INT_TYPE = new BasicTypeInfo("int", "Integer");
    private static final BasicTypeInfo LONG_TYPE = new BasicTypeInfo("long", "Long");
    private static final BasicTypeInfo FLOAT_TYPE = new BasicTypeInfo("float", "Float");
    private static final BasicTypeInfo DOUBLE_TYPE = new BasicTypeInfo("double", "Double");
    private static final BasicTypeInfo BOOLEAN_TYPE = new BasicTypeInfo("boolean", "Boolean");
    private static final BasicTypeInfo STRING_TYPE = new BasicTypeInfo("String");
    private static final BasicTypeInfo ENUM_TYPE = new BasicTypeInfo("String");
    private static final BasicTypeInfo UUID_TYPE = new BasicTypeInfo("UUID");
    private static final BasicTypeInfo LOCAL_DATE_TYPE = new BasicTypeInfo("LocalDate");
    private static final BasicTypeInfo LOCAL_TIME_TYPE = new BasicTypeInfo("LocalTime");
    private static final BasicTypeInfo LOCAL_DATE_TIME_TYPE = new BasicTypeInfo("LocalDateTime");
    private static final BasicTypeInfo INSTANT_TYPE = new BasicTypeInfo("Instant");
    private static final BasicTypeInfo BINARY_TYPE = new BasicTypeInfo("Binary");
    private static final BasicTypeInfo VARIANT_TYPE = new BasicTypeInfo("Variant");

    public static List<String> generateCode(String filePath) throws IOException {
        return CarpetRecordGenerator.generateCode(new File(filePath));
    }

    public static List<String> generateCode(File file) throws IOException {
        FileSystemInputFile inputFile = new FileSystemInputFile(file);
        return CarpetRecordGenerator.generateCode(inputFile);
    }

    public static List<String> generateCode(InputFile inputFile) throws IOException {
        return new RecordCodeBuilder().calculate(inputFile);
    }

    private static String extractClassName(String str) {
        String name = str;
        int lastIndexOf = str.lastIndexOf(".");
        if (lastIndexOf > 0) {
            name = str.substring(lastIndexOf + 1);
        }
        return CarpetRecordGenerator.capitalize(name);
    }

    private static String capitalize(String str) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        if (str.length() == 1) {
            return str.toUpperCase();
        }
        return str.substring(0, 1).toUpperCase() + str.substring(1);
    }

    private static class RecordCodeBuilder {
        private RecordCodeBuilder() {
        }

        private List<String> calculate(InputFile inputFile) throws IOException {
            ParquetReadOptions readOptions = ParquetReadOptions.builder((ParquetConfiguration)new PlainParquetConfiguration()).build();
            try (ParquetFileReader fileReader = ParquetFileReader.open((InputFile)inputFile, (ParquetReadOptions)readOptions);){
                MessageType schema = fileReader.getFileMetaData().getSchema();
                SchemaInspector inspector = new SchemaInspector();
                RecordMetadata generated = inspector.inspectGroup((GroupType)schema, schema.getName()).recordClass();
                Set<RecordMetadata> allClasses = new TreeTraversal().locateClassesInTree(generated);
                CodeGenerator codeGenerator = new CodeGenerator();
                List<String> list = allClasses.stream().map(codeGenerator::recordToString).toList();
                return list;
            }
        }

        private static class SchemaInspector {
            private final Map<Set<Type>, RecordType> existingRecords = new HashMap<Set<Type>, RecordType>();

            private SchemaInspector() {
            }

            private RecordType inspectGroup(GroupType groupType, String inheritedName) {
                HashSet fieldsSet = new HashSet(groupType.getFields());
                if (this.existingRecords.containsKey(fieldsSet)) {
                    return this.existingRecords.get(fieldsSet);
                }
                RecordMetadata current = new RecordMetadata(groupType, inheritedName);
                for (Type schemaField : groupType.getFields()) {
                    FieldType fieldType = this.buildField(schemaField, schemaField.getName());
                    if (schemaField.isRepetition(Type.Repetition.REPEATED)) {
                        fieldType = new ListType(fieldType);
                    }
                    current.fields().add(new RecordField(fieldType, schemaField));
                }
                RecordType recordType = new RecordType(current);
                this.existingRecords.put(fieldsSet, recordType);
                return recordType;
            }

            private FieldType buildField(Type field, String fieldName) {
                if (field.isPrimitive()) {
                    return PrimitiveFieldFactory.buildRecordField(field);
                }
                GroupType asGroupType = field.asGroupType();
                LogicalTypeAnnotation logicalType = asGroupType.getLogicalTypeAnnotation();
                if (LogicalTypeAnnotation.listType().equals((Object)logicalType)) {
                    return this.inspectListField(asGroupType, fieldName);
                }
                if (LogicalTypeAnnotation.mapType().equals((Object)logicalType)) {
                    return this.inspectMapField(asGroupType, fieldName);
                }
                if (logicalType instanceof LogicalTypeAnnotation.VariantLogicalTypeAnnotation) {
                    return new BasicType(VARIANT_TYPE, field.getRepetition() == Type.Repetition.REQUIRED);
                }
                return this.inspectGroup(field.asGroupType(), fieldName);
            }

            private FieldType inspectListField(GroupType listField, String listFieldName) {
                Type listChild = (Type)listField.getFields().get(0);
                Type listElement = SchemaValidation.isThreeLevel(listChild) ? (Type)listChild.asGroupType().getFields().get(0) : listChild;
                return new ListType(this.buildField(listElement, listFieldName));
            }

            private FieldType inspectMapField(GroupType mapField, String mapFieldName) {
                List fields = mapField.getFields();
                if (fields.size() > 1) {
                    throw new RecordTypeConversionException(mapField.getName() + " MAP can not have more than one field");
                }
                GroupType mapChild = ((Type)fields.get(0)).asGroupType();
                List mapFields = mapChild.getFields();
                if (mapFields.size() != 2) {
                    throw new RecordTypeConversionException(mapField.getName() + " MAP child element must have two fields");
                }
                FieldType keyType = this.buildField((Type)mapFields.get(0), mapFieldName + "Key");
                FieldType valueType = this.buildField((Type)mapFields.get(1), mapFieldName);
                return new MapType(keyType, valueType);
            }
        }

        private static class TreeTraversal {
            private TreeTraversal() {
            }

            private Set<RecordMetadata> locateClassesInTree(RecordMetadata generated) {
                LinkedHashSet<RecordMetadata> lst = new LinkedHashSet<RecordMetadata>();
                List<RecordField> fields = generated.fields;
                for (RecordField field : fields) {
                    lst.addAll(this.locateRecords(field.fieldType));
                }
                lst.add(generated);
                return lst;
            }

            private Set<RecordMetadata> locateRecords(FieldType type) {
                if (type instanceof RecordType) {
                    RecordType r = (RecordType)type;
                    return this.locateClassesInTree(r.recordClass);
                }
                if (type instanceof ListType) {
                    ListType rec = (ListType)type;
                    return this.locateRecords(rec.listType);
                }
                if (type instanceof MapType) {
                    MapType map = (MapType)type;
                    LinkedHashSet<RecordMetadata> mapClasses = new LinkedHashSet<RecordMetadata>();
                    mapClasses.addAll(this.locateRecords(map.keyType));
                    mapClasses.addAll(this.locateRecords(map.valueType));
                    return mapClasses;
                }
                return Set.of();
            }
        }

        private static class CodeGenerator {
            private CodeGenerator() {
            }

            private String recordToString(RecordMetadata generated) {
                List<RecordField> fields = generated.fields;
                String value = "record " + generated.recorddName + "(";
                boolean first = true;
                for (RecordField field : fields) {
                    FieldType type = field.fieldType;
                    if (!first) {
                        value = value + ", ";
                    }
                    value = value + type.getJavaType() + " " + field.name;
                    first = false;
                }
                value = value + ") {}";
                return value;
            }
        }
    }

    private record BasicTypeInfo(String primitive, String object) implements BasicTypes
    {
        public BasicTypeInfo(String object) {
            this(object, object);
        }
    }

    private static class PrimitiveFieldFactory {
        private PrimitiveFieldFactory() {
        }

        static FieldType buildRecordField(Type parquetField) {
            PrimitiveType.PrimitiveTypeName typeName = parquetField.asPrimitiveType().getPrimitiveTypeName();
            BasicTypes basicType = PrimitiveFieldFactory.buildFromLogicalType(parquetField);
            if (basicType == null) {
                basicType = switch (typeName) {
                    case PrimitiveType.PrimitiveTypeName.INT32 -> INT_TYPE;
                    case PrimitiveType.PrimitiveTypeName.INT64 -> LONG_TYPE;
                    case PrimitiveType.PrimitiveTypeName.FLOAT -> FLOAT_TYPE;
                    case PrimitiveType.PrimitiveTypeName.DOUBLE -> DOUBLE_TYPE;
                    case PrimitiveType.PrimitiveTypeName.BOOLEAN -> BOOLEAN_TYPE;
                    case PrimitiveType.PrimitiveTypeName.BINARY -> BINARY_TYPE;
                    default -> throw new RecordTypeConversionException(String.valueOf(typeName) + " deserialization not supported");
                };
            }
            return new BasicType(basicType, parquetField.isRepetition(Type.Repetition.REQUIRED));
        }

        static BasicTypes buildFromLogicalType(Type parquetField) {
            LogicalTypeAnnotation logicalType = parquetField.getLogicalTypeAnnotation();
            if (logicalType == null) {
                return null;
            }
            if (logicalType.equals(LogicalTypeAnnotation.stringType())) {
                return STRING_TYPE;
            }
            if (logicalType.equals(LogicalTypeAnnotation.enumType())) {
                return ENUM_TYPE;
            }
            if (logicalType.equals(LogicalTypeAnnotation.jsonType())) {
                return new BinaryAnnotatedType("ParquetJson", "String");
            }
            if (logicalType.equals(LogicalTypeAnnotation.bsonType())) {
                return new BinaryAnnotatedType("ParquetBson", "Binary");
            }
            if (logicalType instanceof LogicalTypeAnnotation.IntLogicalTypeAnnotation) {
                LogicalTypeAnnotation.IntLogicalTypeAnnotation intType = (LogicalTypeAnnotation.IntLogicalTypeAnnotation)logicalType;
                return switch (intType.getBitWidth()) {
                    case 8 -> BYTE_TYPE;
                    case 16 -> SHORT_TYPE;
                    default -> INT_TYPE;
                };
            }
            if (logicalType instanceof LogicalTypeAnnotation.DecimalLogicalTypeAnnotation) {
                LogicalTypeAnnotation.DecimalLogicalTypeAnnotation decimal = (LogicalTypeAnnotation.DecimalLogicalTypeAnnotation)logicalType;
                return new BigDecimalType(decimal.getScale(), decimal.getPrecision());
            }
            PrimitiveType.PrimitiveTypeName primitiveTypeName = parquetField.asPrimitiveType().getPrimitiveTypeName();
            if (logicalType.equals(LogicalTypeAnnotation.uuidType()) && primitiveTypeName == PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY) {
                return UUID_TYPE;
            }
            if (logicalType.equals(LogicalTypeAnnotation.dateType()) && primitiveTypeName == PrimitiveType.PrimitiveTypeName.INT32) {
                return LOCAL_DATE_TYPE;
            }
            if (logicalType instanceof LogicalTypeAnnotation.TimeLogicalTypeAnnotation && (primitiveTypeName == PrimitiveType.PrimitiveTypeName.INT32 || primitiveTypeName == PrimitiveType.PrimitiveTypeName.INT64)) {
                return LOCAL_TIME_TYPE;
            }
            if (logicalType instanceof LogicalTypeAnnotation.TimestampLogicalTypeAnnotation) {
                LogicalTypeAnnotation.TimestampLogicalTypeAnnotation timeStamp = (LogicalTypeAnnotation.TimestampLogicalTypeAnnotation)logicalType;
                if (primitiveTypeName == PrimitiveType.PrimitiveTypeName.INT64) {
                    if (timeStamp.isAdjustedToUTC()) {
                        return INSTANT_TYPE;
                    }
                    return LOCAL_DATE_TIME_TYPE;
                }
            }
            if (logicalType instanceof LogicalTypeAnnotation.GeometryLogicalTypeAnnotation) {
                LogicalTypeAnnotation.GeometryLogicalTypeAnnotation geometry = (LogicalTypeAnnotation.GeometryLogicalTypeAnnotation)logicalType;
                String crs = geometry.getCrs();
                return new GeometryType(crs);
            }
            if (logicalType instanceof LogicalTypeAnnotation.GeographyLogicalTypeAnnotation) {
                LogicalTypeAnnotation.GeographyLogicalTypeAnnotation geography = (LogicalTypeAnnotation.GeographyLogicalTypeAnnotation)logicalType;
                String crs = geography.getCrs();
                EdgeInterpolationAlgorithm algorithm = geography.getAlgorithm();
                return new GeographyType(crs, algorithm);
            }
            return null;
        }
    }

    private static class BinaryAnnotatedType
    implements BasicTypes {
        private final String annotation;
        private final String object;

        public BinaryAnnotatedType(String annotation, String object) {
            this.annotation = annotation;
            this.object = object;
        }

        @Override
        public String object() {
            return "@" + this.annotation + " " + this.object;
        }
    }

    private static class BigDecimalType
    implements BasicTypes {
        private final int scale;
        private final int precision;

        public BigDecimalType(int scale, int precision) {
            this.scale = scale;
            this.precision = precision;
        }

        @Override
        public String object() {
            return "@PrecisionScale(precision = " + this.precision + ", scale = " + this.scale + ") BigDecimal";
        }
    }

    private static class GeographyType
    implements BasicTypes {
        private final String csr;
        private final EdgeInterpolationAlgorithm algorithm;

        public GeographyType(String csr, EdgeInterpolationAlgorithm algorithm) {
            this.csr = csr;
            this.algorithm = algorithm;
        }

        @Override
        public String object() {
            String csrParam;
            String algoParam = this.algorithm != null ? "algorithm=" + this.algorithm.name() : "";
            String string = csrParam = this.csr != null ? "csr=\"" + this.csr + "\"" : "";
            if (csrParam.isEmpty() && algoParam.isEmpty()) {
                return "@ParquetGeography";
            }
            String params = new StringJoiner(", ").add(csrParam).add("EdgeInterpolationAlgorithm." + algoParam).toString();
            return "@ParquetGeography(" + params + ")";
        }
    }

    private static class GeometryType
    implements BasicTypes {
        private final String csr;

        public GeometryType(String csr) {
            this.csr = csr;
        }

        @Override
        public String object() {
            if (this.csr != null) {
                return "@ParquetGeometry(" + this.csr + ")";
            }
            return "@ParquetGeometry";
        }
    }

    private static interface BasicTypes {
        default public String primitive() {
            return null;
        }

        public String object();
    }

    private record RecordField(FieldType fieldType, String name) {
        public RecordField(FieldType type, Type parquetField) {
            this(type, parquetField.getName());
        }
    }

    private record RecordType(RecordMetadata recordClass) implements FieldType
    {
        @Override
        public String getJavaType() {
            return this.recordClass.recorddName;
        }
    }

    private record MapType(FieldType keyType, FieldType valueType) implements FieldType
    {
        @Override
        public String getJavaType() {
            return "Map<" + this.keyType.getJavaType() + ", " + this.valueType.getJavaType() + ">";
        }
    }

    private record ListType(FieldType listType) implements FieldType
    {
        @Override
        public String getJavaType() {
            return "List<" + this.listType.getJavaType() + ">";
        }
    }

    private record BasicType(BasicTypes type, boolean notNull) implements FieldType
    {
        @Override
        public String getJavaType() {
            return this.notNull ? this.type.primitive() : this.type.object();
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static interface FieldType {
        public String getJavaType();
    }

    private record RecordMetadata(GroupType groupType, String recorddName, List<RecordField> fields) {
        public RecordMetadata(GroupType groupType, String inheritedName) {
            this(groupType, CarpetRecordGenerator.extractClassName(inheritedName), new ArrayList<RecordField>());
        }
    }
}

