/*
 * Decompiled with CFR 0.152.
 */
package com.jerolba.carpet.impl.write;

import com.jerolba.carpet.WriteModelFactory;
import com.jerolba.carpet.impl.write.CarpetWriteConfiguration;
import com.jerolba.carpet.impl.write.CarpetWriteSupport;
import com.jerolba.carpet.impl.write.JavaRecord2WriteModel;
import com.jerolba.carpet.impl.write.WriteRecordModelWriteSupport;
import com.jerolba.carpet.model.WriteRecordModelType;
import java.util.Map;
import org.apache.parquet.conf.ParquetConfiguration;
import org.apache.parquet.hadoop.api.WriteSupport;

public class WriteSupportFactory {
    private WriteSupportFactory() {
    }

    public static <T> WriteSupport<T> createWriteSupport(Class<T> recordClass, Map<String, String> extraMetaData, ParquetConfiguration parquetConfiguration, CarpetWriteConfiguration carpetConfiguration, WriteModelFactory<T> writeModelFactory) {
        if (writeModelFactory == null) {
            if (parquetConfiguration.getBoolean("parquet.carpet.useJavaRecord2WriteModel", false)) {
                JavaRecord2WriteModel javaRecord2WriteModel = new JavaRecord2WriteModel(carpetConfiguration);
                WriteRecordModelType<T> rootWriteRecordModel = javaRecord2WriteModel.createModel(recordClass);
                return new WriteRecordModelWriteSupport<T>(rootWriteRecordModel, extraMetaData, carpetConfiguration);
            }
            return new CarpetWriteSupport<T>(recordClass, extraMetaData, carpetConfiguration);
        }
        WriteModelFactory.WriteConfigurationContext writeConfigurationContext = new WriteModelFactory.WriteConfigurationContext(carpetConfiguration, parquetConfiguration);
        WriteRecordModelType<T> rootWriteRecordModel = writeModelFactory.create(recordClass, writeConfigurationContext);
        return new WriteRecordModelWriteSupport<T>(rootWriteRecordModel, extraMetaData, carpetConfiguration);
    }
}

