/*
 * Decompiled with CFR 0.152.
 */
package com.jerolba.carpet.impl.write;

import com.jerolba.carpet.AnnotatedLevels;
import com.jerolba.carpet.RecordTypeConversionException;
import com.jerolba.carpet.impl.write.CarpetWriteConfiguration;
import com.jerolba.carpet.impl.write.CollectionsWriters;
import com.jerolba.carpet.impl.write.FieldWriterConsumer;
import com.jerolba.carpet.impl.write.ModelFieldsWriter;
import com.jerolba.carpet.impl.write.RecordField;
import com.jerolba.carpet.impl.write.WriteModelField;
import com.jerolba.carpet.model.CollectionType;
import com.jerolba.carpet.model.FieldType;
import com.jerolba.carpet.model.MapType;
import com.jerolba.carpet.model.WriteField;
import com.jerolba.carpet.model.WriteRecordModelType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.parquet.io.api.RecordConsumer;

class WriteRecordModelWriter {
    private final RecordConsumer recordConsumer;
    private final CarpetWriteConfiguration carpetConfiguration;
    private final List<Consumer<Object>> fieldWriters = new ArrayList<Consumer<Object>>();

    public WriteRecordModelWriter(RecordConsumer recordConsumer, WriteRecordModelType<?> writeRecordModelType, CarpetWriteConfiguration carpetConfiguration) {
        this.recordConsumer = recordConsumer;
        this.carpetConfiguration = carpetConfiguration;
        int idx = 0;
        for (WriteField<?> field : writeRecordModelType.getFields()) {
            Consumer<Object> writer = this.buildFieldWriter(recordConsumer, idx, field);
            if (writer == null) {
                throw new RuntimeException(field.fieldType().getClass().getName() + " can not be serialized");
            }
            this.fieldWriters.add(writer);
            ++idx;
        }
    }

    public void write(Object record) {
        for (Consumer<Object> fieldWriter : this.fieldWriters) {
            fieldWriter.accept(record);
        }
    }

    private Consumer<Object> buildFieldWriter(RecordConsumer recordConsumer, int idx, WriteField<?> field) {
        if (field instanceof WriteRecordModelType.PrimitiveJavaFieldInfo) {
            WriteRecordModelType.PrimitiveJavaFieldInfo primitiveJavaField = (WriteRecordModelType.PrimitiveJavaFieldInfo)field;
            return ModelFieldsWriter.buildPrimitiveJavaConsumer(primitiveJavaField, idx, recordConsumer);
        }
        if (field instanceof WriteRecordModelType.FunctionFieldInfo) {
            WriteRecordModelType.FunctionFieldInfo functionField = (WriteRecordModelType.FunctionFieldInfo)field;
            Function<Object, Object> accessor = functionField.accessor();
            WriteModelField modelField = new WriteModelField(field.parquetFieldName(), idx, accessor);
            FieldType type = field.fieldType();
            if (type instanceof CollectionType) {
                CollectionType collectionType = (CollectionType)type;
                return this.createCollectionWriter(collectionType, modelField);
            }
            if (type instanceof MapType) {
                MapType mapType = (MapType)type;
                return this.createMapStructureWriter(mapType, modelField);
            }
            BiConsumer<RecordConsumer, Object> basicTypeWriter = ModelFieldsWriter.buildSimpleElementConsumer(type, recordConsumer, this.carpetConfiguration);
            if (basicTypeWriter != null) {
                return new FieldWriterConsumer(recordConsumer, modelField, basicTypeWriter);
            }
        }
        return null;
    }

    private Consumer<Object> createCollectionWriter(CollectionType collectionType, RecordField recordField) {
        return switch (this.carpetConfiguration.annotatedLevels()) {
            default -> throw new IncompatibleClassChangeError();
            case AnnotatedLevels.ONE -> this.createOneLevelStructureWriter(collectionType.type(), recordField);
            case AnnotatedLevels.TWO -> this.createTwoLevelStructureWriter(collectionType.type(), recordField);
            case AnnotatedLevels.THREE -> this.createThreeLevelStructureWriter(collectionType.type(), recordField);
        };
    }

    private Consumer<Object> createOneLevelStructureWriter(FieldType parametized, RecordField recordField) {
        if (parametized instanceof CollectionType) {
            throw new RecordTypeConversionException("Nested collection in a collection is not supported in single level structure codification");
        }
        BiConsumer<RecordConsumer, Object> elemConsumer = null;
        if (parametized instanceof MapType) {
            MapType mapType = (MapType)parametized;
            Consumer<Object> childWriter = this.createMapStructureWriter(mapType, null);
            elemConsumer = (consumer, v) -> childWriter.accept(v);
        } else {
            elemConsumer = ModelFieldsWriter.buildSimpleElementConsumer(parametized, this.recordConsumer, this.carpetConfiguration);
        }
        if (elemConsumer == null) {
            throw new RecordTypeConversionException("Unsuported type in collection");
        }
        return new CollectionsWriters.OneLevelCollectionFieldWriter(this.recordConsumer, recordField, elemConsumer);
    }

    private Consumer<Object> createTwoLevelStructureWriter(FieldType parametized, RecordField recordField) {
        BiConsumer<RecordConsumer, Object> elemConsumer = null;
        if (parametized instanceof CollectionType) {
            CollectionType collectionType = (CollectionType)parametized;
            Consumer<Object> childWriter = this.createTwoLevelStructureWriter(collectionType.type(), null);
            elemConsumer = (consumer, v) -> childWriter.accept(v);
        } else if (parametized instanceof MapType) {
            MapType mapType = (MapType)parametized;
            Consumer<Object> childWriter = this.createMapStructureWriter(mapType, null);
            elemConsumer = (consumer, v) -> childWriter.accept(v);
        } else {
            elemConsumer = ModelFieldsWriter.buildSimpleElementConsumer(parametized, this.recordConsumer, this.carpetConfiguration);
        }
        if (elemConsumer == null) {
            throw new RecordTypeConversionException("Unsuported type in collection");
        }
        if (recordField != null) {
            return new CollectionsWriters.TwoLevelCollectionRecordFieldWriter(this.recordConsumer, recordField, elemConsumer);
        }
        BiConsumer<RecordConsumer, Object> innerStructureWriter = elemConsumer;
        return value -> {
            Collection coll = (Collection)value;
            if (coll != null) {
                CollectionsWriters.TwoLevelCollectionRecordFieldWriter.writeGroupElementTwo(this.recordConsumer, innerStructureWriter, coll);
            }
        };
    }

    private Consumer<Object> createThreeLevelStructureWriter(FieldType parametized, RecordField recordField) {
        BiConsumer<RecordConsumer, Object> elemConsumer = null;
        if (parametized instanceof CollectionType) {
            CollectionType collectionType = (CollectionType)parametized;
            Consumer<Object> childWriter = this.createThreeLevelStructureWriter(collectionType.type(), null);
            elemConsumer = (consumer, v) -> childWriter.accept(v);
        } else if (parametized instanceof MapType) {
            MapType mapType = (MapType)parametized;
            Consumer<Object> childWriter = this.createMapStructureWriter(mapType, null);
            elemConsumer = (consumer, v) -> childWriter.accept(v);
        } else {
            elemConsumer = ModelFieldsWriter.buildSimpleElementConsumer(parametized, this.recordConsumer, this.carpetConfiguration);
        }
        if (elemConsumer == null) {
            throw new RecordTypeConversionException("Unsuported type in collection");
        }
        if (recordField != null) {
            return new CollectionsWriters.ThreeLevelCollectionRecordFieldWriter(this.recordConsumer, recordField, elemConsumer);
        }
        BiConsumer<RecordConsumer, Object> innerStructureWriter = elemConsumer;
        return value -> {
            Collection coll = (Collection)value;
            if (coll != null) {
                this.recordConsumer.startGroup();
                if (!coll.isEmpty()) {
                    CollectionsWriters.ThreeLevelCollectionRecordFieldWriter.writeGroupElementThree(this.recordConsumer, innerStructureWriter, coll);
                }
                this.recordConsumer.endGroup();
            }
        };
    }

    private Consumer<Object> createMapStructureWriter(MapType mapType, RecordField recordField) {
        BiConsumer<RecordConsumer, Object> elemKeyConsumer = null;
        FieldType keyType = mapType.keyType();
        elemKeyConsumer = ModelFieldsWriter.buildSimpleElementConsumer(keyType, this.recordConsumer, this.carpetConfiguration);
        BiConsumer<RecordConsumer, Object> elemValueConsumer = null;
        FieldType fieldType = mapType.valueType();
        if (fieldType instanceof CollectionType) {
            CollectionType valueCollectionType = (CollectionType)fieldType;
            childWriter = this.createCollectionWriter(valueCollectionType, null);
            elemValueConsumer = (arg_0, arg_1) -> WriteRecordModelWriter.lambda$createMapStructureWriter$7((Consumer)childWriter, arg_0, arg_1);
        } else {
            childWriter = mapType.valueType();
            if (childWriter instanceof MapType) {
                MapType valueMapType = (MapType)childWriter;
                childWriter = this.createMapStructureWriter(valueMapType, null);
                elemValueConsumer = (consumer, v) -> childWriter.accept(v);
            } else {
                elemValueConsumer = ModelFieldsWriter.buildSimpleElementConsumer(mapType.valueType(), this.recordConsumer, this.carpetConfiguration);
            }
        }
        if (elemValueConsumer == null || elemKeyConsumer == null) {
            throw new RecordTypeConversionException("Unsuported type in Map");
        }
        if (recordField != null) {
            return new CollectionsWriters.MapRecordFieldWriter(this.recordConsumer, recordField, elemKeyConsumer, elemValueConsumer);
        }
        BiConsumer<RecordConsumer, Object> innerKeyStructureWriter = elemKeyConsumer;
        BiConsumer<RecordConsumer, Object> innerValueStructureWriter = elemValueConsumer;
        return value -> {
            if (value != null) {
                Map map = (Map)value;
                this.recordConsumer.startGroup();
                if (!map.isEmpty()) {
                    CollectionsWriters.MapRecordFieldWriter.writeKeyalueGroup(this.recordConsumer, innerKeyStructureWriter, innerValueStructureWriter, map);
                }
                this.recordConsumer.endGroup();
            }
        };
    }

    private static /* synthetic */ void lambda$createMapStructureWriter$7(Consumer childWriter, RecordConsumer consumer, Object v) {
        childWriter.accept(v);
    }
}

