/*
 * Decompiled with CFR 0.152.
 */
package com.jerolba.carpet.impl.write;

import com.jerolba.carpet.impl.write.CarpetWriteConfiguration;
import com.jerolba.carpet.impl.write.WriteRecordModel2Schema;
import com.jerolba.carpet.impl.write.WriteRecordModelWriter;
import com.jerolba.carpet.model.WriteRecordModelType;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.parquet.conf.ParquetConfiguration;
import org.apache.parquet.hadoop.api.WriteSupport;
import org.apache.parquet.io.api.RecordConsumer;
import org.apache.parquet.schema.MessageType;

class WriteRecordModelWriteSupport<T>
extends WriteSupport<T> {
    private final WriteRecordModelType<T> rootWriteRecordModel;
    private final Map<String, String> extraMetaData;
    private final CarpetWriteConfiguration carpetConfiguration;
    private MessageWriter<T> messageWriter;

    WriteRecordModelWriteSupport(WriteRecordModelType<T> rootWriteRecordModel, Map<String, String> extraMetaData, CarpetWriteConfiguration carpetConfiguration) {
        this.rootWriteRecordModel = rootWriteRecordModel;
        this.extraMetaData = extraMetaData;
        this.carpetConfiguration = carpetConfiguration;
    }

    public String getName() {
        return this.rootWriteRecordModel.getClassType().getName();
    }

    public WriteSupport.WriteContext init(Configuration configuration) {
        return this.initContext();
    }

    public WriteSupport.WriteContext init(ParquetConfiguration configuration) {
        return this.initContext();
    }

    private WriteSupport.WriteContext initContext() {
        WriteRecordModel2Schema modelRecord2Schema = new WriteRecordModel2Schema(this.carpetConfiguration);
        MessageType schema = modelRecord2Schema.createSchema(this.rootWriteRecordModel);
        return new WriteSupport.WriteContext(schema, this.extraMetaData);
    }

    public void prepareForWrite(RecordConsumer recordConsumer) {
        try {
            this.messageWriter = new MessageWriter<T>(recordConsumer, this.rootWriteRecordModel, this.carpetConfiguration);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public void write(T record) {
        this.messageWriter.write(record);
    }

    private static class MessageWriter<T> {
        private final RecordConsumer recordConsumer;
        private final WriteRecordModelWriter writer;

        MessageWriter(RecordConsumer recordConsumer, WriteRecordModelType<T> rootWriteRecordModel, CarpetWriteConfiguration carpetConfiguration) {
            this.recordConsumer = recordConsumer;
            this.writer = new WriteRecordModelWriter(recordConsumer, rootWriteRecordModel, carpetConfiguration);
        }

        void write(T record) {
            this.recordConsumer.startMessage();
            this.writer.write(record);
            this.recordConsumer.endMessage();
        }
    }
}

