/*
 * Decompiled with CFR 0.152.
 */
package com.jerolba.carpet.impl.write;

import java.lang.invoke.CallSite;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.RecordComponent;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

public class Reflection {
    private static final ConcurrentHashMap<CacheKey, Function<Object, Object>> ACCESSOR_CACHE = new ConcurrentHashMap();

    private Reflection() {
    }

    public static Function<Object, Object> recordAccessor(Class<?> targetClass, RecordComponent recordComponent) {
        return Reflection.cachedFieldAccessor(targetClass, recordComponent.getName(), recordComponent.getType());
    }

    public static Function<Object, Object> recordAccessor(Class<?> targetClass, Field classField) {
        return Reflection.cachedFieldAccessor(targetClass, classField.getName(), classField.getType());
    }

    private static Function<Object, Object> cachedFieldAccessor(Class<?> targetClass, String name, Class<?> fieldType) {
        CacheKey cacheKey = new CacheKey(targetClass, name, fieldType);
        return ACCESSOR_CACHE.computeIfAbsent(cacheKey, k -> Reflection.fieldAccessor(targetClass, name, fieldType));
    }

    private static Function<Object, Object> fieldAccessor(Class<?> targetClass, String name, Class<?> fieldType) {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            MethodHandle findVirtual = lookup.findVirtual(targetClass, name, MethodType.methodType(fieldType));
            CallSite site = LambdaMetafactory.metafactory(lookup, "apply", MethodType.methodType(Function.class), MethodType.methodType(Object.class, Object.class), findVirtual, MethodType.methodType(fieldType, targetClass));
            return site.getTarget().invokeExact();
        }
        catch (IllegalAccessException e) {
            try {
                Method m = targetClass.getDeclaredMethod(name, new Class[0]);
                m.setAccessible(true);
                MethodHandle pmh = lookup.unreflect(m);
                return obj -> {
                    try {
                        return pmh.invoke(obj);
                    }
                    catch (Throwable e1) {
                        throw new RuntimeException(e1);
                    }
                };
            }
            catch (IllegalAccessException | NoSuchMethodException em) {
                throw new RuntimeException(em);
            }
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    private static class CacheKey {
        private final Class<?> targetClass;
        private final String fieldName;
        private final Class<?> fieldType;

        public CacheKey(Class<?> targetClass, String fieldName, Class<?> fieldType) {
            this.targetClass = targetClass;
            this.fieldName = fieldName;
            this.fieldType = fieldType;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)obj;
            return this.targetClass == cacheKey.targetClass && this.fieldName.equals(cacheKey.fieldName) && this.fieldType == cacheKey.fieldType;
        }

        public int hashCode() {
            return System.identityHashCode(this.targetClass) ^ this.fieldName.hashCode() ^ System.identityHashCode(this.fieldType);
        }
    }
}

