/*
 * Decompiled with CFR 0.152.
 */
package com.jerolba.carpet.impl.read.converter;

import java.time.LocalDate;
import java.util.function.Consumer;
import org.apache.parquet.column.Dictionary;
import org.apache.parquet.io.api.PrimitiveConverter;

public class LocalDateConverter
extends PrimitiveConverter {
    private LocalDate[] dict = null;
    private final Consumer<Object> consumer;

    public LocalDateConverter(Consumer<Object> consumer) {
        this.consumer = consumer;
    }

    public void addInt(int daysFromEpoch) {
        this.consumer.accept(LocalDate.ofEpochDay(daysFromEpoch));
    }

    public boolean hasDictionarySupport() {
        return true;
    }

    public void setDictionary(Dictionary dictionary) {
        int maxId = dictionary.getMaxId();
        this.dict = new LocalDate[maxId + 1];
        for (int i = 0; i <= maxId; ++i) {
            this.dict[i] = this.convert(dictionary.decodeToInt(i));
        }
    }

    public void addValueFromDictionary(int dictionaryId) {
        this.consumer.accept(this.dict[dictionaryId]);
    }

    private LocalDate convert(int daysFromEpoch) {
        return LocalDate.ofEpochDay(daysFromEpoch);
    }
}

