/*
 * Decompiled with CFR 0.152.
 */
package com.jerolba.carpet.impl.read;

import com.jerolba.carpet.FieldMatchingStrategy;
import com.jerolba.carpet.impl.AliasField;
import com.jerolba.carpet.impl.CaseConverter;
import java.lang.reflect.RecordComponent;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.Type;

public class ColumnToFieldMapper {
    private final FieldMatchingStrategy fieldMatchingStrategy;

    public ColumnToFieldMapper(FieldMatchingStrategy fieldMatchingStrategy) {
        this.fieldMatchingStrategy = fieldMatchingStrategy;
    }

    public Map<String, NameMap> mapFields(GroupType schema, RecordComponent[] recordComponent) {
        RecordMapper mapper = new RecordMapper(recordComponent, schema);
        mapper.mapWith(AliasField::getComponentAlias);
        if (this.fieldMatchingStrategy == FieldMatchingStrategy.FIELD_NAME || this.fieldMatchingStrategy == FieldMatchingStrategy.BEST_EFFORT) {
            mapper.mapWith(RecordComponent::getName);
        }
        if (this.fieldMatchingStrategy == FieldMatchingStrategy.SNAKE_CASE || this.fieldMatchingStrategy == FieldMatchingStrategy.BEST_EFFORT) {
            mapper.mapWith(component -> CaseConverter.camelCaseToSnakeCase(component.getName()));
        }
        return mapper.getResult();
    }

    private class RecordMapper {
        private final Map<String, NameMap> result = new HashMap<String, NameMap>();
        private final RecordComponent[] recordComponents;
        private final Map<String, Type> parquetIndexed;

        public RecordMapper(RecordComponent[] recordComponents, GroupType schema) {
            this.recordComponents = recordComponents;
            this.parquetIndexed = schema.getFields().stream().collect(Collectors.toMap(Type::getName, f -> f));
        }

        public void mapWith(Function<RecordComponent, String> mapper) {
            for (RecordComponent component : this.recordComponents) {
                String toTest;
                Type type;
                if (this.result.containsKey(component.getName()) || (type = this.parquetIndexed.get(toTest = mapper.apply(component))) == null) continue;
                this.result.put(component.getName(), new NameMap(component, type));
            }
        }

        public Map<String, NameMap> getResult() {
            return this.result;
        }
    }

    public record NameMap(RecordComponent recordComponent, Type parquetType) {
    }
}

