/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.maven.plugins.android.phase04processclasses;

import com.jayway.maven.plugins.android.AbstractAndroidMojo;
import com.jayway.maven.plugins.android.CommandExecutor;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.util.IOUtil;

public class UnpackMojo
extends AbstractAndroidMojo {
    public void execute() throws MojoExecutionException, MojoFailureException {
        CommandExecutor executor = CommandExecutor.Factory.createDefaultCommmandExecutor();
        executor.setLogger(this.getLog());
        File inputFile = new File(this.project.getBuild().getDirectory() + File.separator + this.project.getBuild().getFinalName() + ".jar");
        if (this.generateApk) {
            this.unpackClasses(inputFile);
        }
    }

    private File unpackClasses(File inputFile) throws MojoExecutionException {
        File outputDirectory = new File(this.project.getBuild().getDirectory(), "android-classes");
        for (Artifact artifact : this.getRelevantCompileArtifacts()) {
            if (artifact.getFile().isDirectory()) {
                try {
                    FileUtils.copyDirectory((File)artifact.getFile(), (File)outputDirectory);
                    continue;
                }
                catch (IOException e) {
                    throw new MojoExecutionException("IOException while copying " + artifact.getFile().getAbsolutePath() + " into " + outputDirectory.getAbsolutePath(), (Exception)e);
                }
            }
            try {
                this.unjar(new JarFile(artifact.getFile()), outputDirectory);
            }
            catch (IOException e) {
                throw new MojoExecutionException("IOException while unjarring " + artifact.getFile().getAbsolutePath() + " into " + outputDirectory.getAbsolutePath(), (Exception)e);
            }
        }
        try {
            this.unjar(new JarFile(inputFile), outputDirectory);
        }
        catch (IOException e) {
            throw new MojoExecutionException("IOException while unjarring " + inputFile.getAbsolutePath() + " into " + outputDirectory.getAbsolutePath(), (Exception)e);
        }
        return outputDirectory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unjar(JarFile jarFile, File outputDirectory) throws IOException {
        Enumeration<JarEntry> en = jarFile.entries();
        while (en.hasMoreElements()) {
            JarEntry entry = en.nextElement();
            File entryFile = new File(outputDirectory, entry.getName());
            if (!entryFile.getParentFile().exists() && !entry.getName().startsWith("META-INF")) {
                entryFile.getParentFile().mkdirs();
            }
            if (entry.isDirectory() || !entry.getName().endsWith(".class")) continue;
            InputStream in = jarFile.getInputStream(entry);
            try {
                FileOutputStream out = new FileOutputStream(entryFile);
                try {
                    IOUtil.copy((InputStream)in, (OutputStream)out);
                }
                finally {
                    IOUtils.closeQuietly((OutputStream)out);
                }
            }
            finally {
                IOUtils.closeQuietly((InputStream)in);
            }
        }
    }
}

