/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.parser.state;

import com.itextpdf.tool.xml.parser.State;
import com.itextpdf.tool.xml.parser.TagState;
import com.itextpdf.tool.xml.parser.XMLParser;
import java.util.ArrayList;
import java.util.List;

public class InsideTagHTMLState
implements State {
    private final XMLParser parser;
    private int lastChar = 32;
    private final List<String> noSanitize = new ArrayList<String>(1);
    private final List<String> ignoreLastChars = new ArrayList<String>(9);

    public InsideTagHTMLState(XMLParser parser) {
        this.parser = parser;
        this.noSanitize.add("pre");
        this.ignoreLastChars.add("p");
        this.ignoreLastChars.add("div");
        this.ignoreLastChars.add("h1");
        this.ignoreLastChars.add("h2");
        this.ignoreLastChars.add("h3");
        this.ignoreLastChars.add("h4");
        this.ignoreLastChars.add("h5");
        this.ignoreLastChars.add("h6");
        this.ignoreLastChars.add("td");
        this.ignoreLastChars.add("th");
        this.ignoreLastChars.add("ul");
        this.ignoreLastChars.add("ol");
        this.ignoreLastChars.add("li");
        this.ignoreLastChars.add("dd");
        this.ignoreLastChars.add("dt");
        this.ignoreLastChars.add("hr");
        this.ignoreLastChars.add("br");
    }

    public void process(int character) {
        if (character == 60) {
            if (this.parser.bufferSize() > 0) {
                this.parser.text(this.parser.current());
            }
            this.parser.flush();
            this.parser.selectState().tagEncountered();
        } else if (character == 38) {
            this.parser.selectState().specialChar();
        } else {
            String tag = this.parser.currentTag();
            TagState state = this.parser.currentTagState();
            if (this.noSanitize.contains(tag) && TagState.OPEN == state) {
                this.parser.append(character);
            } else {
                boolean noWhiteSpace;
                if (this.parser.memory().whitespaceTag().length() != 0) {
                    if (this.ignoreLastChars.contains(this.parser.memory().whitespaceTag())) {
                        this.lastChar = 32;
                    }
                    this.parser.memory().whitespaceTag("");
                }
                boolean whitespace = Character.isWhitespace(this.lastChar);
                boolean bl = noWhiteSpace = !Character.isWhitespace(character);
                if (!whitespace || whitespace && noWhiteSpace) {
                    if (noWhiteSpace) {
                        this.parser.append(character);
                    } else {
                        this.parser.append(' ');
                    }
                }
                this.lastChar = character;
            }
        }
    }
}

