/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.css.apply;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.html.HtmlUtilities;
import com.itextpdf.text.pdf.draw.LineSeparator;
import com.itextpdf.tool.xml.Tag;
import com.itextpdf.tool.xml.css.CssApplier;
import com.itextpdf.tool.xml.css.CssUtils;
import com.itextpdf.tool.xml.pipeline.html.HtmlPipelineContext;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LineSeparatorCssApplier
implements CssApplier<LineSeparator> {
    private final HtmlPipelineContext configuration;

    public LineSeparatorCssApplier(HtmlPipelineContext htmlPipelineContext) {
        this.configuration = htmlPipelineContext;
    }

    @Override
    public LineSeparator apply(LineSeparator ls, Tag t) {
        float lineWidth = 1.0f;
        Map<String, String> css = t.getCSS();
        if (css.get("height") != null) {
            lineWidth = CssUtils.getInstance().parsePxInCmMmPcToPt(css.get("height"));
        }
        ls.setLineWidth(lineWidth);
        BaseColor lineColor = BaseColor.BLACK;
        if (css.get("color") != null) {
            lineColor = HtmlUtilities.decodeColor((String)css.get("color"));
        } else if (css.get("background-color") != null) {
            lineColor = HtmlUtilities.decodeColor((String)css.get("background-color"));
        }
        ls.setLineColor(lineColor);
        float percentage = 100.0f;
        String widthStr = css.get("width");
        if (widthStr != null) {
            percentage = widthStr.contains("%") ? Float.parseFloat(widthStr.replace("%", "")) : CssUtils.getInstance().parsePxInCmMmPcToPt(widthStr) / this.configuration.getPageSize().getWidth() * 100.0f;
        }
        ls.setPercentage(percentage);
        ls.setOffset(9.0f);
        return ls;
    }
}

