/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services;

import com.obs.services.IObsCredentialsProvider;
import com.obs.services.internal.security.BasicSecurityKey;
import com.obs.services.model.ISecurityKey;

public class BasicObsCredentialsProvider
implements IObsCredentialsProvider {
    private volatile ISecurityKey securityKey;

    public BasicObsCredentialsProvider(ISecurityKey securityKey) {
        this.setSecurityKey(securityKey);
    }

    public BasicObsCredentialsProvider(String accessKey, String secretKey) {
        this(accessKey, secretKey, null);
    }

    public BasicObsCredentialsProvider(String accessKey, String secretKey, String securityToken) {
        BasicObsCredentialsProvider.checkSecurityKey(accessKey, secretKey);
        this.setSecurityKey(new BasicSecurityKey(accessKey, secretKey, securityToken));
    }

    private static void checkSecurityKey(String accessKey, String secretKey) {
        if (accessKey == null) {
            throw new IllegalArgumentException("accessKey should not be null.");
        }
        if (secretKey == null) {
            throw new IllegalArgumentException("secretKey should not be null.");
        }
    }

    @Override
    public void setSecurityKey(ISecurityKey securityKey) {
        if (securityKey == null) {
            throw new IllegalArgumentException("securityKey should not be null.");
        }
        BasicObsCredentialsProvider.checkSecurityKey(securityKey.getAccessKey(), securityKey.getSecretKey());
        this.securityKey = securityKey;
    }

    @Override
    public ISecurityKey getSecurityKey() {
        if (this.securityKey == null) {
            throw new IllegalArgumentException("Invalid securityKey");
        }
        return this.securityKey;
    }
}

