/*
 * Decompiled with CFR 0.152.
 */
package com.helger.text;

import com.helger.annotation.OverridingMethodsMustInvokeSuper;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.ReturnsMutableObject;
import com.helger.base.callback.CallbackList;
import com.helger.base.callback.IChangeCallback;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.iface.IHasSize;
import com.helger.base.state.EChange;
import com.helger.base.state.EContinue;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.ICommonsOrderedMap;
import com.helger.text.AbstractReadOnlyMapBasedMultilingualText;
import com.helger.text.IMultilingualText;
import com.helger.text.IMutableMultilingualText;
import com.helger.text.locale.LocaleHelper;
import java.util.Locale;
import java.util.Map;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@NotThreadSafe
public abstract class AbstractMapBasedMultilingualText
extends AbstractReadOnlyMapBasedMultilingualText
implements IMutableMultilingualText {
    private final transient CallbackList<IChangeCallback<IMutableMultilingualText>> m_aChangeNotifyCallbacks = new CallbackList();

    protected AbstractMapBasedMultilingualText() {
    }

    protected AbstractMapBasedMultilingualText(@NonNull ICommonsOrderedMap<Locale, String> iCommonsOrderedMap) {
        super(iCommonsOrderedMap);
    }

    private @NonNull EContinue _beforeChange() {
        return this.m_aChangeNotifyCallbacks.forEachBreakable(iChangeCallback -> iChangeCallback.beforeChange((Object)this));
    }

    private void _afterChange() {
        this.m_aChangeNotifyCallbacks.forEach(iChangeCallback -> iChangeCallback.afterChange((Object)this));
    }

    @Override
    public final @NonNull EChange addText(@NonNull Locale locale, @Nullable String string) {
        ValueEnforcer.notNull((Object)locale, (String)"ContentLocale");
        if (this.texts().containsKey((Object)locale)) {
            return EChange.UNCHANGED;
        }
        if (this._beforeChange().isBreak()) {
            return EChange.UNCHANGED;
        }
        this.internalAddText(locale, string);
        this._afterChange();
        return EChange.CHANGED;
    }

    @Override
    public final @NonNull EChange setText(@NonNull Locale locale, @Nullable String string) {
        ValueEnforcer.notNull((Object)locale, (String)"ContentLocale");
        if (this.texts().containsKey((Object)locale)) {
            String string2 = this.internalGetText(locale);
            if (EqualsHelper.equals((Object)string2, (Object)string)) {
                return EChange.UNCHANGED;
            }
            if (this._beforeChange().isBreak()) {
                return EChange.UNCHANGED;
            }
            this.internalSetText(locale, string);
        } else {
            if (this._beforeChange().isBreak()) {
                return EChange.UNCHANGED;
            }
            this.internalAddText(locale, string);
        }
        this._afterChange();
        return EChange.CHANGED;
    }

    @Override
    public final @NonNull EChange removeText(@NonNull Locale locale) {
        ValueEnforcer.notNull((Object)locale, (String)"ContentLocale");
        for (Locale locale2 : LocaleHelper.getCalculatedLocaleListForResolving(locale)) {
            if (!this.texts().containsKey((Object)locale2)) continue;
            if (this._beforeChange().isBreak()) {
                return EChange.UNCHANGED;
            }
            this.texts().remove((Object)locale2);
            this._afterChange();
            return EChange.CHANGED;
        }
        return EChange.UNCHANGED;
    }

    public final @NonNull EChange removeAll() {
        if (this.texts().isEmpty() || this._beforeChange().isBreak()) {
            return EChange.UNCHANGED;
        }
        this.texts().clear();
        this._afterChange();
        return EChange.CHANGED;
    }

    @Override
    public final @NonNull EChange assignFrom(@NonNull IMultilingualText iMultilingualText) {
        ValueEnforcer.notNull((Object)iMultilingualText, (String)"MLT");
        if (this.texts().equals(iMultilingualText.texts()) || this._beforeChange().isBreak()) {
            return EChange.UNCHANGED;
        }
        this.texts().clear();
        for (Map.Entry entry : iMultilingualText.texts().entrySet()) {
            this.internalAddText(entry);
        }
        this._afterChange();
        return EChange.CHANGED;
    }

    @Override
    @ReturnsMutableObject(value="design")
    public final @NonNull CallbackList<IChangeCallback<IMutableMultilingualText>> changeNotifyCallbacks() {
        return this.m_aChangeNotifyCallbacks;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        return super.equals(object);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).appendIf("ChangeNotifyCallbacks", this.m_aChangeNotifyCallbacks, IHasSize::isNotEmpty).getToString();
    }
}

