/*
 * Decompiled with CFR 0.152.
 */
package com.helger.base.codec;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.codec.IEncoder;
import java.nio.charset.Charset;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@FunctionalInterface
public interface IByteArrayEncoder
extends IEncoder<byte[], byte[]> {
    @Nonnegative
    default public int getMaximumEncodedLength(@Nonnegative int n) {
        return n;
    }

    @Override
    @ReturnsMutableCopy
    default public byte @Nullable [] getEncoded(byte @Nullable [] byArray) {
        if (byArray == null) {
            return null;
        }
        return this.getEncoded(byArray, 0, byArray.length);
    }

    @ReturnsMutableCopy
    public byte @Nullable [] getEncoded(byte @Nullable [] var1, @Nonnegative int var2, @Nonnegative int var3);

    @ReturnsMutableCopy
    default public byte @Nullable [] getEncoded(@Nullable String string, @NonNull Charset charset) {
        if (string == null) {
            return null;
        }
        byte[] byArray = string.getBytes(charset);
        return this.getEncoded(byArray);
    }
}

