/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.genericdao.dao.hibernate.original;

import com.googlecode.genericdao.dao.DAOUtil;
import com.googlecode.genericdao.dao.hibernate.HibernateBaseDAO;
import com.googlecode.genericdao.dao.hibernate.original.GenericDAO;
import com.googlecode.genericdao.search.ExampleOptions;
import com.googlecode.genericdao.search.Filter;
import com.googlecode.genericdao.search.ISearch;
import com.googlecode.genericdao.search.Search;
import com.googlecode.genericdao.search.SearchResult;
import java.io.Serializable;
import java.util.List;
import org.hibernate.NonUniqueResultException;

public class GenericDAOImpl<T, ID extends Serializable>
extends HibernateBaseDAO
implements GenericDAO<T, ID> {
    protected Class<T> persistentClass = (Class)DAOUtil.getTypeArguments(GenericDAOImpl.class, this.getClass()).get(0);

    @Override
    public void create(T object) {
        if (!this.persistentClass.isInstance(object)) {
            throw new IllegalArgumentException("Object class does not match dao type.");
        }
        this._save((Object)object);
    }

    @Override
    public boolean createOrUpdate(T object) {
        Serializable id = this.getMetadataUtil().getId(object);
        if (id == null || new Long(0L).equals(id)) {
            this.create(object);
            return true;
        }
        this.update(object);
        return false;
    }

    @Override
    public boolean deleteById(ID id) {
        return this._deleteById((Class<?>)this.persistentClass, (Serializable)id);
    }

    @Override
    public boolean deleteEntity(T object) {
        if (!this.persistentClass.isInstance(object)) {
            throw new IllegalArgumentException("Object class does not match dao type.");
        }
        return this._deleteEntity(object);
    }

    @Override
    public T fetch(ID id) {
        return this._get(this.persistentClass, (Serializable)id);
    }

    @Override
    public List<T> fetchAll() {
        return this._all(this.persistentClass);
    }

    @Override
    public void update(T object) {
        if (!this.persistentClass.isInstance(object)) {
            throw new IllegalArgumentException("Object class does not match dao type.");
        }
        this._update(object);
    }

    @Override
    public List<T> search(ISearch search) {
        if (search == null) {
            return this.fetchAll();
        }
        return this._search(this.persistentClass, search);
    }

    @Override
    public int count(ISearch search) {
        if (search == null) {
            search = new Search();
        }
        return this._count(this.persistentClass, search);
    }

    @Override
    public SearchResult<T> searchAndCount(ISearch search) {
        if (search == null) {
            SearchResult result = new SearchResult();
            result.setResult(this.fetchAll());
            result.setTotalCount(result.getResult().size());
            return result;
        }
        return this._searchAndCount(this.persistentClass, search);
    }

    @Override
    public boolean isConnected(Object object) {
        return this._sessionContains(object);
    }

    @Override
    public void flush() {
        this._flush();
    }

    @Override
    public void refresh(Object object) {
        this._refresh(object);
    }

    @Override
    public List searchGeneric(ISearch search) {
        if (search == null) {
            return this.fetchAll();
        }
        return this._search(this.persistentClass, search);
    }

    @Override
    public Object searchUnique(ISearch search) throws NonUniqueResultException {
        return this._searchUnique(this.persistentClass, search);
    }

    @Override
    public Filter getFilterFromExample(T example) {
        return this._getFilterFromExample(example);
    }

    @Override
    public Filter getFilterFromExample(T example, ExampleOptions options) {
        return this._getFilterFromExample(example, options);
    }
}

