/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.lint;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.ControlFlowGraph;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.graph.DiGraph;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.JSType;

public class CheckNullableReturn
implements CompilerPass,
NodeTraversal.Callback {
    final AbstractCompiler compiler;
    public static final DiagnosticType NULLABLE_RETURN = DiagnosticType.disabled("JSC_NULLABLE_RETURN", "This function''s return type is nullable, but it always returns a non-null value. Consider making the return type non-nullable.");
    public static final DiagnosticType NULLABLE_RETURN_WITH_NAME = DiagnosticType.disabled("JSC_NULLABLE_RETURN_WITH_NAME", "The return type of the function \"{0}\" is nullable, but it always returns a non-null value. Consider making the return type non-nullable.");

    public CheckNullableReturn(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        if (n.isBlock() && n.hasChildren() && CheckNullableReturn.isReturnTypeNullable(parent) && !CheckNullableReturn.canReturnNull(t.getControlFlowGraph())) {
            String fnName = NodeUtil.getNearestFunctionName(parent);
            if (fnName != null && !fnName.isEmpty()) {
                this.compiler.report(t.makeError(parent, NULLABLE_RETURN_WITH_NAME, fnName));
            } else {
                this.compiler.report(t.makeError(parent, NULLABLE_RETURN, new String[0]));
            }
        }
    }

    private static boolean isReturnTypeNullable(Node n) {
        if (n == null) {
            return false;
        }
        if (!n.isFunction()) {
            return false;
        }
        JSType returnType = n.getJSType().toMaybeFunctionType().getReturnType();
        if (returnType == null || returnType.isUnknownType() || !returnType.isNullable()) {
            return false;
        }
        JSDocInfo info = NodeUtil.getBestJSDocInfo(n);
        return info != null && info.hasReturnType();
    }

    private static boolean canReturnNull(ControlFlowGraph graph) {
        DiGraph.DiGraphNode ir = graph.getImplicitReturn();
        for (DiGraph.DiGraphEdge inEdge : ir.getInEdges()) {
            Node returnValue;
            DiGraph.DiGraphNode graphNode = inEdge.getSource();
            Node possibleReturnNode = (Node)graphNode.getValue();
            if (!possibleReturnNode.isReturn() || (returnValue = possibleReturnNode.getFirstChild()) == null || !CheckNullableReturn.isNullable(returnValue)) continue;
            return true;
        }
        return false;
    }

    private static boolean isNullable(Node n) {
        return n.getJSType().isNullable() || n.isOr() && n.getLastChild().isNull();
    }

    @Override
    public boolean shouldTraverse(NodeTraversal nodeTraversal, Node n, Node parent) {
        return true;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, root, this);
    }
}

