/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.graph;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.javascript.jscomp.graph.Annotation;
import com.google.javascript.jscomp.graph.Graph;
import com.google.javascript.jscomp.graph.GraphNode;
import com.google.javascript.jscomp.graph.GraphvizGraph;
import com.google.javascript.jscomp.graph.SubGraph;
import com.google.javascript.jscomp.graph.UndiGraph;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class LinkedUndirectedGraph<N, E>
extends UndiGraph<N, E>
implements GraphvizGraph {
    protected final Map<N, LinkedUndirectedGraphNode<N, E>> nodes = Maps.newHashMap();
    private final boolean useNodeAnnotations;
    private final boolean useEdgeAnnotations;

    @Override
    public SubGraph<N, E> newSubGraph() {
        return new Graph.SimpleSubGraph(this);
    }

    public static <N, E> LinkedUndirectedGraph<N, E> createWithoutAnnotations() {
        return new LinkedUndirectedGraph<N, E>(false, false);
    }

    public static <N, E> LinkedUndirectedGraph<N, E> createWithNodeAnnotations() {
        return new LinkedUndirectedGraph<N, E>(true, false);
    }

    public static <N, E> LinkedUndirectedGraph<N, E> createWithEdgeAnnotations() {
        return new LinkedUndirectedGraph<N, E>(false, true);
    }

    public static <N, E> LinkedUndirectedGraph<N, E> create() {
        return new LinkedUndirectedGraph<N, E>(true, true);
    }

    protected LinkedUndirectedGraph(boolean bl, boolean bl2) {
        this.useNodeAnnotations = bl;
        this.useEdgeAnnotations = bl2;
    }

    @Override
    public void connect(N n, E e, N n2) {
        LinkedUndirectedGraphNode linkedUndirectedGraphNode = (LinkedUndirectedGraphNode)this.getNodeOrFail(n);
        LinkedUndirectedGraphNode linkedUndirectedGraphNode2 = (LinkedUndirectedGraphNode)this.getNodeOrFail(n2);
        LinkedUndirectedGraphEdge linkedUndirectedGraphEdge = this.useEdgeAnnotations ? new AnnotatedLinkedUndirectedGraphEdge(linkedUndirectedGraphNode, e, linkedUndirectedGraphNode2) : new LinkedUndirectedGraphEdge(linkedUndirectedGraphNode, e, linkedUndirectedGraphNode2);
        linkedUndirectedGraphNode.getNeighborEdges().add(linkedUndirectedGraphEdge);
        linkedUndirectedGraphNode2.getNeighborEdges().add(linkedUndirectedGraphEdge);
    }

    @Override
    public void disconnect(N n, N n2) {
        LinkedUndirectedGraphNode linkedUndirectedGraphNode = (LinkedUndirectedGraphNode)this.getNodeOrFail(n);
        LinkedUndirectedGraphNode linkedUndirectedGraphNode2 = (LinkedUndirectedGraphNode)this.getNodeOrFail(n2);
        for (UndiGraph.UndiGraphEdge<N, E> undiGraphEdge : this.getUndirectedGraphEdges(n, n2)) {
            linkedUndirectedGraphNode.getNeighborEdges().remove(undiGraphEdge);
            linkedUndirectedGraphNode2.getNeighborEdges().remove(undiGraphEdge);
        }
    }

    @Override
    public UndiGraph.UndiGraphNode<N, E> createUndirectedGraphNode(N n) {
        LinkedUndirectedGraphNode<N, E> linkedUndirectedGraphNode = this.nodes.get(n);
        if (linkedUndirectedGraphNode == null) {
            linkedUndirectedGraphNode = this.useNodeAnnotations ? new AnnotatedLinkedUndirectedGraphNode(n) : new LinkedUndirectedGraphNode(n);
            this.nodes.put(n, linkedUndirectedGraphNode);
        }
        return linkedUndirectedGraphNode;
    }

    @Override
    public List<GraphNode<N, E>> getNeighborNodes(N n) {
        UndiGraph.UndiGraphNode<N, E> undiGraphNode = this.getUndirectedGraphNode(n);
        ArrayList arrayList = Lists.newArrayList();
        Iterator<GraphNode<N, E>> iterator = this.getNeighborNodesIterator(n);
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        return arrayList;
    }

    @Override
    public Iterator<GraphNode<N, E>> getNeighborNodesIterator(N n) {
        UndiGraph.UndiGraphNode<N, E> undiGraphNode = this.getUndirectedGraphNode(n);
        Preconditions.checkNotNull(undiGraphNode, (Object)(n + " should be in the graph."));
        return ((LinkedUndirectedGraphNode)undiGraphNode).neighborIterator();
    }

    @Override
    public List<UndiGraph.UndiGraphEdge<N, E>> getUndirectedGraphEdges(N n, N n2) {
        UndiGraph.UndiGraphNode undiGraphNode = this.nodes.get(n);
        if (undiGraphNode == null) {
            return null;
        }
        UndiGraph.UndiGraphNode undiGraphNode2 = this.nodes.get(n2);
        if (undiGraphNode2 == null) {
            return null;
        }
        ArrayList arrayList = Lists.newArrayList();
        for (UndiGraph.UndiGraphEdge undiGraphEdge : undiGraphNode.getNeighborEdges()) {
            if (undiGraphEdge.getNodeA() != undiGraphNode2 && undiGraphEdge.getNodeB() != undiGraphNode2) continue;
            arrayList.add(undiGraphEdge);
        }
        return arrayList;
    }

    @Override
    public UndiGraph.UndiGraphNode<N, E> getUndirectedGraphNode(N n) {
        return this.nodes.get(n);
    }

    @Override
    public Collection<UndiGraph.UndiGraphNode<N, E>> getUndirectedGraphNodes() {
        return Collections.unmodifiableCollection(this.nodes.values());
    }

    @Override
    public GraphNode<N, E> createNode(N n) {
        return this.createUndirectedGraphNode(n);
    }

    @Override
    public List<Graph.GraphEdge<N, E>> getEdges(N n, N n2) {
        return Collections.unmodifiableList(this.getUndirectedGraphEdges(n, n2));
    }

    @Override
    public GraphNode<N, E> getNode(N n) {
        return this.getUndirectedGraphNode(n);
    }

    @Override
    public boolean isConnected(N n, N n2) {
        return this.isConnected(n, Predicates.alwaysTrue(), n2);
    }

    @Override
    public boolean isConnected(N n, E e, N n2) {
        return this.isConnected(n, Predicates.equalTo(e), n2);
    }

    @Override
    private boolean isConnected(N n, Predicate<E> predicate, N n2) {
        UndiGraph.UndiGraphNode undiGraphNode = this.nodes.get(n);
        if (undiGraphNode == null) {
            return false;
        }
        UndiGraph.UndiGraphNode undiGraphNode2 = this.nodes.get(n2);
        if (undiGraphNode2 == null) {
            return false;
        }
        for (UndiGraph.UndiGraphEdge undiGraphEdge : undiGraphNode.getNeighborEdges()) {
            if ((undiGraphEdge.getNodeA() != undiGraphNode || undiGraphEdge.getNodeB() != undiGraphNode2) && (undiGraphEdge.getNodeA() != undiGraphNode2 || undiGraphEdge.getNodeB() != undiGraphNode) || !predicate.apply(undiGraphEdge.getValue())) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<GraphvizGraph.GraphvizEdge> getGraphvizEdges() {
        ArrayList arrayList = Lists.newArrayList();
        for (LinkedUndirectedGraphNode<N, E> linkedUndirectedGraphNode : this.nodes.values()) {
            for (UndiGraph.UndiGraphEdge<N, E> undiGraphEdge : linkedUndirectedGraphNode.getNeighborEdges()) {
                if (undiGraphEdge.getNodeA() != linkedUndirectedGraphNode) continue;
                arrayList.add((GraphvizGraph.GraphvizEdge)((Object)undiGraphEdge));
            }
        }
        return arrayList;
    }

    @Override
    public String getName() {
        return "LinkedUndirectedGraph";
    }

    @Override
    public List<GraphvizGraph.GraphvizNode> getGraphvizNodes() {
        ArrayList arrayList = Lists.newArrayListWithCapacity((int)this.nodes.size());
        for (LinkedUndirectedGraphNode<N, E> linkedUndirectedGraphNode : this.nodes.values()) {
            arrayList.add(linkedUndirectedGraphNode);
        }
        return arrayList;
    }

    @Override
    public boolean isDirected() {
        return false;
    }

    @Override
    public Collection<GraphNode<N, E>> getNodes() {
        return Collections.unmodifiableCollection(this.nodes.values());
    }

    @Override
    public List<Graph.GraphEdge<N, E>> getEdges() {
        ArrayList arrayList = Lists.newArrayList();
        for (LinkedUndirectedGraphNode<N, E> linkedUndirectedGraphNode : this.nodes.values()) {
            for (UndiGraph.UndiGraphEdge<N, E> undiGraphEdge : linkedUndirectedGraphNode.getNeighborEdges()) {
                if (undiGraphEdge.getNodeA() != linkedUndirectedGraphNode) continue;
                arrayList.add(undiGraphEdge);
            }
        }
        return arrayList;
    }

    @Override
    public int getNodeDegree(N n) {
        UndiGraph.UndiGraphNode<N, E> undiGraphNode = this.getUndirectedGraphNode(n);
        if (undiGraphNode == null) {
            throw new IllegalArgumentException(n + " not found in graph");
        }
        return undiGraphNode.getNeighborEdges().size();
    }

    static class AnnotatedLinkedUndirectedGraphEdge<N, E>
    extends LinkedUndirectedGraphEdge<N, E> {
        protected Annotation annotation;

        AnnotatedLinkedUndirectedGraphEdge(UndiGraph.UndiGraphNode<N, E> undiGraphNode, E e, UndiGraph.UndiGraphNode<N, E> undiGraphNode2) {
            super(undiGraphNode, e, undiGraphNode2);
        }

        @Override
        public <A extends Annotation> A getAnnotation() {
            return (A)this.annotation;
        }

        @Override
        public void setAnnotation(Annotation annotation) {
            this.annotation = annotation;
        }
    }

    static class LinkedUndirectedGraphEdge<N, E>
    implements UndiGraph.UndiGraphEdge<N, E>,
    GraphvizGraph.GraphvizEdge {
        private UndiGraph.UndiGraphNode<N, E> nodeA;
        private UndiGraph.UndiGraphNode<N, E> nodeB;
        protected final E value;

        LinkedUndirectedGraphEdge(UndiGraph.UndiGraphNode<N, E> undiGraphNode, E e, UndiGraph.UndiGraphNode<N, E> undiGraphNode2) {
            this.value = e;
            this.nodeA = undiGraphNode;
            this.nodeB = undiGraphNode2;
        }

        @Override
        public E getValue() {
            return this.value;
        }

        @Override
        public GraphNode<N, E> getNodeA() {
            return this.nodeA;
        }

        @Override
        public GraphNode<N, E> getNodeB() {
            return this.nodeB;
        }

        @Override
        public <A extends Annotation> A getAnnotation() {
            throw new UnsupportedOperationException("Graph initialized with edge annotations turned off");
        }

        @Override
        public void setAnnotation(Annotation annotation) {
            throw new UnsupportedOperationException("Graph initialized with edge annotations turned off");
        }

        @Override
        public String getColor() {
            return "black";
        }

        @Override
        public String getLabel() {
            return this.value != null ? this.value.toString() : "null";
        }

        @Override
        public String getNode1Id() {
            return ((LinkedUndirectedGraphNode)this.nodeA).getId();
        }

        @Override
        public String getNode2Id() {
            return ((LinkedUndirectedGraphNode)this.nodeB).getId();
        }

        public String toString() {
            return this.nodeA.toString() + " -- " + this.nodeB.toString();
        }
    }

    static class AnnotatedLinkedUndirectedGraphNode<N, E>
    extends LinkedUndirectedGraphNode<N, E> {
        protected Annotation annotation;

        AnnotatedLinkedUndirectedGraphNode(N n) {
            super(n);
        }

        @Override
        public <A extends Annotation> A getAnnotation() {
            return (A)this.annotation;
        }

        @Override
        public void setAnnotation(Annotation annotation) {
            this.annotation = annotation;
        }
    }

    static class LinkedUndirectedGraphNode<N, E>
    implements UndiGraph.UndiGraphNode<N, E>,
    GraphvizGraph.GraphvizNode {
        private List<UndiGraph.UndiGraphEdge<N, E>> neighborList = Lists.newArrayList();
        private final N value;

        LinkedUndirectedGraphNode(N n) {
            this.value = n;
        }

        @Override
        public List<UndiGraph.UndiGraphEdge<N, E>> getNeighborEdges() {
            return this.neighborList;
        }

        @Override
        public <A extends Annotation> A getAnnotation() {
            throw new UnsupportedOperationException("Graph initialized with node annotations turned off");
        }

        @Override
        public void setAnnotation(Annotation annotation) {
            throw new UnsupportedOperationException("Graph initialized with node annotations turned off");
        }

        @Override
        public N getValue() {
            return this.value;
        }

        @Override
        public String getColor() {
            return "white";
        }

        @Override
        public String getId() {
            return "LDN" + this.hashCode();
        }

        @Override
        public String getLabel() {
            return this.value != null ? this.value.toString() : "null";
        }

        public Iterator<GraphNode<N, E>> neighborIterator() {
            return new NeighborIterator();
        }

        private class NeighborIterator
        implements Iterator<GraphNode<N, E>> {
            private final Iterator<UndiGraph.UndiGraphEdge<N, E>> edgeIterator;

            private NeighborIterator() {
                this.edgeIterator = LinkedUndirectedGraphNode.this.neighborList.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.edgeIterator.hasNext();
            }

            @Override
            public GraphNode<N, E> next() {
                UndiGraph.UndiGraphEdge undiGraphEdge = this.edgeIterator.next();
                if (undiGraphEdge.getNodeA() == LinkedUndirectedGraphNode.this) {
                    return undiGraphEdge.getNodeB();
                }
                return undiGraphEdge.getNodeA();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Remove not supported.");
            }
        }
    }
}

