/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.AbstractPeepholeOptimization;
import com.google.javascript.jscomp.CodeGenerator;
import com.google.javascript.jscomp.ControlFlowAnalysis;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.TernaryValue;
import java.util.regex.Pattern;

class PeepholeSubstituteAlternateSyntax
extends AbstractPeepholeOptimization {
    private static final int AND_PRECEDENCE = NodeUtil.precedence(101);
    private static final int OR_PRECEDENCE = NodeUtil.precedence(100);
    static final DiagnosticType INVALID_REGULAR_EXPRESSION_FLAGS = DiagnosticType.error("JSC_INVALID_REGULAR_EXPRESSION_FLAGS", "Invalid flags to RegExp constructor: {0}");
    static final Predicate<Node> DONT_TRAVERSE_FUNCTIONS_PREDICATE = new Predicate<Node>(){

        public boolean apply(Node node) {
            return node.getType() != 105;
        }
    };
    private static final ImmutableSet<String> STANDARD_OBJECT_CONSTRUCTORS = ImmutableSet.of((Object)"Object", (Object)"Array", (Object)"RegExp", (Object)"Error");
    private static final Pattern REGEXP_FLAGS_RE = Pattern.compile("^[gmi]*$");

    PeepholeSubstituteAlternateSyntax() {
    }

    @Override
    public Node optimizeSubtree(Node node) {
        switch (node.getType()) {
            case 4: {
                Node node2 = this.tryRemoveRedundantExit(node);
                if (node2 != node) {
                    return node2;
                }
                node2 = this.tryReplaceExitWithBreak(node);
                if (node2 != node) {
                    return node2;
                }
                return this.tryReduceReturn(node);
            }
            case 49: {
                Node node3 = this.tryRemoveRedundantExit(node);
                if (node3 != node) {
                    return node3;
                }
                return this.tryReplaceExitWithBreak(node);
            }
            case 26: {
                this.tryMinimizeCondition(node.getFirstChild());
                return this.tryMinimizeNot(node);
            }
            case 108: {
                this.tryMinimizeCondition(node.getFirstChild());
                return this.tryMinimizeIf(node);
            }
            case 130: {
                this.tryMinimizeCondition(node.getFirstChild());
                return node;
            }
            case 98: {
                this.tryMinimizeCondition(node.getFirstChild());
                return node;
            }
            case 113: 
            case 114: {
                this.tryMinimizeCondition(NodeUtil.getConditionExpression(node));
                return node;
            }
            case 115: {
                if (!NodeUtil.isForIn(node)) {
                    this.tryMinimizeCondition(NodeUtil.getConditionExpression(node));
                }
                return node;
            }
            case 30: {
                node = this.tryFoldStandardConstructors(node);
                if (node.getType() != 37) {
                    return node;
                }
            }
            case 37: {
                return this.tryFoldLiteralConstructor(node);
            }
        }
        return node;
    }

    private Node tryReduceReturn(Node node) {
        Node node2 = node.getFirstChild();
        if (node2 != null) {
            switch (node2.getType()) {
                case 122: {
                    Node node3 = node2.getFirstChild();
                    if (this.mayHaveSideEffects(node3)) break;
                    node.removeFirstChild();
                    this.reportCodeChange();
                    break;
                }
                case 38: {
                    String string = node2.getString();
                    if (!string.equals("undefined")) break;
                    node.removeFirstChild();
                    this.reportCodeChange();
                }
            }
        }
        return node;
    }

    private Node tryReplaceExitWithBreak(Node node) {
        Node node2 = node.getFirstChild();
        Node node3 = node;
        while (!ControlFlowAnalysis.isBreakTarget(node3, null)) {
            if (NodeUtil.isFunction(node3) || node3.getType() == 132) {
                return node;
            }
            node3 = node3.getParent();
        }
        Node node4 = ControlFlowAnalysis.computeFollowNode(node3);
        Node node5 = node4;
        if (node5 != (node4 = this.skipFinallyNodes(node4)) && !this.isPure(node2)) {
            return node;
        }
        if (node4 == null && (node.getType() == 49 || node2 != null)) {
            return node;
        }
        if (node4 == null || this.areMatchingExits(node, node4)) {
            Node node6 = new Node(116);
            node.getParent().replaceChild(node, node6);
            this.reportCodeChange();
            return node6;
        }
        return node;
    }

    private Node tryRemoveRedundantExit(Node node) {
        Node node2 = node.getFirstChild();
        Node node3 = ControlFlowAnalysis.computeFollowNode(node);
        Node node4 = node3;
        if (node4 != (node3 = this.skipFinallyNodes(node3)) && !this.isPure(node2)) {
            return node;
        }
        if (node3 == null && (node.getType() == 49 || node2 != null)) {
            return node;
        }
        if (node3 == null || this.areMatchingExits(node, node3)) {
            node.detachFromParent();
            this.reportCodeChange();
            return null;
        }
        return node;
    }

    boolean isPure(Node node) {
        return node == null || !NodeUtil.canBeSideEffected(node) && !NodeUtil.mayHaveSideEffects(node);
    }

    Node skipFinallyNodes(Node node) {
        while (node != null && NodeUtil.isTryFinallyNode(node.getParent(), node)) {
            node = ControlFlowAnalysis.computeFollowNode(node);
        }
        return node;
    }

    boolean areMatchingExits(Node node, Node node2) {
        return node.checkTreeEqualsSilent(node2) && (!this.isExceptionPossible(node) || this.getExceptionHandler(node) == this.getExceptionHandler(node2));
    }

    boolean isExceptionPossible(Node node) {
        Preconditions.checkState((node.getType() == 4 || node.getType() == 49 ? 1 : 0) != 0);
        return node.getType() == 49 || node.hasChildren() && !NodeUtil.isLiteralValue(node.getLastChild(), true);
    }

    Node getExceptionHandler(Node node) {
        return ControlFlowAnalysis.getExceptionHandler(node);
    }

    private Node tryMinimizeNot(Node node) {
        int n;
        Node node2 = node.getParent();
        Node node3 = node.getFirstChild();
        switch (node3.getType()) {
            case 12: {
                n = 13;
                break;
            }
            case 13: {
                n = 12;
                break;
            }
            case 45: {
                n = 46;
                break;
            }
            case 46: {
                n = 45;
                break;
            }
            default: {
                return node;
            }
        }
        Node node4 = node.removeFirstChild();
        node4.setType(n);
        node2.replaceChild(node, node4);
        this.reportCodeChange();
        return node4;
    }

    private Node tryMinimizeIf(Node node) {
        Node node2 = node.getParent();
        Node node3 = node.getFirstChild();
        if (NodeUtil.isLiteralValue(node3, true)) {
            return node;
        }
        Node node4 = node3.getNext();
        Node node5 = node4.getNext();
        if (node5 == null) {
            if (this.isFoldableExpressBlock(node4)) {
                Node node6 = this.getBlockExpression(node4);
                if (this.isPropertyAssignmentInExpression(node6)) {
                    return node;
                }
                if (node3.getType() == 26) {
                    if (this.isLowerPrecedenceInExpression(node3, OR_PRECEDENCE) && this.isLowerPrecedenceInExpression(node6.getFirstChild(), OR_PRECEDENCE)) {
                        return node;
                    }
                    Node node7 = new Node(100, node3.removeFirstChild(), node6.removeFirstChild()).copyInformationFrom(node);
                    Node node8 = NodeUtil.newExpr(node7);
                    node2.replaceChild(node, node8);
                    this.reportCodeChange();
                    return node8;
                }
                if (this.isLowerPrecedenceInExpression(node3, AND_PRECEDENCE) || this.isLowerPrecedenceInExpression(node6.getFirstChild(), AND_PRECEDENCE)) {
                    return node;
                }
                node.removeChild(node3);
                Node node9 = new Node(101, node3, node6.removeFirstChild()).copyInformationFrom(node);
                Node node10 = NodeUtil.newExpr(node9);
                node2.replaceChild(node, node10);
                this.reportCodeChange();
                return node10;
            }
            return node;
        }
        this.tryRemoveRepeatedStatements(node);
        if (node3.getType() == 26 && !this.consumesDanglingElse(node5)) {
            node.replaceChild(node3, node3.removeFirstChild());
            node.removeChild(node4);
            node.addChildToBack(node4);
            this.reportCodeChange();
            return node;
        }
        if (this.isReturnExpressBlock(node4) && this.isReturnExpressBlock(node5)) {
            Node node11 = this.getBlockReturnExpression(node4);
            Node node12 = this.getBlockReturnExpression(node5);
            node.removeChild(node3);
            node11.detachFromParent();
            node12.detachFromParent();
            Node node13 = new Node(98, node3, node11, node12).copyInformationFrom(node);
            Node node14 = new Node(4, node13);
            node2.replaceChild(node, node14);
            this.reportCodeChange();
            return node14;
        }
        boolean bl = this.isFoldableExpressBlock(node4);
        boolean bl2 = this.isFoldableExpressBlock(node5);
        if (bl && bl2) {
            Node node15 = this.getBlockExpression(node4).getFirstChild();
            Node node16 = this.getBlockExpression(node5).getFirstChild();
            if (node15.getType() == node16.getType()) {
                if (NodeUtil.isAssignmentOp(node15)) {
                    Node node17 = node15.getFirstChild();
                    if (this.areNodesEqualForInlining(node17, node16.getFirstChild()) && !this.mayEffectMutableState(node17)) {
                        node.removeChild(node3);
                        Node node18 = node15.removeFirstChild();
                        Node node19 = node15.removeFirstChild();
                        Node node20 = node16.getLastChild();
                        node16.removeChild(node20);
                        Node node21 = new Node(98, node3, node19, node20).copyInformationFrom(node);
                        Node node22 = new Node(node15.getType(), node18, node21).copyInformationFrom(node15);
                        Node node23 = NodeUtil.newExpr(node22);
                        node2.replaceChild(node, node23);
                        this.reportCodeChange();
                        return node23;
                    }
                } else if (NodeUtil.isCall(node15)) {
                    node.removeChild(node3);
                    node15.detachFromParent();
                    node16.detachFromParent();
                    Node node24 = new Node(98, node3, node15, node16).copyInformationFrom(node);
                    Node node25 = NodeUtil.newExpr(node24);
                    node2.replaceChild(node, node25);
                    this.reportCodeChange();
                    return node25;
                }
            }
            return node;
        }
        boolean bl3 = this.isVarBlock(node4);
        boolean bl4 = this.isVarBlock(node5);
        if (bl3 && bl2 && NodeUtil.isAssign(this.getBlockExpression(node5).getFirstChild())) {
            Node node26 = this.getBlockVar(node4);
            Node node27 = this.getBlockExpression(node5).getFirstChild();
            Node node28 = node26.getFirstChild();
            Node node29 = node27.getFirstChild();
            if (node28.hasChildren() && node29.getType() == 38 && node28.getString().equals(node29.getString())) {
                Node node30 = node28.removeChildren();
                Node node31 = node27.getLastChild().detachFromParent();
                node3.detachFromParent();
                Node node32 = new Node(98, node3, node30, node31).copyInformationFrom(node);
                node26.detachFromParent();
                node28.addChildrenToBack(node32);
                node2.replaceChild(node, node26);
                this.reportCodeChange();
                return node26;
            }
        } else if (bl4 && bl && NodeUtil.isAssign(this.getBlockExpression(node4).getFirstChild())) {
            Node node33 = this.getBlockVar(node5);
            Node node34 = this.getBlockExpression(node4).getFirstChild();
            Node node35 = node34.getFirstChild();
            Node node36 = node33.getFirstChild();
            if (node36.hasChildren() && node35.getType() == 38 && node35.getString().equals(node36.getString())) {
                Node node37 = node34.getLastChild().detachFromParent();
                Node node38 = node36.removeChildren();
                node3.detachFromParent();
                Node node39 = new Node(98, node3, node37, node38).copyInformationFrom(node);
                node33.detachFromParent();
                node36.addChildrenToBack(node39);
                node2.replaceChild(node, node33);
                this.reportCodeChange();
                return node33;
            }
        }
        return node;
    }

    private void tryRemoveRepeatedStatements(Node node) {
        Preconditions.checkState((node.getType() == 108 ? 1 : 0) != 0);
        Node node2 = node.getParent();
        if (!NodeUtil.isStatementBlock(node2)) {
            return;
        }
        Node node3 = node.getFirstChild();
        Node node4 = node3.getNext();
        Node node5 = node4.getNext();
        Preconditions.checkNotNull((Object)node4);
        Preconditions.checkNotNull((Object)node5);
        while (true) {
            Node node6 = node4.getLastChild();
            Node node7 = node5.getLastChild();
            if (node6 == null || node7 == null || !this.areNodesEqualForInlining(node6, node7)) break;
            node6.detachFromParent();
            node7.detachFromParent();
            node2.addChildAfter(node6, node);
            this.reportCodeChange();
        }
    }

    private boolean isFoldableExpressBlock(Node node) {
        if (node.getType() == 125 && node.hasOneChild()) {
            Node node2 = node.getFirstChild();
            if (node2.getType() == 130) {
                if (node2.getFirstChild().getType() == 37) {
                    Node node3 = node2.getFirstChild().getFirstChild();
                    if (node3.getType() == 35) {
                        return false;
                    }
                    if (node3.getType() == 33 && node3.getLastChild().getString().startsWith("on")) {
                        return false;
                    }
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private Node getBlockExpression(Node node) {
        Preconditions.checkState((boolean)this.isFoldableExpressBlock(node));
        return node.getFirstChild();
    }

    private boolean isReturnExpressBlock(Node node) {
        Node node2;
        if (node.getType() == 125 && node.hasOneChild() && (node2 = node.getFirstChild()).getType() == 4) {
            return node2.hasOneChild();
        }
        return false;
    }

    private Node getBlockReturnExpression(Node node) {
        Preconditions.checkState((boolean)this.isReturnExpressBlock(node));
        return node.getFirstChild().getFirstChild();
    }

    private boolean isVarBlock(Node node) {
        Node node2;
        if (node.getType() == 125 && node.hasOneChild() && (node2 = node.getFirstChild()).getType() == 118) {
            return node2.hasOneChild();
        }
        return false;
    }

    private Node getBlockVar(Node node) {
        Preconditions.checkState((boolean)this.isVarBlock(node));
        return node.getFirstChild();
    }

    private boolean consumesDanglingElse(Node node) {
        block4: while (true) {
            switch (node.getType()) {
                case 108: {
                    if (node.getChildCount() < 3) {
                        return true;
                    }
                    node = node.getLastChild();
                    continue block4;
                }
                case 113: 
                case 115: 
                case 119: {
                    node = node.getLastChild();
                    continue block4;
                }
            }
            break;
        }
        return false;
    }

    private boolean isLowerPrecedenceInExpression(Node node, final int n) {
        Predicate<Node> predicate = new Predicate<Node>(){

            public boolean apply(Node node) {
                return NodeUtil.precedence(node.getType()) < n;
            }
        };
        return NodeUtil.has(node, predicate, DONT_TRAVERSE_FUNCTIONS_PREDICATE);
    }

    private boolean isPropertyAssignmentInExpression(Node node) {
        Predicate<Node> predicate = new Predicate<Node>(){

            public boolean apply(Node node) {
                return node.getType() == 33 && node.getParent().getType() == 86;
            }
        };
        return NodeUtil.has(node, predicate, DONT_TRAVERSE_FUNCTIONS_PREDICATE);
    }

    private Node tryMinimizeCondition(Node node) {
        Node node2 = node.getParent();
        switch (node.getType()) {
            case 26: {
                Node node3 = node.getFirstChild();
                switch (node3.getType()) {
                    case 26: {
                        Node node4 = node3.removeFirstChild();
                        node2.replaceChild(node, node4);
                        this.reportCodeChange();
                        return node4;
                    }
                    case 100: 
                    case 101: {
                        Node node5 = node3.getFirstChild();
                        Node node6 = node3.getLastChild();
                        if (node5.getType() != 26 || node6.getType() != 26) break;
                        Node node7 = node5.removeFirstChild();
                        Node node8 = node6.removeFirstChild();
                        int n = node3.getType() == 101 ? 100 : 101;
                        Node node9 = new Node(n, node7, node8);
                        node2.replaceChild(node, node9);
                        this.reportCodeChange();
                        return node9;
                    }
                }
                return node;
            }
            case 100: 
            case 101: {
                Node node10 = node.getFirstChild();
                Node node11 = node.getLastChild();
                node10 = this.tryMinimizeCondition(node10);
                node11 = this.tryMinimizeCondition(node11);
                TernaryValue ternaryValue = NodeUtil.getBooleanValue(node11);
                if (NodeUtil.getBooleanValue(node11) != TernaryValue.UNKNOWN) {
                    int n = node.getType();
                    Node node12 = null;
                    boolean bl = ternaryValue.toBoolean(true);
                    if (n == 100 && !bl || n == 101 && bl) {
                        node12 = node10;
                    } else if (!this.mayHaveSideEffects(node10)) {
                        node12 = node11;
                    }
                    if (node12 != null) {
                        node.detachChildren();
                        node2.replaceChild(node, node12);
                        this.reportCodeChange();
                        return node12;
                    }
                }
                return node;
            }
            case 98: {
                Node node13 = node.getFirstChild();
                Node node14 = node.getFirstChild().getNext();
                Node node15 = node.getLastChild();
                node14 = this.tryMinimizeCondition(node14);
                node15 = this.tryMinimizeCondition(node15);
                Node node16 = null;
                if (NodeUtil.getBooleanValue(node14) == TernaryValue.TRUE && NodeUtil.getBooleanValue(node15) == TernaryValue.FALSE) {
                    node13.detachFromParent();
                    node16 = node13;
                } else if (NodeUtil.getBooleanValue(node14) == TernaryValue.FALSE && NodeUtil.getBooleanValue(node15) == TernaryValue.TRUE) {
                    node13.detachFromParent();
                    node16 = new Node(26, node13);
                } else if (NodeUtil.getBooleanValue(node14) == TernaryValue.TRUE) {
                    node.detachChildren();
                    node16 = new Node(100, node13, node15);
                } else if (NodeUtil.getBooleanValue(node15) == TernaryValue.FALSE) {
                    node.detachChildren();
                    node16 = new Node(101, node13, node14);
                }
                if (node16 != null) {
                    node2.replaceChild(node, node16);
                    node = node16;
                    this.reportCodeChange();
                }
                return node;
            }
        }
        TernaryValue ternaryValue = NodeUtil.getBooleanValue(node);
        if (ternaryValue != TernaryValue.UNKNOWN) {
            boolean bl = ternaryValue.toBoolean(true);
            int n = bl ? 1 : 0;
            return this.maybeReplaceChildWithNumber(node, node2, n);
        }
        return node;
    }

    private Node maybeReplaceChildWithNumber(Node node, Node node2, int n) {
        Node node3 = Node.newNumber(n);
        if (!node3.isEquivalentTo(node)) {
            node2.replaceChild(node, node3);
            this.reportCodeChange();
            return node3;
        }
        return node;
    }

    private Node tryFoldStandardConstructors(Node node) {
        String string;
        Preconditions.checkState((node.getType() == 30 ? 1 : 0) != 0);
        if (this.isASTNormalized() && node.getFirstChild().getType() == 38 && STANDARD_OBJECT_CONSTRUCTORS.contains((Object)(string = node.getFirstChild().getString()))) {
            node.setType(37);
            this.reportCodeChange();
        }
        return node;
    }

    private Node tryFoldLiteralConstructor(Node node) {
        Preconditions.checkArgument((node.getType() == 37 || node.getType() == 30 ? 1 : 0) != 0);
        Node node2 = node.getFirstChild();
        Node node3 = null;
        if (this.isASTNormalized() && 38 == node2.getType()) {
            Node node4;
            FoldArrayAction foldArrayAction;
            boolean bl;
            String string = node2.getString();
            if ("RegExp".equals(string)) {
                return this.tryFoldRegularExpressionConstructor(node);
            }
            boolean bl2 = bl = node2.getNext() != null;
            if ("Object".equals(string) && !bl) {
                node3 = new Node(64);
            } else if ("Array".equals(string) && ((foldArrayAction = this.isSafeToFoldArrayConstructor(node4 = node2.getNext())) == FoldArrayAction.SAFE_TO_FOLD_WITH_ARGS || foldArrayAction == FoldArrayAction.SAFE_TO_FOLD_WITHOUT_ARGS)) {
                node3 = new Node(63);
                node.removeChildren();
                if (foldArrayAction == FoldArrayAction.SAFE_TO_FOLD_WITH_ARGS) {
                    node3.addChildrenToFront(node4);
                }
            }
            if (node3 != null) {
                node.getParent().replaceChild(node, node3);
                this.reportCodeChange();
                return node3;
            }
        }
        return node;
    }

    private FoldArrayAction isSafeToFoldArrayConstructor(Node node) {
        FoldArrayAction foldArrayAction = FoldArrayAction.NOT_SAFE_TO_FOLD;
        if (node == null) {
            foldArrayAction = FoldArrayAction.SAFE_TO_FOLD_WITHOUT_ARGS;
        } else if (node.getNext() != null) {
            foldArrayAction = FoldArrayAction.SAFE_TO_FOLD_WITH_ARGS;
        } else {
            switch (node.getType()) {
                case 40: {
                    foldArrayAction = FoldArrayAction.SAFE_TO_FOLD_WITH_ARGS;
                    break;
                }
                case 39: {
                    if (node.getDouble() != 0.0) break;
                    foldArrayAction = FoldArrayAction.SAFE_TO_FOLD_WITHOUT_ARGS;
                    break;
                }
                case 63: {
                    foldArrayAction = FoldArrayAction.SAFE_TO_FOLD_WITH_ARGS;
                    break;
                }
            }
        }
        return foldArrayAction;
    }

    private Node tryFoldRegularExpressionConstructor(Node node) {
        Node node2;
        Node node3 = node.getParent();
        Node node4 = node.getFirstChild();
        Node node5 = node4.getNext();
        Node node6 = node2 = null != node5 ? node5.getNext() : null;
        if (!this.isASTNormalized()) {
            return node;
        }
        if (null == node5 || null != node2 && null != node2.getNext()) {
            return node;
        }
        if (!(node5.getType() != 40 || "".equals(node5.getString()) || node5.getString().length() >= 100 || null != node2 && node2.getType() != 40 || PeepholeSubstituteAlternateSyntax.containsUnicodeEscape(node5.getString()))) {
            Node node7;
            node5 = PeepholeSubstituteAlternateSyntax.makeForwardSlashBracketSafe(node5);
            if (null == node2 || "".equals(node2.getString())) {
                node7 = new Node(47, node5);
            } else {
                if (!PeepholeSubstituteAlternateSyntax.areValidRegexpFlags(node2.getString())) {
                    this.error(INVALID_REGULAR_EXPRESSION_FLAGS, node2);
                    return node;
                }
                if (!PeepholeSubstituteAlternateSyntax.areSafeFlagsToFold(node2.getString())) {
                    return node;
                }
                node.removeChild(node2);
                node7 = new Node(47, node5, node2);
            }
            node3.replaceChild(node, node7);
            this.reportCodeChange();
            return node7;
        }
        return node;
    }

    private static boolean areValidRegexpFlags(String string) {
        return REGEXP_FLAGS_RE.matcher(string).matches();
    }

    private static boolean areSafeFlagsToFold(String string) {
        return string.indexOf(103) < 0;
    }

    private static Node makeForwardSlashBracketSafe(Node node) {
        String string = node.getString();
        StringBuilder stringBuilder = null;
        int n = 0;
        block4: for (int i = 0; i < string.length(); ++i) {
            switch (string.charAt(i)) {
                case '\\': {
                    ++i;
                    continue block4;
                }
                case '/': {
                    if (null == stringBuilder) {
                        stringBuilder = new StringBuilder(string.length() + 16);
                    }
                    stringBuilder.append(string, n, i).append('\\');
                    n = i;
                }
            }
        }
        if (null == stringBuilder) {
            return node.cloneTree();
        }
        stringBuilder.append(string, n, string.length());
        return Node.newString(stringBuilder.toString()).copyInformationFrom(node);
    }

    static boolean containsUnicodeEscape(String string) {
        String string2 = CodeGenerator.regexpEscape(string);
        int n = -1;
        while ((n = string2.indexOf("\\u", n + 1)) >= 0) {
            int n2 = 0;
            while (n - n2 > 0 && '\\' == string2.charAt(n - n2 - 1)) {
                ++n2;
            }
            if (0 != (n2 & 1)) continue;
            return true;
        }
        return false;
    }

    private static enum FoldArrayAction {
        NOT_SAFE_TO_FOLD,
        SAFE_TO_FOLD_WITH_ARGS,
        SAFE_TO_FOLD_WITHOUT_ARGS;

    }
}

