/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino.testing;

import com.google.javascript.rhino.JSTypeExpression;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.FunctionBuilder;
import com.google.javascript.rhino.jstype.FunctionPrototypeType;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.ObjectType;
import com.google.javascript.rhino.jstype.RecordTypeBuilder;
import com.google.javascript.rhino.testing.TestErrorReporter;
import junit.framework.TestCase;

public abstract class BaseJSTypeTestCase
extends TestCase {
    protected JSTypeRegistry registry;
    protected TestErrorReporter errorReporter;
    protected JSType ALL_TYPE;
    protected ObjectType NO_OBJECT_TYPE;
    protected ObjectType NO_TYPE;
    protected JSType ARRAY_FUNCTION_TYPE;
    protected ObjectType ARRAY_TYPE;
    protected JSType BOOLEAN_OBJECT_FUNCTION_TYPE;
    protected ObjectType BOOLEAN_OBJECT_TYPE;
    protected JSType BOOLEAN_TYPE;
    protected JSType CHECKED_UNKNOWN_TYPE;
    protected JSType DATE_FUNCTION_TYPE;
    protected ObjectType DATE_TYPE;
    protected JSType ERROR_FUNCTION_TYPE;
    protected ObjectType ERROR_TYPE;
    protected JSType EVAL_ERROR_FUNCTION_TYPE;
    protected ObjectType EVAL_ERROR_TYPE;
    protected FunctionType FUNCTION_FUNCTION_TYPE;
    protected FunctionType FUNCTION_INSTANCE_TYPE;
    protected ObjectType FUNCTION_PROTOTYPE;
    protected JSType GREATEST_FUNCTION_TYPE;
    protected JSType LEAST_FUNCTION_TYPE;
    protected JSType MATH_TYPE;
    protected JSType NULL_TYPE;
    protected JSType NUMBER_OBJECT_FUNCTION_TYPE;
    protected ObjectType NUMBER_OBJECT_TYPE;
    protected JSType NUMBER_STRING_BOOLEAN;
    protected JSType NUMBER_TYPE;
    protected FunctionType OBJECT_FUNCTION_TYPE;
    protected JSType OBJECT_NUMBER_STRING;
    protected JSType OBJECT_NUMBER_STRING_BOOLEAN;
    protected JSType OBJECT_PROTOTYPE;
    protected ObjectType OBJECT_TYPE;
    protected JSType RANGE_ERROR_FUNCTION_TYPE;
    protected ObjectType RANGE_ERROR_TYPE;
    protected JSType REFERENCE_ERROR_FUNCTION_TYPE;
    protected ObjectType REFERENCE_ERROR_TYPE;
    protected JSType REGEXP_FUNCTION_TYPE;
    protected ObjectType REGEXP_TYPE;
    protected JSType STRING_OBJECT_FUNCTION_TYPE;
    protected ObjectType STRING_OBJECT_TYPE;
    protected JSType STRING_TYPE;
    protected JSType SYNTAX_ERROR_FUNCTION_TYPE;
    protected ObjectType SYNTAX_ERROR_TYPE;
    protected JSType TYPE_ERROR_FUNCTION_TYPE;
    protected ObjectType TYPE_ERROR_TYPE;
    protected FunctionType U2U_CONSTRUCTOR_TYPE;
    protected FunctionType U2U_FUNCTION_TYPE;
    protected ObjectType UNKNOWN_TYPE;
    protected JSType URI_ERROR_FUNCTION_TYPE;
    protected ObjectType URI_ERROR_TYPE;
    protected JSType VOID_TYPE;
    protected int NATIVE_PROPERTIES_COUNT;
    public static final String ALL_NATIVE_EXTERN_TYPES = "/**\n * @constructor\n * @param {*} opt_value\n */\nfunction Object(opt_value) {}\n\n/**\n * @constructor\n * @extends {Object}\n * @param {*} var_args\n */\n\nfunction Function(var_args) {}\n/**\n * @constructor\n * @extends {Object}\n * @param {*} var_args\n * @return {!Array}\n */\nfunction Array(var_args) {}\n\n/**\n * @constructor\n * @param {*} opt_value\n * @return {boolean}\n */\nfunction Boolean(opt_value) {}\n\n/**\n * @constructor\n * @param {*} opt_value\n * @return {number}\n */\nfunction Number(opt_value) {}\n\n/**\n * @constructor\n * @return {string}\n */\nfunction Date(opt_yr_num, opt_mo_num, opt_day_num, opt_hr_num,    opt_min_num, opt_sec_num, opt_ms_num) {}\n\n/**\n * @constructor\n * @extends {Object}\n * @param {*} opt_str\n * @return {string}\n */\nfunction String(opt_str) {}\n\n/**\n * @constructor\n * @param {*} opt_pattern\n * @param {*} opt_flags\n * @return {!RegExp}\n */\nfunction RegExp(opt_pattern, opt_flags) {}\n\n/**\n * @constructor\n * @param {*} opt_message\n * @param {*} opt_file\n * @param {*} opt_line\n * @return {!Error}\n */\nfunction Error(opt_message, opt_file, opt_line) {}\n\n/**\n * @constructor\n * @extends {Error}\n * @param {*} opt_message\n * @param {*} opt_file\n * @param {*} opt_line\n * @return {!EvalError}\n */\nfunction EvalError(opt_message, opt_file, opt_line) {}\n\n/**\n * @constructor\n * @extends {Error}\n * @param {*} opt_message\n * @param {*} opt_file\n * @param {*} opt_line\n * @return {!RangeError}\n */\nfunction RangeError(opt_message, opt_file, opt_line) {}\n\n/**\n * @constructor\n * @extends {Error}\n * @param {*} opt_message\n * @param {*} opt_file\n * @param {*} opt_line\n * @return {!ReferenceError}\n */\nfunction ReferenceError(opt_message, opt_file, opt_line) {}\n\n/**\n * @constructor\n * @extends {Error}\n * @param {*} opt_message\n * @param {*} opt_file\n * @param {*} opt_line\n * @return {!SyntaxError}\n */\nfunction SyntaxError(opt_message, opt_file, opt_line) {}\n\n/**\n * @constructor\n * @extends {Error}\n * @param {*} opt_message\n * @param {*} opt_file\n * @param {*} opt_line\n * @return {!TypeError}\n */\nfunction TypeError(opt_message, opt_file, opt_line) {}\n\n/**\n * @constructor\n * @extends {Error}\n * @param {*} opt_message\n * @param {*} opt_file\n * @param {*} opt_line\n * @return {!URIError}\n */\nfunction URIError(opt_message, opt_file, opt_line) {}\n\n/**\n * @param {string} progId\n * @param {string} opt_location\n * @constructor\n */\nfunction ActiveXObject(progId, opt_location) {}\n";

    protected void setUp() throws Exception {
        super.setUp();
        this.errorReporter = new TestErrorReporter(null, null);
        this.registry = new JSTypeRegistry(this.errorReporter);
        this.initTypes();
    }

    protected void initTypes() {
        this.ALL_TYPE = this.registry.getNativeType(JSTypeNative.ALL_TYPE);
        this.NO_OBJECT_TYPE = this.registry.getNativeObjectType(JSTypeNative.NO_OBJECT_TYPE);
        this.NO_TYPE = this.registry.getNativeObjectType(JSTypeNative.NO_TYPE);
        this.ARRAY_FUNCTION_TYPE = this.registry.getNativeType(JSTypeNative.ARRAY_FUNCTION_TYPE);
        this.ARRAY_TYPE = this.registry.getNativeObjectType(JSTypeNative.ARRAY_TYPE);
        this.BOOLEAN_OBJECT_FUNCTION_TYPE = this.registry.getNativeType(JSTypeNative.BOOLEAN_OBJECT_FUNCTION_TYPE);
        this.BOOLEAN_OBJECT_TYPE = this.registry.getNativeObjectType(JSTypeNative.BOOLEAN_OBJECT_TYPE);
        this.BOOLEAN_TYPE = this.registry.getNativeType(JSTypeNative.BOOLEAN_TYPE);
        this.CHECKED_UNKNOWN_TYPE = this.registry.getNativeType(JSTypeNative.CHECKED_UNKNOWN_TYPE);
        this.DATE_FUNCTION_TYPE = this.registry.getNativeType(JSTypeNative.DATE_FUNCTION_TYPE);
        this.DATE_TYPE = this.registry.getNativeObjectType(JSTypeNative.DATE_TYPE);
        this.ERROR_FUNCTION_TYPE = this.registry.getNativeType(JSTypeNative.ERROR_FUNCTION_TYPE);
        this.ERROR_TYPE = this.registry.getNativeObjectType(JSTypeNative.ERROR_TYPE);
        this.EVAL_ERROR_FUNCTION_TYPE = this.registry.getNativeType(JSTypeNative.EVAL_ERROR_FUNCTION_TYPE);
        this.EVAL_ERROR_TYPE = this.registry.getNativeObjectType(JSTypeNative.EVAL_ERROR_TYPE);
        this.FUNCTION_FUNCTION_TYPE = this.registry.getNativeFunctionType(JSTypeNative.FUNCTION_FUNCTION_TYPE);
        this.FUNCTION_INSTANCE_TYPE = this.registry.getNativeFunctionType(JSTypeNative.FUNCTION_INSTANCE_TYPE);
        this.FUNCTION_PROTOTYPE = this.registry.getNativeObjectType(JSTypeNative.FUNCTION_PROTOTYPE);
        this.GREATEST_FUNCTION_TYPE = this.registry.getNativeType(JSTypeNative.GREATEST_FUNCTION_TYPE);
        this.LEAST_FUNCTION_TYPE = this.registry.getNativeType(JSTypeNative.LEAST_FUNCTION_TYPE);
        this.NULL_TYPE = this.registry.getNativeType(JSTypeNative.NULL_TYPE);
        this.NUMBER_OBJECT_FUNCTION_TYPE = this.registry.getNativeType(JSTypeNative.NUMBER_OBJECT_FUNCTION_TYPE);
        this.NUMBER_OBJECT_TYPE = this.registry.getNativeObjectType(JSTypeNative.NUMBER_OBJECT_TYPE);
        this.NUMBER_STRING_BOOLEAN = this.registry.getNativeType(JSTypeNative.NUMBER_STRING_BOOLEAN);
        this.NUMBER_TYPE = this.registry.getNativeType(JSTypeNative.NUMBER_TYPE);
        this.OBJECT_FUNCTION_TYPE = this.registry.getNativeFunctionType(JSTypeNative.OBJECT_FUNCTION_TYPE);
        this.OBJECT_NUMBER_STRING = this.registry.getNativeType(JSTypeNative.OBJECT_NUMBER_STRING);
        this.OBJECT_NUMBER_STRING_BOOLEAN = this.registry.getNativeType(JSTypeNative.OBJECT_NUMBER_STRING_BOOLEAN);
        this.OBJECT_PROTOTYPE = this.registry.getNativeType(JSTypeNative.OBJECT_PROTOTYPE);
        this.OBJECT_TYPE = this.registry.getNativeObjectType(JSTypeNative.OBJECT_TYPE);
        this.RANGE_ERROR_FUNCTION_TYPE = this.registry.getNativeType(JSTypeNative.RANGE_ERROR_FUNCTION_TYPE);
        this.RANGE_ERROR_TYPE = this.registry.getNativeObjectType(JSTypeNative.RANGE_ERROR_TYPE);
        this.REFERENCE_ERROR_FUNCTION_TYPE = this.registry.getNativeType(JSTypeNative.REFERENCE_ERROR_FUNCTION_TYPE);
        this.REFERENCE_ERROR_TYPE = this.registry.getNativeObjectType(JSTypeNative.REFERENCE_ERROR_TYPE);
        this.REGEXP_FUNCTION_TYPE = this.registry.getNativeType(JSTypeNative.REGEXP_FUNCTION_TYPE);
        this.REGEXP_TYPE = this.registry.getNativeObjectType(JSTypeNative.REGEXP_TYPE);
        this.STRING_OBJECT_FUNCTION_TYPE = this.registry.getNativeType(JSTypeNative.STRING_OBJECT_FUNCTION_TYPE);
        this.STRING_OBJECT_TYPE = this.registry.getNativeObjectType(JSTypeNative.STRING_OBJECT_TYPE);
        this.STRING_TYPE = this.registry.getNativeType(JSTypeNative.STRING_TYPE);
        this.SYNTAX_ERROR_FUNCTION_TYPE = this.registry.getNativeType(JSTypeNative.SYNTAX_ERROR_FUNCTION_TYPE);
        this.SYNTAX_ERROR_TYPE = this.registry.getNativeObjectType(JSTypeNative.SYNTAX_ERROR_TYPE);
        this.TYPE_ERROR_FUNCTION_TYPE = this.registry.getNativeType(JSTypeNative.TYPE_ERROR_FUNCTION_TYPE);
        this.TYPE_ERROR_TYPE = this.registry.getNativeObjectType(JSTypeNative.TYPE_ERROR_TYPE);
        this.U2U_CONSTRUCTOR_TYPE = this.registry.getNativeFunctionType(JSTypeNative.U2U_CONSTRUCTOR_TYPE);
        this.U2U_FUNCTION_TYPE = this.registry.getNativeFunctionType(JSTypeNative.U2U_FUNCTION_TYPE);
        this.UNKNOWN_TYPE = this.registry.getNativeObjectType(JSTypeNative.UNKNOWN_TYPE);
        this.URI_ERROR_FUNCTION_TYPE = this.registry.getNativeType(JSTypeNative.URI_ERROR_FUNCTION_TYPE);
        this.URI_ERROR_TYPE = this.registry.getNativeObjectType(JSTypeNative.URI_ERROR_TYPE);
        this.VOID_TYPE = this.registry.getNativeType(JSTypeNative.VOID_TYPE);
        BaseJSTypeTestCase.addNativeProperties(this.registry);
        this.NATIVE_PROPERTIES_COUNT = this.OBJECT_TYPE.getPropertiesCount();
    }

    public static void addNativeProperties(JSTypeRegistry jSTypeRegistry) {
        JSType jSType = jSTypeRegistry.getNativeType(JSTypeNative.BOOLEAN_TYPE);
        JSType jSType2 = jSTypeRegistry.getNativeType(JSTypeNative.NUMBER_TYPE);
        JSType jSType3 = jSTypeRegistry.getNativeType(JSTypeNative.STRING_TYPE);
        JSType jSType4 = jSTypeRegistry.getNativeType(JSTypeNative.UNKNOWN_TYPE);
        ObjectType objectType = jSTypeRegistry.getNativeObjectType(JSTypeNative.OBJECT_TYPE);
        ObjectType objectType2 = jSTypeRegistry.getNativeObjectType(JSTypeNative.ARRAY_TYPE);
        ObjectType objectType3 = jSTypeRegistry.getNativeObjectType(JSTypeNative.DATE_TYPE);
        ObjectType objectType4 = jSTypeRegistry.getNativeObjectType(JSTypeNative.REGEXP_TYPE);
        ObjectType objectType5 = jSTypeRegistry.getNativeObjectType(JSTypeNative.BOOLEAN_OBJECT_TYPE);
        ObjectType objectType6 = jSTypeRegistry.getNativeObjectType(JSTypeNative.NUMBER_OBJECT_TYPE);
        ObjectType objectType7 = jSTypeRegistry.getNativeObjectType(JSTypeNative.STRING_OBJECT_TYPE);
        FunctionPrototypeType functionPrototypeType = jSTypeRegistry.getNativeFunctionType(JSTypeNative.OBJECT_FUNCTION_TYPE).getPrototype();
        BaseJSTypeTestCase.addMethod(jSTypeRegistry, functionPrototypeType, "constructor", objectType);
        BaseJSTypeTestCase.addMethod(jSTypeRegistry, functionPrototypeType, "toString", jSType3);
        BaseJSTypeTestCase.addMethod(jSTypeRegistry, functionPrototypeType, "toLocaleString", jSType3);
        BaseJSTypeTestCase.addMethod(jSTypeRegistry, functionPrototypeType, "valueOf", jSType4);
        BaseJSTypeTestCase.addMethod(jSTypeRegistry, functionPrototypeType, "hasOwnProperty", jSType);
        BaseJSTypeTestCase.addMethod(jSTypeRegistry, functionPrototypeType, "isPrototypeOf", jSType);
        BaseJSTypeTestCase.addMethod(jSTypeRegistry, functionPrototypeType, "propertyIsEnumerable", jSType);
        FunctionPrototypeType functionPrototypeType2 = jSTypeRegistry.getNativeFunctionType(JSTypeNative.ARRAY_FUNCTION_TYPE).getPrototype();
        BaseJSTypeTestCase.addMethod(jSTypeRegistry, functionPrototypeType2, "constructor", objectType2);
        BaseJSTypeTestCase.addMethod(jSTypeRegistry, functionPrototypeType2, "toString", jSType3);
        BaseJSTypeTestCase.addMethod(jSTypeRegistry, functionPrototypeType2, "toLocaleString", jSType3);
        BaseJSTypeTestCase.addMethod(jSTypeRegistry, functionPrototypeType2, "concat", objectType2);
        BaseJSTypeTestCase.addMethod(jSTypeRegistry, functionPrototypeType2, "join", jSType3);
        BaseJSTypeTestCase.addMethod(jSTypeRegistry, functionPrototypeType2, "pop", jSType4);
        BaseJSTypeTestCase.addMethod(jSTypeRegistry, functionPrototypeType2, "push", jSType2);
        BaseJSTypeTestCase.addMethod(jSTypeRegistry, functionPrototypeType2, "reverse", objectType2);
        BaseJSTypeTestCase.addMethod(jSTypeRegistry, functionPrototypeType2, "shift", jSType4);
        BaseJSTypeTestCase.addMethod(jSTypeRegistry, functionPrototypeType2, "slice", objectType2);
        BaseJSTypeTestCase.addMethod(jSTypeRegistry, functionPrototypeType2, "sort", objectType2);
        BaseJSTypeTestCase.addMethod(jSTypeRegistry, functionPrototypeType2, "splice", objectType2);
        BaseJSTypeTestCase.addMethod(jSTypeRegistry, functionPrototypeType2, "unshift", jSType2);
        objectType2.defineDeclaredProperty("length", jSType2, true);
        FunctionPrototypeType functionPrototypeType3 = jSTypeRegistry.getNativeFunctionType(JSTypeNative.BOOLEAN_OBJECT_FUNCTION_TYPE).getPrototype();
        BaseJSTypeTestCase.addMethod(jSTypeRegistry, functionPrototypeType3, "constructor", objectType5);
        BaseJSTypeTestCase.addMethod(jSTypeRegistry, functionPrototypeType3, "toString", jSType3);
        BaseJSTypeTestCase.addMethod(jSTypeRegistry, functionPrototypeType3, "valueOf", jSType);
        FunctionPrototypeType functionPrototypeType4 = jSTypeRegistry.getNativeFunctionType(JSTypeNative.DATE_FUNCTION_TYPE).getPrototype();
        BaseJSTypeTestCase.addMethod(jSTypeRegistry, functionPrototypeType4, "constructor", objectType3);
        BaseJSTypeTestCase.addMethod(jSTypeRegistry, functionPrototypeType4, "toString", jSType3);
        BaseJSTypeTestCase.addMethod(jSTypeRegistry, functionPrototypeType4, "toDateString", jSType3);
        BaseJSTypeTestCase.addMethod(jSTypeRegistry, functionPrototypeType4, "toTimeString", jSType3);
        BaseJSTypeTestCase.addMethod(jSTypeRegistry, functionPrototypeType4, "toLocaleString", jSType3);
        BaseJSTypeTestCase.addMethod(jSTypeRegistry, functionPrototypeType4, "toLocaleDateString", jSType3);
        BaseJSTypeTestCase.addMethod(jSTypeRegistry, functionPrototypeType4, "toLocaleTimeString", jSType3);
        BaseJSTypeTestCase.addMethod(jSTypeRegistry, functionPrototypeType4, "valueOf", jSType2);
        BaseJSTypeTestCase.addMethod(jSTypeRegistry, functionPrototypeType4, "getTime", jSType2);
        BaseJSTypeTestCase.addMethod(jSTypeRegistry, functionPrototypeType4, "getFullYear", jSType2);
        BaseJSTypeTestCase.addMethod(jSTypeRegistry, functionPrototypeType4, "getUTCFullYear", jSType2);
        BaseJSTypeTestCase.addMethod(jSTypeRegistry, functionPrototypeType4, "getMonth", jSType2);
        BaseJSTypeTestCase.addMethod(jSTypeRegistry, functionPrototypeType4, "getUTCMonth", jSType2);
        BaseJSTypeTestCase.addMethod(jSTypeRegistry, functionPrototypeType4, "getDate", jSType2);
        BaseJSTypeTestCase.addMethod(jSTypeRegistry, functionPrototypeType4, "getUTCDate", jSType2);
        BaseJSTypeTestCase.addMethod(jSTypeRegistry, functionPrototypeType4, "getDay", jSType2);
        BaseJSTypeTestCase.addMethod(jSTypeRegistry, functionPrototypeType4, "getUTCDay", jSType2);
        BaseJSTypeTestCase.addMethod(jSTypeRegistry, functionPrototypeType4, "getHours", jSType2);
        BaseJSTypeTestCase.addMethod(jSTypeRegistry, functionPrototypeType4, "getUTCHours", jSType2);
        BaseJSTypeTestCase.addMethod(jSTypeRegistry, functionPrototypeType4, "getMinutes", jSType2);
        BaseJSTypeTestCase.addMethod(jSTypeRegistry, functionPrototypeType4, "getUTCMinutes", jSType2);
        BaseJSTypeTestCase.addMethod(jSTypeRegistry, functionPrototypeType4, "getSeconds", jSType2);
        BaseJSTypeTestCase.addMethod(jSTypeRegistry, functionPrototypeType4, "getUTCSeconds", jSType2);
        BaseJSTypeTestCase.addMethod(jSTypeRegistry, functionPrototypeType4, "getMilliseconds", jSType2);
        BaseJSTypeTestCase.addMethod(jSTypeRegistry, functionPrototypeType4, "getUTCMilliseconds", jSType2);
        BaseJSTypeTestCase.addMethod(jSTypeRegistry, functionPrototypeType4, "getTimezoneOffset", jSType2);
        BaseJSTypeTestCase.addMethod(jSTypeRegistry, functionPrototypeType4, "setTime", jSType2);
        BaseJSTypeTestCase.addMethod(jSTypeRegistry, functionPrototypeType4, "setMilliseconds", jSType2);
        BaseJSTypeTestCase.addMethod(jSTypeRegistry, functionPrototypeType4, "setUTCMilliseconds", jSType2);
        BaseJSTypeTestCase.addMethod(jSTypeRegistry, functionPrototypeType4, "setSeconds", jSType2);
        BaseJSTypeTestCase.addMethod(jSTypeRegistry, functionPrototypeType4, "setUTCSeconds", jSType2);
        BaseJSTypeTestCase.addMethod(jSTypeRegistry, functionPrototypeType4, "setMinutes", jSType2);
        BaseJSTypeTestCase.addMethod(jSTypeRegistry, functionPrototypeType4, "setUTCMinutes", jSType2);
        BaseJSTypeTestCase.addMethod(jSTypeRegistry, functionPrototypeType4, "setHours", jSType2);
        BaseJSTypeTestCase.addMethod(jSTypeRegistry, functionPrototypeType4, "setUTCHours", jSType2);
        BaseJSTypeTestCase.addMethod(jSTypeRegistry, functionPrototypeType4, "setDate", jSType2);
        BaseJSTypeTestCase.addMethod(jSTypeRegistry, functionPrototypeType4, "setUTCDate", jSType2);
        BaseJSTypeTestCase.addMethod(jSTypeRegistry, functionPrototypeType4, "setMonth", jSType2);
        BaseJSTypeTestCase.addMethod(jSTypeRegistry, functionPrototypeType4, "setUTCMonth", jSType2);
        BaseJSTypeTestCase.addMethod(jSTypeRegistry, functionPrototypeType4, "setFullYear", jSType2);
        BaseJSTypeTestCase.addMethod(jSTypeRegistry, functionPrototypeType4, "setUTCFullYear", jSType2);
        BaseJSTypeTestCase.addMethod(jSTypeRegistry, functionPrototypeType4, "toUTCString", jSType3);
        BaseJSTypeTestCase.addMethod(jSTypeRegistry, functionPrototypeType4, "toGMTString", jSType3);
        FunctionPrototypeType functionPrototypeType5 = jSTypeRegistry.getNativeFunctionType(JSTypeNative.NUMBER_OBJECT_FUNCTION_TYPE).getPrototype();
        BaseJSTypeTestCase.addMethod(jSTypeRegistry, functionPrototypeType5, "constructor", objectType6);
        BaseJSTypeTestCase.addMethod(jSTypeRegistry, functionPrototypeType5, "toString", jSType3);
        BaseJSTypeTestCase.addMethod(jSTypeRegistry, functionPrototypeType5, "toLocaleString", jSType3);
        BaseJSTypeTestCase.addMethod(jSTypeRegistry, functionPrototypeType5, "valueOf", jSType2);
        BaseJSTypeTestCase.addMethod(jSTypeRegistry, functionPrototypeType5, "toFixed", jSType3);
        BaseJSTypeTestCase.addMethod(jSTypeRegistry, functionPrototypeType5, "toExponential", jSType3);
        BaseJSTypeTestCase.addMethod(jSTypeRegistry, functionPrototypeType5, "toPrecision", jSType3);
        FunctionPrototypeType functionPrototypeType6 = jSTypeRegistry.getNativeFunctionType(JSTypeNative.REGEXP_FUNCTION_TYPE).getPrototype();
        BaseJSTypeTestCase.addMethod(jSTypeRegistry, functionPrototypeType6, "constructor", objectType4);
        BaseJSTypeTestCase.addMethod(jSTypeRegistry, functionPrototypeType6, "exec", jSTypeRegistry.createNullableType(objectType2));
        BaseJSTypeTestCase.addMethod(jSTypeRegistry, functionPrototypeType6, "test", jSType);
        BaseJSTypeTestCase.addMethod(jSTypeRegistry, functionPrototypeType6, "toString", jSType3);
        objectType4.defineDeclaredProperty("source", jSType3, true);
        objectType4.defineDeclaredProperty("global", jSType, true);
        objectType4.defineDeclaredProperty("ignoreCase", jSType, true);
        objectType4.defineDeclaredProperty("multiline", jSType, true);
        objectType4.defineDeclaredProperty("lastIndex", jSType2, true);
        FunctionPrototypeType functionPrototypeType7 = jSTypeRegistry.getNativeFunctionType(JSTypeNative.STRING_OBJECT_FUNCTION_TYPE).getPrototype();
        BaseJSTypeTestCase.addMethod(jSTypeRegistry, functionPrototypeType7, "constructor", objectType7);
        BaseJSTypeTestCase.addMethod(jSTypeRegistry, functionPrototypeType7, "toString", jSType3);
        BaseJSTypeTestCase.addMethod(jSTypeRegistry, functionPrototypeType7, "valueOf", jSType3);
        BaseJSTypeTestCase.addMethod(jSTypeRegistry, functionPrototypeType7, "charAt", jSType3);
        BaseJSTypeTestCase.addMethod(jSTypeRegistry, functionPrototypeType7, "charCodeAt", jSType2);
        BaseJSTypeTestCase.addMethod(jSTypeRegistry, functionPrototypeType7, "concat", jSType3);
        BaseJSTypeTestCase.addMethod(jSTypeRegistry, functionPrototypeType7, "indexOf", jSType2);
        BaseJSTypeTestCase.addMethod(jSTypeRegistry, functionPrototypeType7, "lastIndexOf", jSType2);
        BaseJSTypeTestCase.addMethod(jSTypeRegistry, functionPrototypeType7, "localeCompare", jSType2);
        BaseJSTypeTestCase.addMethod(jSTypeRegistry, functionPrototypeType7, "match", jSTypeRegistry.createNullableType(objectType2));
        BaseJSTypeTestCase.addMethod(jSTypeRegistry, functionPrototypeType7, "replace", jSType3);
        BaseJSTypeTestCase.addMethod(jSTypeRegistry, functionPrototypeType7, "search", jSType2);
        BaseJSTypeTestCase.addMethod(jSTypeRegistry, functionPrototypeType7, "slice", jSType3);
        BaseJSTypeTestCase.addMethod(jSTypeRegistry, functionPrototypeType7, "split", objectType2);
        BaseJSTypeTestCase.addMethod(jSTypeRegistry, functionPrototypeType7, "substring", jSType3);
        BaseJSTypeTestCase.addMethod(jSTypeRegistry, functionPrototypeType7, "toLowerCase", jSType3);
        BaseJSTypeTestCase.addMethod(jSTypeRegistry, functionPrototypeType7, "toLocaleLowerCase", jSType3);
        BaseJSTypeTestCase.addMethod(jSTypeRegistry, functionPrototypeType7, "toUpperCase", jSType3);
        BaseJSTypeTestCase.addMethod(jSTypeRegistry, functionPrototypeType7, "toLocaleUpperCase", jSType3);
        objectType7.defineDeclaredProperty("length", jSType2, true);
    }

    private static void addMethod(JSTypeRegistry jSTypeRegistry, ObjectType objectType, String string, JSType jSType) {
        objectType.defineDeclaredProperty(string, new FunctionBuilder(jSTypeRegistry).withReturnType(jSType).build(), true);
    }

    protected JSType createUnionType(JSType ... jSTypeArray) {
        return this.registry.createUnionType(jSTypeArray);
    }

    protected RecordTypeBuilder createRecordTypeBuilder() {
        return new RecordTypeBuilder(this.registry);
    }

    protected JSType createNullableType(JSType jSType) {
        return this.registry.createNullableType(jSType);
    }

    protected JSType createOptionalType(JSType jSType) {
        return this.registry.createOptionalType(jSType);
    }

    protected void assertTypeEquals(JSType jSType, Node node) {
        this.assertTypeEquals(jSType, new JSTypeExpression(node, ""));
    }

    protected void assertTypeEquals(JSType jSType, JSTypeExpression jSTypeExpression) {
        BaseJSTypeTestCase.assertEquals((Object)jSType, (Object)this.resolve(jSTypeExpression, new String[0]));
    }

    protected JSType resolve(JSTypeExpression jSTypeExpression, String ... stringArray) {
        this.errorReporter.setWarnings(stringArray);
        return jSTypeExpression.evaluate(null, this.registry);
    }
}

