/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino.jstype;

import com.google.javascript.rhino.ErrorReporter;
import com.google.javascript.rhino.jstype.EnumElementType;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.ObjectType;
import com.google.javascript.rhino.jstype.PrototypeObjectType;
import com.google.javascript.rhino.jstype.StaticScope;
import com.google.javascript.rhino.jstype.TernaryValue;
import com.google.javascript.rhino.jstype.Visitor;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class EnumType
extends PrototypeObjectType {
    private static final long serialVersionUID = 1L;
    private EnumElementType elementsType;
    private final Set<String> elements = new HashSet<String>();

    EnumType(JSTypeRegistry jSTypeRegistry, String string, JSType jSType) {
        super(jSTypeRegistry, "enum{" + string + "}", null);
        this.elementsType = new EnumElementType(jSTypeRegistry, jSType, string);
    }

    @Override
    public boolean isEnumType() {
        return true;
    }

    @Override
    public ObjectType getImplicitPrototype() {
        return this.registry.getNativeObjectType(JSTypeNative.OBJECT_TYPE);
    }

    public Set<String> getElements() {
        return Collections.unmodifiableSet(this.elements);
    }

    public boolean defineElement(String string) {
        this.elements.add(string);
        return this.defineDeclaredProperty(string, this.elementsType, false);
    }

    public EnumElementType getElementsType() {
        return this.elementsType;
    }

    @Override
    public TernaryValue testForEquality(JSType jSType) {
        TernaryValue ternaryValue = super.testForEquality(jSType);
        if (ternaryValue != null) {
            return ternaryValue;
        }
        return this.isEquivalentTo(jSType) ? TernaryValue.TRUE : TernaryValue.FALSE;
    }

    @Override
    public boolean isSubtype(JSType jSType) {
        return jSType.isEquivalentTo(this.getNativeType(JSTypeNative.OBJECT_TYPE)) || jSType.isEquivalentTo(this.getNativeType(JSTypeNative.OBJECT_PROTOTYPE)) || JSType.isSubtype(this, jSType);
    }

    @Override
    public String toString() {
        return this.getReferenceName();
    }

    @Override
    public <T> T visit(Visitor<T> visitor) {
        return visitor.caseObjectType(this);
    }

    @Override
    public FunctionType getConstructor() {
        return null;
    }

    @Override
    public boolean matchesNumberContext() {
        return false;
    }

    @Override
    public boolean matchesStringContext() {
        return true;
    }

    @Override
    public boolean matchesObjectContext() {
        return true;
    }

    @Override
    JSType resolveInternal(ErrorReporter errorReporter, StaticScope<JSType> staticScope) {
        this.elementsType = (EnumElementType)this.elementsType.resolve(errorReporter, staticScope);
        return super.resolveInternal(errorReporter, staticScope);
    }
}

