/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.deps;

import com.google.common.base.CharMatcher;
import com.google.common.collect.Lists;
import com.google.javascript.jscomp.ErrorManager;
import com.google.javascript.jscomp.deps.DependencyInfo;
import com.google.javascript.jscomp.deps.JsFileLineParser;
import com.google.javascript.jscomp.deps.SimpleDependencyInfo;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JsFileParser
extends JsFileLineParser {
    private static Logger logger = Logger.getLogger(JsFileParser.class.getName());
    private static final Pattern GOOG_PROVIDE_REQUIRE_PATTERN = Pattern.compile("(?:^|;)\\s*goog\\.(provide|require)\\s*\\((.*?)\\)");
    private Matcher googMatcher = GOOG_PROVIDE_REQUIRE_PATTERN.matcher("");
    private List<String> provides;
    private List<String> requires;

    public JsFileParser(ErrorManager errorManager) {
        super(errorManager);
    }

    public DependencyInfo parseFile(String string, String string2) throws IOException {
        return this.parseReader(string, string2, new FileReader(string));
    }

    public DependencyInfo parseFile(String string, String string2, String string3) {
        return this.parseReader(string, string2, new StringReader(string3));
    }

    private DependencyInfo parseReader(String string, String string2, Reader reader) {
        this.provides = Lists.newArrayList();
        this.requires = Lists.newArrayList();
        logger.fine("Parsing Source: " + string);
        this.doParse(string, reader);
        SimpleDependencyInfo simpleDependencyInfo = new SimpleDependencyInfo(string2, string, this.provides, this.requires);
        logger.fine("DepInfo: " + simpleDependencyInfo);
        return simpleDependencyInfo;
    }

    @Override
    protected boolean parseLine(String string) throws JsFileLineParser.ParseException {
        boolean bl = false;
        if (string.indexOf("provide") != -1 || string.indexOf("require") != -1) {
            this.googMatcher.reset(string);
            while (this.googMatcher.find()) {
                bl = true;
                boolean bl2 = this.googMatcher.group(1).charAt(0) == 'r';
                String string2 = this.parseJsString(this.googMatcher.group(2));
                if (bl2) {
                    if ("goog".equals(string2)) continue;
                    this.requires.add(string2);
                    continue;
                }
                this.provides.add(string2);
            }
        }
        return !this.shortcutMode || bl || CharMatcher.WHITESPACE.matchesAllOf((CharSequence)string);
    }
}

