/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.ControlFlowAnalysis;
import com.google.javascript.jscomp.ControlFlowGraph;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.graph.DiGraph;
import com.google.javascript.jscomp.graph.GraphReachability;
import com.google.javascript.rhino.Node;
import java.util.Deque;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;

class UnreachableCodeElimination
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass,
NodeTraversal.ScopedCallback {
    private static final Logger logger = Logger.getLogger(UnreachableCodeElimination.class.getName());
    private final AbstractCompiler compiler;
    private final boolean removeNoOpStatements;
    Deque<ControlFlowGraph<Node>> cfgStack = new LinkedList<ControlFlowGraph<Node>>();
    ControlFlowGraph<Node> curCfg = null;

    UnreachableCodeElimination(AbstractCompiler abstractCompiler, boolean bl) {
        this.compiler = abstractCompiler;
        this.removeNoOpStatements = bl;
    }

    @Override
    public void enterScope(NodeTraversal nodeTraversal) {
        Scope scope = nodeTraversal.getScope();
        ControlFlowAnalysis controlFlowAnalysis = new ControlFlowAnalysis(this.compiler, false, false);
        controlFlowAnalysis.process(null, scope.getRootNode());
        this.cfgStack.push(this.curCfg);
        this.curCfg = controlFlowAnalysis.getCfg();
        new GraphReachability(this.curCfg).compute(this.curCfg.getEntry().getValue());
    }

    @Override
    public void exitScope(NodeTraversal nodeTraversal) {
        this.curCfg = this.cfgStack.pop();
    }

    @Override
    public void process(Node node, Node node2) {
        NodeTraversal.traverse(this.compiler, node2, this);
    }

    @Override
    public void visit(NodeTraversal nodeTraversal, Node object, Node node) {
        Object object2;
        if (node == null) {
            return;
        }
        if (((Node)object).getType() == 105 || ((Node)object).getType() == 132) {
            return;
        }
        if (((Node)object).getType() == 77) {
            object2 = ((Node)object).getFirstChild();
            Node node2 = ((Node)object2).getNext();
            Node node3 = node2.getNext();
            if (!(node2.hasChildren() || node3 != null && node3.hasChildren())) {
                ((Node)object).removeChild((Node)object2);
                node.replaceChild((Node)object, (Node)object2);
                this.compiler.reportCodeChange();
                object = object2;
            }
        }
        if ((object2 = this.curCfg.getDirectedGraphNode((Node)object)) == null) {
            return;
        }
        if (object2.getAnnotation() != GraphReachability.REACHABLE || this.removeNoOpStatements && !NodeUtil.mayHaveSideEffects((Node)object)) {
            this.removeDeadExprStatementSafely((Node)object);
            return;
        }
        this.tryRemoveUnconditionalBranching((Node)object);
    }

    private Node tryRemoveUnconditionalBranching(Node node) {
        Object object;
        if (node == null) {
            return node;
        }
        DiGraph.DiGraphNode diGraphNode = this.curCfg.getDirectedGraphNode(node);
        if (diGraphNode == null) {
            return node;
        }
        if (node.getParent() == null && (object = diGraphNode.getOutEdges()).size() == 1) {
            return this.tryRemoveUnconditionalBranching((Node)object.get(0).getDestination().getValue());
        }
        switch (node.getType()) {
            case 125: {
                if (node.hasChildren()) {
                    object = node.getFirstChild();
                    return this.tryRemoveUnconditionalBranching((Node)object);
                }
                return this.tryRemoveUnconditionalBranching(ControlFlowAnalysis.computeFollowNode(node));
            }
            case 4: {
                if (node.hasChildren()) break;
            }
            case 116: 
            case 117: {
                object = diGraphNode.getOutEdges();
                if (object.size() != 1 || node.getNext() != null && node.getNext().getType() != 105) break;
                Preconditions.checkState((((DiGraph.DiGraphEdge)object.get(0)).getValue() == ControlFlowGraph.Branch.UNCOND ? 1 : 0) != 0);
                Node node2 = this.tryRemoveUnconditionalBranching(ControlFlowAnalysis.computeFollowNode(node));
                Node node3 = (Node)((DiGraph.DiGraphEdge)object.get(0)).getDestination().getValue();
                if (node3 != node2) break;
                this.removeDeadExprStatementSafely(node);
                return node2;
            }
        }
        return node;
    }

    private void removeDeadExprStatementSafely(Node node) {
        if (node.getType() == 124 || node.getType() == 125 && !node.hasChildren()) {
            return;
        }
        switch (node.getType()) {
            case 77: 
            case 114: 
            case 120: 
            case 121: {
                return;
            }
        }
        NodeUtil.redeclareVarsInsideBranch(node);
        this.compiler.reportCodeChange();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Removing " + node.toString());
        }
        NodeUtil.removeChild(node.getParent(), node);
    }
}

