/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import com.google.javascript.rhino.TokenStream;
import com.google.javascript.rhino.jstype.TernaryValue;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public final class NodeUtil {
    static final String JSC_PROPERTY_NAME_FN = "JSCompiler_renameProperty";
    private static final Set<String> CONSTRUCTORS_WITHOUT_SIDE_EFFECTS = new HashSet<String>(Arrays.asList("Array", "Date", "Error", "Object", "RegExp", "XMLHttpRequest"));
    private static final Set<String> BUILTIN_FUNCTIONS_WITHOUT_SIDEEFFECTS = ImmutableSet.of((Object)"Object", (Object)"Array", (Object)"String", (Object)"Number", (Object)"Boolean", (Object)"RegExp", (Object[])new String[]{"Error"});
    private static final Set<String> OBJECT_METHODS_WITHOUT_SIDEEFFECTS = ImmutableSet.of((Object)"toString", (Object)"valueOf");
    private static final Set<String> REGEXP_METHODS = ImmutableSet.of((Object)"test", (Object)"exec");
    private static final Set<String> STRING_REGEXP_METHODS = ImmutableSet.of((Object)"match", (Object)"replace", (Object)"search", (Object)"split");

    private NodeUtil() {
    }

    static TernaryValue getExpressionBooleanValue(Node node) {
        switch (node.getType()) {
            case 85: 
            case 86: {
                return NodeUtil.getExpressionBooleanValue(node.getLastChild());
            }
            case 26: {
                TernaryValue ternaryValue = NodeUtil.getExpressionBooleanValue(node.getLastChild());
                return ternaryValue.not();
            }
            case 101: {
                TernaryValue ternaryValue = NodeUtil.getExpressionBooleanValue(node.getFirstChild());
                TernaryValue ternaryValue2 = NodeUtil.getExpressionBooleanValue(node.getLastChild());
                return ternaryValue.and(ternaryValue2);
            }
            case 100: {
                TernaryValue ternaryValue = NodeUtil.getExpressionBooleanValue(node.getFirstChild());
                TernaryValue ternaryValue3 = NodeUtil.getExpressionBooleanValue(node.getLastChild());
                return ternaryValue.or(ternaryValue3);
            }
            case 98: {
                TernaryValue ternaryValue = NodeUtil.getExpressionBooleanValue(node.getFirstChild().getNext());
                TernaryValue ternaryValue4 = NodeUtil.getExpressionBooleanValue(node.getLastChild());
                if (ternaryValue.equals((Object)ternaryValue4)) {
                    return ternaryValue;
                }
                return TernaryValue.UNKNOWN;
            }
        }
        return NodeUtil.getBooleanValue(node);
    }

    static TernaryValue getBooleanValue(Node node) {
        switch (node.getType()) {
            case 40: {
                return TernaryValue.forBoolean(node.getString().length() > 0);
            }
            case 39: {
                return TernaryValue.forBoolean(node.getDouble() != 0.0);
            }
            case 41: 
            case 43: 
            case 122: {
                return TernaryValue.FALSE;
            }
            case 38: {
                String string = node.getString();
                if ("undefined".equals(string) || "NaN".equals(string)) {
                    return TernaryValue.FALSE;
                }
                if (!"Infinity".equals(string)) break;
                return TernaryValue.TRUE;
            }
            case 44: 
            case 47: 
            case 63: 
            case 64: {
                return TernaryValue.TRUE;
            }
        }
        return TernaryValue.UNKNOWN;
    }

    static String getStringValue(Node node) {
        switch (node.getType()) {
            case 38: 
            case 40: {
                return node.getString();
            }
            case 39: {
                double d = node.getDouble();
                long l = (long)d;
                if ((double)l == d) {
                    return Long.toString(l);
                }
                return Double.toString(node.getDouble());
            }
            case 41: 
            case 43: 
            case 44: {
                return Node.tokenToName(node.getType());
            }
            case 122: {
                return "undefined";
            }
        }
        return null;
    }

    static String getFunctionName(Node node) {
        Node node2 = node.getParent();
        String string = node.getFirstChild().getString();
        switch (node2.getType()) {
            case 38: {
                return node2.getString();
            }
            case 86: {
                return node2.getFirstChild().getQualifiedName();
            }
        }
        return string != null && string.length() != 0 ? string : null;
    }

    static String getNearestFunctionName(Node node) {
        String string = NodeUtil.getFunctionName(node);
        if (string != null) {
            return string;
        }
        Node node2 = node.getParent();
        switch (node2.getType()) {
            case 40: {
                return NodeUtil.getStringValue(node2);
            }
        }
        return null;
    }

    static boolean isImmutableValue(Node node) {
        switch (node.getType()) {
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 44: {
                return true;
            }
            case 29: 
            case 122: {
                return NodeUtil.isImmutableValue(node.getFirstChild());
            }
            case 38: {
                String string = node.getString();
                return "undefined".equals(string) || "Infinity".equals(string) || "NaN".equals(string);
            }
        }
        return false;
    }

    static boolean isLiteralValue(Node node, boolean bl) {
        switch (node.getType()) {
            case 47: 
            case 63: {
                for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNext()) {
                    if (NodeUtil.isLiteralValue(node2, bl)) continue;
                    return false;
                }
                return true;
            }
            case 64: {
                for (Node node3 = node.getFirstChild(); node3 != null; node3 = node3.getNext()) {
                    if (NodeUtil.isLiteralValue(node3.getFirstChild(), bl)) continue;
                    return false;
                }
                return true;
            }
            case 105: {
                return bl && !NodeUtil.isFunctionDeclaration(node);
            }
        }
        return NodeUtil.isImmutableValue(node);
    }

    static boolean isValidDefineValue(Node node, Set<String> set) {
        switch (node.getType()) {
            case 39: 
            case 40: 
            case 43: 
            case 44: {
                return true;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 45: 
            case 46: {
                return NodeUtil.isValidDefineValue(node.getFirstChild(), set) && NodeUtil.isValidDefineValue(node.getLastChild(), set);
            }
            case 26: 
            case 28: 
            case 29: {
                return NodeUtil.isValidDefineValue(node.getFirstChild(), set);
            }
            case 33: 
            case 38: {
                if (!node.isQualifiedName()) break;
                return set.contains(node.getQualifiedName());
            }
        }
        return false;
    }

    static boolean isEmptyBlock(Node node) {
        if (node.getType() != 125) {
            return false;
        }
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNext()) {
            if (node2.getType() == 124) continue;
            return false;
        }
        return true;
    }

    static boolean isSimpleOperator(Node node) {
        return NodeUtil.isSimpleOperatorType(node.getType());
    }

    static boolean isSimpleOperatorType(int n) {
        switch (n) {
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 32: 
            case 33: 
            case 35: 
            case 45: 
            case 46: 
            case 52: 
            case 85: 
            case 122: {
                return true;
            }
        }
        return false;
    }

    public static Node newExpr(Node node) {
        Node node2 = new Node(130, node).copyInformationFrom(node);
        return node2;
    }

    static boolean mayEffectMutableState(Node node) {
        return NodeUtil.mayEffectMutableState(node, null);
    }

    static boolean mayEffectMutableState(Node node, AbstractCompiler abstractCompiler) {
        return NodeUtil.checkForStateChangeHelper(node, true, abstractCompiler);
    }

    static boolean mayHaveSideEffects(Node node) {
        return NodeUtil.mayHaveSideEffects(node, null);
    }

    static boolean mayHaveSideEffects(Node node, AbstractCompiler abstractCompiler) {
        return NodeUtil.checkForStateChangeHelper(node, false, abstractCompiler);
    }

    private static boolean checkForStateChangeHelper(Node node, boolean bl, AbstractCompiler abstractCompiler) {
        switch (node.getType()) {
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 51: 
            case 77: 
            case 83: 
            case 98: 
            case 100: 
            case 101: 
            case 108: 
            case 110: 
            case 124: 
            case 125: 
            case 130: {
                break;
            }
            case 49: {
                return true;
            }
            case 64: {
                if (bl) {
                    return true;
                }
                for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNext()) {
                    if (!NodeUtil.checkForStateChangeHelper(node2.getFirstChild(), bl, abstractCompiler)) continue;
                    return true;
                }
                return false;
            }
            case 47: 
            case 63: {
                if (!bl) break;
                return true;
            }
            case 38: 
            case 118: {
                if (node.getFirstChild() == null) break;
                return true;
            }
            case 105: {
                return bl || !NodeUtil.isFunctionExpression(node);
            }
            case 30: {
                if (bl) {
                    return true;
                }
                if (!NodeUtil.constructorCallHasSideEffects(node)) break;
                return true;
            }
            case 37: {
                if (!NodeUtil.functionCallHasSideEffects(node, abstractCompiler)) break;
                return true;
            }
            default: {
                if (NodeUtil.isSimpleOperatorType(node.getType())) break;
                if (NodeUtil.isAssignmentOp(node)) {
                    Node node3 = node.getFirstChild();
                    if (NodeUtil.isName(node3)) {
                        return true;
                    }
                    if (NodeUtil.checkForStateChangeHelper(node.getFirstChild(), bl, abstractCompiler) || NodeUtil.checkForStateChangeHelper(node.getLastChild(), bl, abstractCompiler)) {
                        return true;
                    }
                    if (NodeUtil.isGet(node3)) {
                        Node node4 = node3.getFirstChild();
                        if (NodeUtil.evaluatesToLocalValue(node4)) {
                            return false;
                        }
                        while (NodeUtil.isGet(node4)) {
                            node4 = node4.getFirstChild();
                        }
                        return !NodeUtil.isLiteralValue(node4, true);
                    }
                    return !NodeUtil.isLiteralValue(node3, true);
                }
                return true;
            }
        }
        for (Node node5 = node.getFirstChild(); node5 != null; node5 = node5.getNext()) {
            if (!NodeUtil.checkForStateChangeHelper(node5, bl, abstractCompiler)) continue;
            return true;
        }
        return false;
    }

    static boolean constructorCallHasSideEffects(Node node) {
        return NodeUtil.constructorCallHasSideEffects(node, null);
    }

    static boolean constructorCallHasSideEffects(Node node, AbstractCompiler abstractCompiler) {
        if (node.getType() != 30) {
            throw new IllegalStateException("Expected NEW node, got " + Token.name(node.getType()));
        }
        if (node.isNoSideEffectsCall()) {
            return false;
        }
        Node node2 = node.getFirstChild();
        return node2.getType() != 38 || !CONSTRUCTORS_WITHOUT_SIDE_EFFECTS.contains(node2.getString());
    }

    static boolean functionCallHasSideEffects(Node node) {
        return NodeUtil.functionCallHasSideEffects(node, null);
    }

    static boolean functionCallHasSideEffects(Node node, @Nullable AbstractCompiler abstractCompiler) {
        if (node.getType() != 37) {
            throw new IllegalStateException("Expected CALL node, got " + Token.name(node.getType()));
        }
        if (node.isNoSideEffectsCall()) {
            return false;
        }
        Node node2 = node.getFirstChild();
        if (node2.getType() == 38) {
            String string = node2.getString();
            if (BUILTIN_FUNCTIONS_WITHOUT_SIDEEFFECTS.contains(string)) {
                return false;
            }
        } else if (node2.getType() == 33) {
            Object object;
            if (node.hasOneChild() && OBJECT_METHODS_WITHOUT_SIDEEFFECTS.contains(node2.getLastChild().getString())) {
                return false;
            }
            if (node.isOnlyModifiesThisCall() && NodeUtil.evaluatesToLocalValue(node2.getFirstChild())) {
                return false;
            }
            if (node2.getFirstChild().getType() == 38 && ((String)(object = node2.getFirstChild().getString())).equals("Math")) {
                return false;
            }
            if (abstractCompiler != null && !abstractCompiler.hasRegExpGlobalReferences()) {
                if (node2.getFirstChild().getType() == 47 && REGEXP_METHODS.contains(node2.getLastChild().getString())) {
                    return false;
                }
                if (node2.getFirstChild().getType() == 40 && STRING_REGEXP_METHODS.contains(node2.getLastChild().getString()) && (object = node2.getNext()) != null && (((Node)object).getType() == 40 || ((Node)object).getType() == 47)) {
                    return false;
                }
            }
        }
        return true;
    }

    static boolean callHasLocalResult(Node node) {
        Preconditions.checkState((node.getType() == 37 ? 1 : 0) != 0);
        return (node.getSideEffectFlags() & 0x10) > 0;
    }

    static boolean nodeTypeMayHaveSideEffects(Node node) {
        return NodeUtil.nodeTypeMayHaveSideEffects(node, null);
    }

    static boolean nodeTypeMayHaveSideEffects(Node node, AbstractCompiler abstractCompiler) {
        if (NodeUtil.isAssignmentOp(node)) {
            return true;
        }
        switch (node.getType()) {
            case 31: 
            case 49: 
            case 102: 
            case 103: {
                return true;
            }
            case 37: {
                return NodeUtil.functionCallHasSideEffects(node, abstractCompiler);
            }
            case 30: {
                return NodeUtil.constructorCallHasSideEffects(node, abstractCompiler);
            }
            case 38: {
                return node.hasChildren();
            }
        }
        return false;
    }

    static boolean canBeSideEffected(Node node) {
        Set<String> set = Collections.emptySet();
        return NodeUtil.canBeSideEffected(node, set);
    }

    static boolean canBeSideEffected(Node node, Set<String> set) {
        switch (node.getType()) {
            case 30: 
            case 37: {
                return true;
            }
            case 38: {
                return !NodeUtil.isConstantName(node) && !set.contains(node.getString());
            }
            case 33: 
            case 35: {
                return true;
            }
            case 105: {
                Preconditions.checkState((boolean)NodeUtil.isFunctionExpression(node));
                return false;
            }
        }
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNext()) {
            if (!NodeUtil.canBeSideEffected(node2, set)) continue;
            return true;
        }
        return false;
    }

    static int precedence(int n) {
        switch (n) {
            case 85: {
                return 0;
            }
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: {
                return 1;
            }
            case 98: {
                return 2;
            }
            case 100: {
                return 3;
            }
            case 101: {
                return 4;
            }
            case 9: {
                return 5;
            }
            case 10: {
                return 6;
            }
            case 11: {
                return 7;
            }
            case 12: 
            case 13: 
            case 45: 
            case 46: {
                return 8;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 51: 
            case 52: {
                return 9;
            }
            case 18: 
            case 19: 
            case 20: {
                return 10;
            }
            case 21: 
            case 22: {
                return 11;
            }
            case 23: 
            case 24: 
            case 25: {
                return 12;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 102: 
            case 103: 
            case 122: {
                return 13;
            }
            case 4: 
            case 33: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 47: 
            case 63: 
            case 64: 
            case 65: 
            case 83: 
            case 105: 
            case 108: 
            case 124: {
                return 15;
            }
        }
        throw new Error("Unknown precedence for " + Node.tokenToName(n) + " (type " + n + ")");
    }

    static boolean isAssociative(int n) {
        switch (n) {
            case 9: 
            case 11: 
            case 23: 
            case 100: 
            case 101: {
                return true;
            }
        }
        return false;
    }

    static boolean isCommutative(int n) {
        switch (n) {
            case 9: 
            case 11: 
            case 23: {
                return true;
            }
        }
        return false;
    }

    static boolean isAssignmentOp(Node node) {
        switch (node.getType()) {
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: {
                return true;
            }
        }
        return false;
    }

    static int getOpFromAssignmentOp(Node node) {
        switch (node.getType()) {
            case 87: {
                return 9;
            }
            case 88: {
                return 10;
            }
            case 89: {
                return 11;
            }
            case 90: {
                return 18;
            }
            case 91: {
                return 19;
            }
            case 92: {
                return 20;
            }
            case 93: {
                return 21;
            }
            case 94: {
                return 22;
            }
            case 95: {
                return 23;
            }
            case 96: {
                return 24;
            }
            case 97: {
                return 25;
            }
        }
        throw new IllegalArgumentException("Not an assiment op");
    }

    static boolean isExpressionNode(Node node) {
        return node.getType() == 130;
    }

    static boolean containsFunction(Node node) {
        return NodeUtil.containsType(node, 105);
    }

    static boolean referencesThis(Node node) {
        return NodeUtil.containsType(node, 42, new MatchNotFunction());
    }

    static boolean isGet(Node node) {
        return node.getType() == 33 || node.getType() == 35;
    }

    static boolean isGetProp(Node node) {
        return node.getType() == 33;
    }

    static boolean isName(Node node) {
        return node.getType() == 38;
    }

    static boolean isNew(Node node) {
        return node.getType() == 30;
    }

    static boolean isVar(Node node) {
        return node.getType() == 118;
    }

    static boolean isVarDeclaration(Node node) {
        return node.getType() == 38 && node.getParent().getType() == 118;
    }

    static Node getAssignedValue(Node node) {
        Preconditions.checkState((boolean)NodeUtil.isName(node));
        Node node2 = node.getParent();
        if (NodeUtil.isVar(node2)) {
            return node.getFirstChild();
        }
        if (NodeUtil.isAssign(node2) && node2.getFirstChild() == node) {
            return node.getNext();
        }
        return null;
    }

    static boolean isString(Node node) {
        return node.getType() == 40;
    }

    static boolean isExprAssign(Node node) {
        return node.getType() == 130 && node.getFirstChild().getType() == 86;
    }

    static boolean isAssign(Node node) {
        return node.getType() == 86;
    }

    static boolean isExprCall(Node node) {
        return node.getType() == 130 && node.getFirstChild().getType() == 37;
    }

    static boolean isForIn(Node node) {
        return node.getType() == 115 && node.getChildCount() == 3;
    }

    static boolean isLoopStructure(Node node) {
        switch (node.getType()) {
            case 113: 
            case 114: 
            case 115: {
                return true;
            }
        }
        return false;
    }

    static Node getLoopCodeBlock(Node node) {
        switch (node.getType()) {
            case 113: 
            case 115: {
                return node.getLastChild();
            }
            case 114: {
                return node.getFirstChild();
            }
        }
        return null;
    }

    static boolean isWithinLoop(Node node) {
        for (Node node2 : node.getAncestors()) {
            if (NodeUtil.isLoopStructure(node2)) {
                return true;
            }
            if (!NodeUtil.isFunction(node2)) continue;
            break;
        }
        return false;
    }

    static boolean isControlStructure(Node node) {
        switch (node.getType()) {
            case 77: 
            case 108: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 119: 
            case 120: 
            case 126: {
                return true;
            }
        }
        return false;
    }

    static boolean isControlStructureCodeBlock(Node node, Node node2) {
        switch (node.getType()) {
            case 113: 
            case 115: 
            case 119: 
            case 126: {
                return node.getLastChild() == node2;
            }
            case 114: {
                return node.getFirstChild() == node2;
            }
            case 108: {
                return node.getFirstChild() != node2;
            }
            case 77: {
                return node.getFirstChild() == node2 || node.getLastChild() == node2;
            }
            case 120: {
                return node.getLastChild() == node2;
            }
            case 110: 
            case 111: {
                return node.getFirstChild() != node2;
            }
            case 112: {
                return true;
            }
        }
        Preconditions.checkState((boolean)NodeUtil.isControlStructure(node));
        return false;
    }

    static Node getConditionExpression(Node node) {
        switch (node.getType()) {
            case 108: 
            case 113: {
                return node.getFirstChild();
            }
            case 114: {
                return node.getLastChild();
            }
            case 115: {
                switch (node.getChildCount()) {
                    case 3: {
                        return null;
                    }
                    case 4: {
                        return node.getFirstChild().getNext();
                    }
                }
                throw new IllegalArgumentException("malformed 'for' statement " + node);
            }
            case 111: {
                return null;
            }
        }
        throw new IllegalArgumentException(node + " does not have a condition.");
    }

    static boolean isStatementBlock(Node node) {
        return node.getType() == 132 || node.getType() == 125;
    }

    static boolean isStatement(Node node) {
        Node node2 = node.getParent();
        Preconditions.checkState((node2 != null ? 1 : 0) != 0);
        switch (node2.getType()) {
            case 125: 
            case 126: 
            case 132: {
                return true;
            }
        }
        return false;
    }

    static boolean isSwitchCase(Node node) {
        return node.getType() == 111 || node.getType() == 112;
    }

    static boolean isReferenceName(Node node) {
        return NodeUtil.isName(node) && !node.getString().isEmpty();
    }

    static boolean isLabelName(Node node) {
        return node != null && node.getType() == 153;
    }

    static boolean isTryFinallyNode(Node node, Node node2) {
        return node.getType() == 77 && node.getChildCount() == 3 && node2 == node.getLastChild();
    }

    static void removeChild(Node node, Node node2) {
        if (NodeUtil.isStatementBlock(node) || NodeUtil.isSwitchCase(node2) || NodeUtil.isTryFinallyNode(node, node2)) {
            node.removeChild(node2);
        } else if (node.getType() == 118) {
            if (node.hasMoreThanOneChild()) {
                node.removeChild(node2);
            } else {
                node.removeChild(node2);
                NodeUtil.removeChild(node.getParent(), node);
            }
        } else if (node2.getType() == 125) {
            node2.detachChildren();
        } else if (node.getType() == 126 && node2 == node.getLastChild()) {
            node.removeChild(node2);
            NodeUtil.removeChild(node.getParent(), node);
        } else if (node.getType() == 115 && node.getChildCount() == 4) {
            node.replaceChild(node2, new Node(124));
        } else {
            throw new IllegalStateException("Invalid attempt to remove node: " + node2.toString() + " of " + node.toString());
        }
    }

    static boolean tryMergeBlock(Node node) {
        Preconditions.checkState((node.getType() == 125 ? 1 : 0) != 0);
        Node node2 = node.getParent();
        if (NodeUtil.isStatementBlock(node2)) {
            Node node3 = node;
            while (node.hasChildren()) {
                Node node4 = node.removeFirstChild();
                node2.addChildAfter(node4, node3);
                node3 = node4;
            }
            node2.removeChild(node);
            return true;
        }
        return false;
    }

    static boolean isCall(Node node) {
        return node.getType() == 37;
    }

    static boolean isCallOrNew(Node node) {
        return NodeUtil.isCall(node) || NodeUtil.isNew(node);
    }

    static boolean isFunction(Node node) {
        return node.getType() == 105;
    }

    static Node getFunctionBody(Node node) {
        Preconditions.checkArgument((boolean)NodeUtil.isFunction(node));
        return node.getLastChild();
    }

    static boolean isThis(Node node) {
        return node.getType() == 42;
    }

    static boolean containsCall(Node node) {
        return NodeUtil.containsType(node, 37);
    }

    static boolean isFunctionDeclaration(Node node) {
        return node.getType() == 105 && NodeUtil.isStatement(node);
    }

    static boolean isHoistedFunctionDeclaration(Node node) {
        return NodeUtil.isFunctionDeclaration(node) && (node.getParent().getType() == 132 || node.getParent().getParent().getType() == 105);
    }

    static boolean isFunctionExpression(Node node) {
        return node.getType() == 105 && !NodeUtil.isStatement(node);
    }

    static boolean isEmptyFunctionExpression(Node node) {
        return NodeUtil.isFunctionExpression(node) && NodeUtil.isEmptyBlock(node.getLastChild());
    }

    static boolean isVarArgsFunction(Node node) {
        Preconditions.checkArgument((boolean)NodeUtil.isFunction(node));
        return NodeUtil.isNameReferenced(node.getLastChild(), "arguments", new MatchNotFunction());
    }

    static boolean isObjectCallMethod(Node node, String string) {
        Node node2;
        Node node3;
        if (node.getType() == 37 && NodeUtil.isGet(node3 = node.getFirstChild()) && (node2 = node3.getLastChild()) != null && node2.getType() == 40) {
            String string2 = node2.getString();
            return string2.equals(string);
        }
        return false;
    }

    static boolean isFunctionObjectCall(Node node) {
        return NodeUtil.isObjectCallMethod(node, "call");
    }

    static boolean isFunctionObjectApply(Node node) {
        return NodeUtil.isObjectCallMethod(node, "apply");
    }

    static boolean isFunctionObjectCallOrApply(Node node) {
        return NodeUtil.isFunctionObjectCall(node) || NodeUtil.isFunctionObjectApply(node);
    }

    static boolean isSimpleFunctionObjectCall(Node node) {
        return NodeUtil.isFunctionObjectCall(node) && node.getFirstChild().getFirstChild().getType() == 38;
    }

    static boolean isLhs(Node node, Node node2) {
        return node2.getType() == 86 && node2.getFirstChild() == node || node2.getType() == 118;
    }

    static boolean isObjectLitKey(Node node, Node node2) {
        return node.getType() == 40 && node2.getType() == 64;
    }

    static String opToStr(int n) {
        switch (n) {
            case 9: {
                return "|";
            }
            case 100: {
                return "||";
            }
            case 10: {
                return "^";
            }
            case 101: {
                return "&&";
            }
            case 11: {
                return "&";
            }
            case 45: {
                return "===";
            }
            case 12: {
                return "==";
            }
            case 26: {
                return "!";
            }
            case 13: {
                return "!=";
            }
            case 46: {
                return "!==";
            }
            case 18: {
                return "<<";
            }
            case 51: {
                return "in";
            }
            case 15: {
                return "<=";
            }
            case 14: {
                return "<";
            }
            case 20: {
                return ">>>";
            }
            case 19: {
                return ">>";
            }
            case 17: {
                return ">=";
            }
            case 16: {
                return ">";
            }
            case 23: {
                return "*";
            }
            case 24: {
                return "/";
            }
            case 25: {
                return "%";
            }
            case 27: {
                return "~";
            }
            case 21: {
                return "+";
            }
            case 22: {
                return "-";
            }
            case 28: {
                return "+";
            }
            case 29: {
                return "-";
            }
            case 86: {
                return "=";
            }
            case 87: {
                return "|=";
            }
            case 88: {
                return "^=";
            }
            case 89: {
                return "&=";
            }
            case 90: {
                return "<<=";
            }
            case 91: {
                return ">>=";
            }
            case 92: {
                return ">>>=";
            }
            case 93: {
                return "+=";
            }
            case 94: {
                return "-=";
            }
            case 95: {
                return "*=";
            }
            case 96: {
                return "/=";
            }
            case 97: {
                return "%=";
            }
            case 122: {
                return "void";
            }
            case 32: {
                return "typeof";
            }
            case 52: {
                return "instanceof";
            }
        }
        return null;
    }

    static String opToStrNoFail(int n) {
        String string = NodeUtil.opToStr(n);
        if (string == null) {
            throw new Error("Unknown op " + n + ": " + Token.name(n));
        }
        return string;
    }

    static boolean containsType(Node node, int n, Predicate<Node> predicate) {
        return NodeUtil.has(node, new MatchNodeType(n), predicate);
    }

    static boolean containsType(Node node, int n) {
        return NodeUtil.containsType(node, n, (Predicate<Node>)Predicates.alwaysTrue());
    }

    static void redeclareVarsInsideBranch(Node node) {
        Collection<Node> collection = NodeUtil.getVarsDeclaredInBranch(node);
        if (collection.isEmpty()) {
            return;
        }
        Node node2 = NodeUtil.getAddingRoot(node);
        for (Node node3 : collection) {
            Node node4 = new Node(118, Node.newString(38, node3.getString()).copyInformationFrom(node3)).copyInformationFrom(node3);
            NodeUtil.copyNameAnnotations(node3, node4.getFirstChild());
            node2.addChildToFront(node4);
        }
    }

    static void copyNameAnnotations(Node node, Node node2) {
        if (node.getBooleanProp(42)) {
            node2.putBooleanProp(42, true);
        }
    }

    private static Node getAddingRoot(Node node) {
        Node node2 = null;
        Node node3 = node;
        while (null != (node3 = node3.getParent())) {
            int n = node3.getType();
            if (n == 132) {
                node2 = node3;
                break;
            }
            if (n != 105) continue;
            node2 = node3.getLastChild();
            break;
        }
        Preconditions.checkState((node2.getType() == 125 || node2.getType() == 132 ? 1 : 0) != 0);
        Preconditions.checkState((node2.getFirstChild() == null || node2.getFirstChild().getType() != 132 ? 1 : 0) != 0);
        return node2;
    }

    public static Node newFunctionNode(String string, List<Node> list, Node node, int n, int n2) {
        Node node2 = new Node(83, n, n2);
        for (Node node3 : list) {
            node2.addChildToBack(node3);
        }
        Node node4 = new Node(105, n, n2);
        node4.addChildrenToBack(Node.newString(38, string, n, n2));
        node4.addChildToBack(node2);
        node4.addChildToBack(node);
        return node4;
    }

    public static Node newQualifiedNameNode(CodingConvention codingConvention, String string, int n, int n2) {
        int n3 = string.indexOf(46);
        if (n3 == -1) {
            return NodeUtil.newName(codingConvention, string, n, n2);
        }
        Node node = NodeUtil.newName(codingConvention, string.substring(0, n3), n, n2);
        do {
            int n4;
            String string2 = (n3 = string.indexOf(46, n4 = n3 + 1)) == -1 ? string.substring(n4) : string.substring(n4, n3);
            Node node2 = Node.newString(40, string2, n, n2);
            if (codingConvention.isConstantKey(string2)) {
                node2.putBooleanProp(42, true);
            }
            node = new Node(33, node, node2, n, n2);
        } while (n3 != -1);
        return node;
    }

    static Node newQualifiedNameNode(CodingConvention codingConvention, String string, Node node, String string2) {
        Node node2 = NodeUtil.newQualifiedNameNode(codingConvention, string, -1, -1);
        NodeUtil.setDebugInformation(node2, node, string2);
        return node2;
    }

    static Node getRootOfQualifiedName(Node node) {
        Node node2 = node;
        int n;
        while ((n = node2.getType()) != 38 && n != 42) {
            Preconditions.checkState((n == 33 ? 1 : 0) != 0);
            node2 = node2.getFirstChild();
        }
        return node2;
    }

    static void setDebugInformation(Node node, Node node2, String string) {
        node.copyInformationFromForTree(node2);
        node.putProp(39, string);
    }

    private static Node newName(CodingConvention codingConvention, String string, int n, int n2) {
        Node node = Node.newString(38, string, n, n2);
        if (codingConvention.isConstant(string)) {
            node.putBooleanProp(42, true);
        }
        return node;
    }

    static Node newName(CodingConvention codingConvention, String string, Node node) {
        Node node2 = Node.newString(38, string);
        if (codingConvention.isConstantKey(string)) {
            node2.putBooleanProp(42, true);
        }
        node2.copyInformationFrom(node);
        return node2;
    }

    static Node newName(CodingConvention codingConvention, String string, Node node, String string2) {
        Node node2 = NodeUtil.newName(codingConvention, string, node);
        node2.putProp(39, string2);
        return node2;
    }

    static boolean isLatin(String string) {
        char c = '\u007f';
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c2 = string.charAt(i);
            if (c2 <= c) continue;
            return false;
        }
        return true;
    }

    static boolean isValidPropertyName(String string) {
        return TokenStream.isJSIdentifier(string) && !TokenStream.isKeyword(string) && NodeUtil.isLatin(string);
    }

    public static Collection<Node> getVarsDeclaredInBranch(Node node) {
        VarCollector varCollector = new VarCollector();
        NodeUtil.visitPreOrder(node, varCollector, new MatchNotFunction());
        return varCollector.vars.values();
    }

    static boolean isPrototypePropertyDeclaration(Node node) {
        if (!NodeUtil.isExprAssign(node)) {
            return false;
        }
        return NodeUtil.isPrototypeProperty(node.getFirstChild().getFirstChild());
    }

    static boolean isPrototypeProperty(Node node) {
        String string = node.getQualifiedName();
        if (string == null) {
            return false;
        }
        int n = string.indexOf(".prototype.");
        return n != -1;
    }

    static Node getPrototypeClassName(Node node) {
        Node node2 = node;
        while (NodeUtil.isGetProp(node2)) {
            if (node2.getLastChild().getString().equals("prototype")) {
                return node2.getFirstChild();
            }
            node2 = node2.getFirstChild();
        }
        return null;
    }

    static String getPrototypePropertyName(Node node) {
        String string = node.getQualifiedName();
        int n = string.lastIndexOf(".prototype.");
        int n2 = n + ".prototype".length() + 1;
        return string.substring(n2);
    }

    static Node newUndefinedNode(Node node) {
        Node node2 = new Node(122, Node.newNumber(0.0));
        if (node != null) {
            node2.copyInformationFromForTree(node);
        }
        return node2;
    }

    static Node newVarNode(String string, Node node) {
        Node node2 = Node.newString(38, string);
        if (node != null) {
            Preconditions.checkState((node.getNext() == null ? 1 : 0) != 0);
            node2.addChildToBack(node);
            node2.copyInformationFrom(node);
        }
        Node node3 = new Node(118, node2).copyInformationFrom(node2);
        return node3;
    }

    static int getNodeTypeReferenceCount(Node node, int n, Predicate<Node> predicate) {
        return NodeUtil.getCount(node, new MatchNodeType(n), predicate);
    }

    static boolean isNameReferenced(Node node, String string, Predicate<Node> predicate) {
        return NodeUtil.has(node, new MatchNameNode(string), predicate);
    }

    static boolean isNameReferenced(Node node, String string) {
        return NodeUtil.isNameReferenced(node, string, (Predicate<Node>)Predicates.alwaysTrue());
    }

    static int getNameReferenceCount(Node node, String string) {
        return NodeUtil.getCount(node, new MatchNameNode(string), (Predicate<Node>)Predicates.alwaysTrue());
    }

    static boolean has(Node node, Predicate<Node> predicate, Predicate<Node> predicate2) {
        if (predicate.apply((Object)node)) {
            return true;
        }
        if (!predicate2.apply((Object)node)) {
            return false;
        }
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNext()) {
            if (!NodeUtil.has(node2, predicate, predicate2)) continue;
            return true;
        }
        return false;
    }

    static int getCount(Node node, Predicate<Node> predicate, Predicate<Node> predicate2) {
        int n = 0;
        if (predicate.apply((Object)node)) {
            ++n;
        }
        if (predicate2.apply((Object)node)) {
            for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNext()) {
                n += NodeUtil.getCount(node2, predicate, predicate2);
            }
        }
        return n;
    }

    static void visitPreOrder(Node node, Visitor visitor, Predicate<Node> predicate) {
        visitor.visit(node);
        if (predicate.apply((Object)node)) {
            for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNext()) {
                NodeUtil.visitPreOrder(node2, visitor, predicate);
            }
        }
    }

    static void visitPostOrder(Node node, Visitor visitor, Predicate<Node> predicate) {
        if (predicate.apply((Object)node)) {
            for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNext()) {
                NodeUtil.visitPostOrder(node2, visitor, predicate);
            }
        }
        visitor.visit(node);
    }

    static boolean hasFinally(Node node) {
        Preconditions.checkArgument((node.getType() == 77 ? 1 : 0) != 0);
        return node.getChildCount() == 3;
    }

    static Node getCatchBlock(Node node) {
        Preconditions.checkArgument((node.getType() == 77 ? 1 : 0) != 0);
        return node.getFirstChild().getNext();
    }

    static boolean hasCatchHandler(Node node) {
        Preconditions.checkArgument((node.getType() == 125 ? 1 : 0) != 0);
        return node.hasChildren() && node.getFirstChild().getType() == 120;
    }

    static Node getFnParameters(Node node) {
        Preconditions.checkArgument((node.getType() == 105 ? 1 : 0) != 0);
        return node.getFirstChild().getNext();
    }

    static boolean isConstantName(Node node) {
        return node.getBooleanProp(42);
    }

    static boolean isConstantByConvention(CodingConvention codingConvention, Node node, Node node2) {
        String string = node.getString();
        if (node2.getType() == 33 && node == node2.getLastChild()) {
            return codingConvention.isConstantKey(string);
        }
        if (NodeUtil.isObjectLitKey(node, node2)) {
            return codingConvention.isConstantKey(string);
        }
        return codingConvention.isConstant(string);
    }

    static JSDocInfo getInfoForNameNode(Node node) {
        JSDocInfo jSDocInfo = null;
        Node node2 = null;
        if (node != null) {
            jSDocInfo = node.getJSDocInfo();
            node2 = node.getParent();
        }
        if (jSDocInfo == null && node2 != null && (node2.getType() == 118 && node2.hasOneChild() || node2.getType() == 105)) {
            jSDocInfo = node2.getJSDocInfo();
        }
        return jSDocInfo;
    }

    static JSDocInfo getFunctionInfo(Node node) {
        Preconditions.checkState((node.getType() == 105 ? 1 : 0) != 0);
        JSDocInfo jSDocInfo = node.getJSDocInfo();
        if (jSDocInfo == null && NodeUtil.isFunctionExpression(node)) {
            Node node2 = node.getParent();
            if (node2.getType() == 86) {
                jSDocInfo = node2.getJSDocInfo();
            } else if (node2.getType() == 38) {
                jSDocInfo = node2.getParent().getJSDocInfo();
            }
        }
        return jSDocInfo;
    }

    static String getSourceName(Node node) {
        String string = null;
        while (string == null && node != null) {
            string = (String)node.getProp(16);
            node = node.getParent();
        }
        return string;
    }

    static Node newCallNode(Node node, Node ... nodeArray) {
        boolean bl = NodeUtil.isName(node);
        Node node2 = new Node(37, node);
        node2.putBooleanProp(49, bl);
        for (Node node3 : nodeArray) {
            node2.addChildToBack(node3);
        }
        return node2;
    }

    static boolean evaluatesToLocalValue(Node node) {
        return NodeUtil.evaluatesToLocalValue(node, (Predicate<Node>)Predicates.alwaysFalse());
    }

    static boolean evaluatesToLocalValue(Node node, Predicate<Node> predicate) {
        switch (node.getType()) {
            case 86: {
                return NodeUtil.isImmutableValue(node.getLastChild()) || predicate.apply((Object)node) && NodeUtil.evaluatesToLocalValue(node.getLastChild(), predicate);
            }
            case 85: {
                return NodeUtil.evaluatesToLocalValue(node.getLastChild(), predicate);
            }
            case 100: 
            case 101: {
                return NodeUtil.evaluatesToLocalValue(node.getFirstChild(), predicate) && NodeUtil.evaluatesToLocalValue(node.getLastChild(), predicate);
            }
            case 98: {
                return NodeUtil.evaluatesToLocalValue(node.getFirstChild().getNext(), predicate) && NodeUtil.evaluatesToLocalValue(node.getLastChild(), predicate);
            }
            case 102: 
            case 103: {
                if (node.getBooleanProp(31)) {
                    return NodeUtil.evaluatesToLocalValue(node.getFirstChild(), predicate);
                }
                return true;
            }
            case 42: {
                return predicate.apply((Object)node);
            }
            case 38: {
                return NodeUtil.isImmutableValue(node) || predicate.apply((Object)node);
            }
            case 33: 
            case 35: {
                return predicate.apply((Object)node);
            }
            case 37: {
                return NodeUtil.callHasLocalResult(node) || NodeUtil.isToStringMethodCall(node) || predicate.apply((Object)node);
            }
            case 30: {
                return true;
            }
            case 47: 
            case 63: 
            case 64: 
            case 105: {
                return true;
            }
            case 51: {
                return true;
            }
        }
        if (NodeUtil.isAssignmentOp(node) || NodeUtil.isSimpleOperator(node) || NodeUtil.isImmutableValue(node)) {
            return true;
        }
        throw new IllegalStateException("Unexpected expression node" + node + "\n parent:" + node.getParent());
    }

    private static Node getNthSibling(Node node, int n) {
        Node node2;
        for (node2 = node; n != 0 && node2 != null; node2 = node2.getNext(), --n) {
        }
        return node2;
    }

    static Node getArgumentForFunction(Node node, int n) {
        Preconditions.checkState((boolean)NodeUtil.isFunction(node));
        return NodeUtil.getNthSibling(node.getFirstChild().getNext().getFirstChild(), n);
    }

    static Node getArgumentForCallOrNew(Node node, int n) {
        Preconditions.checkState((boolean)NodeUtil.isCallOrNew(node));
        return NodeUtil.getNthSibling(node.getFirstChild().getNext(), n);
    }

    private static boolean isToStringMethodCall(Node node) {
        Node node2 = node.getFirstChild();
        if (NodeUtil.isGet(node2)) {
            Node node3 = node2.getLastChild();
            return NodeUtil.isString(node3) && "toString".equals(node3.getString());
        }
        return false;
    }

    static interface Visitor {
        public void visit(Node var1);
    }

    static class MatchShallowStatement
    implements Predicate<Node> {
        MatchShallowStatement() {
        }

        public boolean apply(Node node) {
            Node node2 = node.getParent();
            return node.getType() == 125 || !NodeUtil.isFunction(node) && (node2 == null || NodeUtil.isControlStructure(node2) || NodeUtil.isStatementBlock(node2));
        }
    }

    static class MatchNotFunction
    implements Predicate<Node> {
        MatchNotFunction() {
        }

        public boolean apply(Node node) {
            return !NodeUtil.isFunction(node);
        }
    }

    static class MatchDeclaration
    implements Predicate<Node> {
        MatchDeclaration() {
        }

        public boolean apply(Node node) {
            return NodeUtil.isFunctionDeclaration(node) || node.getType() == 118;
        }
    }

    static class MatchNodeType
    implements Predicate<Node> {
        final int type;

        MatchNodeType(int n) {
            this.type = n;
        }

        public boolean apply(Node node) {
            return node.getType() == this.type;
        }
    }

    private static class MatchNameNode
    implements Predicate<Node> {
        final String name;

        MatchNameNode(String string) {
            this.name = string;
        }

        public boolean apply(Node node) {
            return node.getType() == 38 && node.getString().equals(this.name);
        }
    }

    private static class VarCollector
    implements Visitor {
        final Map<String, Node> vars = Maps.newLinkedHashMap();

        private VarCollector() {
        }

        @Override
        public void visit(Node node) {
            String string;
            Node node2;
            if (node.getType() == 38 && (node2 = node.getParent()) != null && node2.getType() == 118 && !this.vars.containsKey(string = node.getString())) {
                this.vars.put(string, node);
            }
        }
    }
}

