/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.GlobalNamespace;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.ReferenceCollectingCallback;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.TokenStream;
import com.google.javascript.rhino.jstype.JSType;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

class CollapseProperties
implements CompilerPass {
    static final DiagnosticType UNSAFE_NAMESPACE_WARNING = DiagnosticType.warning("JSC_UNSAFE_NAMESPACE", "incomplete alias created for namespace {0}");
    static final DiagnosticType NAMESPACE_REDEFINED_WARNING = DiagnosticType.warning("JSC_NAMESPACE_REDEFINED", "namespace {0} should not be redefined");
    static final DiagnosticType UNSAFE_THIS = DiagnosticType.warning("JSC_UNSAFE_THIS", "dangerous use of 'this' in static method {0}");
    private AbstractCompiler compiler;
    private List<GlobalNamespace.Name> globalNames;
    private Map<String, GlobalNamespace.Name> nameMap;
    private final boolean collapsePropertiesOnExternTypes;
    private final boolean inlineAliases;

    CollapseProperties(AbstractCompiler abstractCompiler, boolean bl, boolean bl2) {
        this.compiler = abstractCompiler;
        this.collapsePropertiesOnExternTypes = bl;
        this.inlineAliases = bl2;
    }

    @Override
    public void process(Node node, Node node2) {
        GlobalNamespace globalNamespace = this.collapsePropertiesOnExternTypes ? new GlobalNamespace(this.compiler, node, node2) : new GlobalNamespace(this.compiler, node2);
        if (this.inlineAliases) {
            this.inlineAliases(globalNamespace);
        }
        this.nameMap = globalNamespace.getNameIndex();
        this.globalNames = globalNamespace.getNameForest();
        this.checkNamespaces();
        for (GlobalNamespace.Name name : this.globalNames) {
            this.flattenReferencesToCollapsibleDescendantNames(name, name.name);
        }
        for (GlobalNamespace.Name name : this.globalNames) {
            this.collapseDeclarationOfNameAndDescendants(name, name.name);
        }
    }

    private void inlineAliases(GlobalNamespace globalNamespace) {
        ArrayDeque<GlobalNamespace.Name> arrayDeque = new ArrayDeque<GlobalNamespace.Name>(globalNamespace.getNameForest());
        while (!arrayDeque.isEmpty()) {
            GlobalNamespace.Name name = (GlobalNamespace.Name)arrayDeque.pop();
            if (name.globalSets == 1 && name.localSets == 0 && name.aliasingGets > 0) {
                ArrayList arrayList = Lists.newArrayList(name.refs);
                for (GlobalNamespace.Ref ref : arrayList) {
                    if (ref.type != GlobalNamespace.Ref.Type.ALIASING_GET || !ref.scope.isLocal() || !this.inlineAliasIfPossible(ref, globalNamespace)) continue;
                    name.removeRef(ref);
                }
            }
            if (name.type != GlobalNamespace.Name.Type.OBJECTLIT && name.type != GlobalNamespace.Name.Type.FUNCTION || name.aliasingGets != 0 || name.props == null) continue;
            arrayDeque.addAll(name.props);
        }
    }

    private boolean inlineAliasIfPossible(GlobalNamespace.Ref ref, GlobalNamespace globalNamespace) {
        Node node = ref.node.getParent();
        if (node.getType() == 38) {
            Scope scope = ref.scope;
            Scope.Var var = scope.getVar(node.getString());
            ReferenceCollectingCallback referenceCollectingCallback = new ReferenceCollectingCallback(this.compiler, ReferenceCollectingCallback.DO_NOTHING_BEHAVIOR, (Predicate<Scope.Var>)Predicates.equalTo((Object)var));
            new NodeTraversal(this.compiler, referenceCollectingCallback).traverseAtScope(scope);
            ReferenceCollectingCallback.ReferenceCollection referenceCollection = referenceCollectingCallback.getReferenceCollection(var);
            if (referenceCollection.isWellDefined() && referenceCollection.firstReferenceIsAssigningDeclaration() && referenceCollection.isAssignedOnceInLifetime()) {
                int n = referenceCollection.references.size();
                HashSet hashSet = Sets.newHashSetWithExpectedSize((int)(n - 1));
                for (int i = 1; i < n; ++i) {
                    ReferenceCollectingCallback.Reference reference = referenceCollection.references.get(i);
                    Node node2 = ref.node.cloneTree();
                    reference.getParent().replaceChild(reference.getNameNode(), node2);
                    hashSet.add(node2);
                }
                node.replaceChild(ref.node, new Node(41));
                this.compiler.reportCodeChange();
                globalNamespace.scanNewNodes(ref.scope, hashSet);
                return true;
            }
        }
        return false;
    }

    private void checkNamespaces() {
        for (GlobalNamespace.Name name : this.nameMap.values()) {
            if (!name.isNamespace() || name.refs == null || name.aliasingGets <= 0 && name.localSets + name.globalSets <= 1) continue;
            boolean bl = name.declaration != null;
            for (GlobalNamespace.Ref ref : name.refs) {
                if (ref.type == GlobalNamespace.Ref.Type.SET_FROM_GLOBAL || ref.type == GlobalNamespace.Ref.Type.SET_FROM_LOCAL) {
                    if (bl) {
                        this.warnAboutNamespaceRedefinition(name, ref);
                    }
                    bl = true;
                    continue;
                }
                if (ref.type != GlobalNamespace.Ref.Type.ALIASING_GET) continue;
                this.warnAboutNamespaceAliasing(name, ref);
            }
        }
    }

    private void warnAboutNamespaceAliasing(GlobalNamespace.Name name, GlobalNamespace.Ref ref) {
        this.compiler.report(JSError.make(ref.sourceName, ref.node, UNSAFE_NAMESPACE_WARNING, name.fullName()));
    }

    private void warnAboutNamespaceRedefinition(GlobalNamespace.Name name, GlobalNamespace.Ref ref) {
        this.compiler.report(JSError.make(ref.sourceName, ref.node, NAMESPACE_REDEFINED_WARNING, name.fullName()));
    }

    private void flattenReferencesToCollapsibleDescendantNames(GlobalNamespace.Name name, String string) {
        if (name.props == null) {
            return;
        }
        for (GlobalNamespace.Name name2 : name.props) {
            String string2 = CollapseProperties.appendPropForAlias(string, name2.name);
            if (name2.canCollapse()) {
                this.flattenReferencesTo(name2, string2);
            }
            this.flattenReferencesToCollapsibleDescendantNames(name2, string2);
        }
    }

    private void flattenReferencesTo(GlobalNamespace.Name name, String string) {
        if (name.refs != null) {
            String string2 = name.fullName();
            for (GlobalNamespace.Ref ref : name.refs) {
                Node node = ref.node.getParent();
                if (NodeUtil.isObjectLitKey(ref.node, node) || ref.getTwin() != null && !ref.isSet()) continue;
                this.flattenNameRef(string, ref.node, node, string2);
            }
        }
        if (name.props != null) {
            for (GlobalNamespace.Name name2 : name.props) {
                this.flattenPrefixes(string, name2, 1);
            }
        }
    }

    private void flattenPrefixes(String string, GlobalNamespace.Name name, int n) {
        String string2 = name.fullName();
        if (name.declaration != null && name.declaration.node != null && name.declaration.node.getType() == 33) {
            this.flattenNameRefAtDepth(string, name.declaration.node, n, string2);
        }
        if (name.refs != null) {
            for (GlobalNamespace.Ref object : name.refs) {
                if (object.getTwin() != null && !object.isSet()) continue;
                this.flattenNameRefAtDepth(string, object.node, n, string2);
            }
        }
        if (name.props != null) {
            for (GlobalNamespace.Name name2 : name.props) {
                this.flattenPrefixes(string, name2, n + 1);
            }
        }
    }

    private void flattenNameRefAtDepth(String string, Node node, int n, String string2) {
        int n2 = node.getType();
        boolean bl = n2 == 38 || n2 == 33;
        boolean bl2 = n2 == 40 || n2 == 39;
        Preconditions.checkState((bl2 || bl ? 1 : 0) != 0);
        if (bl) {
            for (int i = 1; i < n && node.hasChildren(); ++i) {
                node = node.getFirstChild();
            }
            if (node.hasChildren()) {
                this.flattenNameRef(string, node.getFirstChild(), node, string2);
            }
        }
    }

    private void flattenNameRef(String string, Node node, Node node2, String string2) {
        Node node3 = NodeUtil.newName(this.compiler.getCodingConvention(), string, node, string2);
        NodeUtil.copyNameAnnotations(node.getLastChild(), node3);
        JSType jSType = node.getJSType();
        if (jSType != null) {
            node3.setJSType(jSType);
        }
        node2.replaceChild(node, node3);
        this.compiler.reportCodeChange();
    }

    private void collapseDeclarationOfNameAndDescendants(GlobalNamespace.Name name, String string) {
        boolean bl = name.canCollapseUnannotatedChildNames();
        if (name.canCollapse() && bl) {
            this.updateObjLitOrFunctionDeclaration(name, string);
        }
        if (name.props != null) {
            for (GlobalNamespace.Name name2 : name.props) {
                this.collapseDeclarationOfNameAndDescendants(name2, CollapseProperties.appendPropForAlias(string, name2.name));
                if (name2.inExterns || !bl || name2.declaration == null || name2.declaration.node == null || name2.declaration.node.getParent() == null || name2.declaration.node.getParent().getType() != 86) continue;
                this.updateSimpleDeclaration(CollapseProperties.appendPropForAlias(string, name2.name), name2, name2.declaration);
            }
        }
    }

    private void updateSimpleDeclaration(String string, GlobalNamespace.Name name, GlobalNamespace.Ref ref) {
        Node node = ref.node.getNext();
        Node node2 = ref.node.getParent();
        Node node3 = node2.getParent();
        Node node4 = node3.getParent();
        Node node5 = node4.getParent();
        if (node != null && node.getType() == 105) {
            this.checkForHosedThisReferences(node, name.docInfo, name);
        }
        Node node6 = NodeUtil.newName(this.compiler.getCodingConvention(), string, node3.getFirstChild(), name.fullName());
        NodeUtil.copyNameAnnotations(ref.node.getLastChild(), node6);
        if (node3.getType() == 130) {
            node2.removeChild(node);
            node6.addChildToFront(node);
            Node node7 = new Node(118, node6);
            node4.replaceChild(node3, node7);
        } else {
            Preconditions.checkNotNull((Object)ref.getTwin());
            Node node8 = node3;
            Node node9 = node3.getParent();
            while (node9.getType() != 132 && node9.getType() != 125) {
                node8 = node9;
                node9 = node9.getParent();
            }
            Node node10 = new Node(118, node6.cloneTree()).copyInformationFrom(node6);
            node9.addChildBefore(node10, node8);
            node2.replaceChild(ref.node, node6);
        }
        this.compiler.reportCodeChange();
    }

    private void updateObjLitOrFunctionDeclaration(GlobalNamespace.Name name, String string) {
        switch (name.declaration.node.getParent().getType()) {
            case 86: {
                this.updateObjLitOrFunctionDeclarationAtAssignNode(name, string);
                break;
            }
            case 118: {
                this.updateObjLitOrFunctionDeclarationAtVarNode(name);
                break;
            }
            case 105: {
                this.updateFunctionDeclarationAtFunctionNode(name);
            }
        }
    }

    private void updateObjLitOrFunctionDeclarationAtAssignNode(GlobalNamespace.Name name, String string) {
        boolean bl;
        GlobalNamespace.Ref ref = name.declaration;
        Node node = ref.node.getNext();
        Node node2 = new Node(118);
        Node node3 = ref.node.getAncestor(3);
        Node node4 = ref.node.getAncestor(2);
        boolean bl2 = bl = node.getType() == 64;
        if (bl && name.canEliminate()) {
            node3.replaceChild(node4, node2);
            ref.node = null;
        } else {
            if (node.getType() == 105) {
                this.checkForHosedThisReferences(node, name.docInfo, name);
            }
            ref.node.getParent().removeChild(node);
            Node node5 = NodeUtil.newName(this.compiler.getCodingConvention(), string, ref.node.getAncestor(2), name.fullName());
            if (ref.node.getLastChild().getBooleanProp(42)) {
                node5.putBooleanProp(42, true);
            }
            node2.addChildToBack(node5);
            node5.addChildToFront(node);
            node3.replaceChild(node4, node2);
            ref.node = node5;
        }
        if (bl) {
            this.declareVarsForObjLitValues(name, string, node, node2, node3.getChildBefore(node2), node3);
        }
        this.addStubsForUndeclaredProperties(name, string, node3, node2);
        if (!node2.hasChildren()) {
            node3.removeChild(node2);
        }
        this.compiler.reportCodeChange();
    }

    private void checkForHosedThisReferences(Node node, JSDocInfo jSDocInfo, final GlobalNamespace.Name name) {
        if (jSDocInfo == null || !jSDocInfo.isConstructor() && !jSDocInfo.hasThisType()) {
            NodeTraversal.traverse(this.compiler, node.getLastChild(), new NodeTraversal.AbstractShallowCallback(){

                @Override
                public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
                    if (node.getType() == 42) {
                        CollapseProperties.this.compiler.report(JSError.make(name.declaration.sourceName, node, UNSAFE_THIS, name.fullName()));
                    }
                }
            });
        }
    }

    private void updateObjLitOrFunctionDeclarationAtVarNode(GlobalNamespace.Name name) {
        GlobalNamespace.Ref ref = name.declaration;
        String string = ref.node.getString();
        Node node = ref.node.getFirstChild();
        Node node2 = ref.node.getParent();
        Node node3 = node2.getParent();
        boolean bl = node.getType() == 64;
        int n = 0;
        if (bl) {
            n += this.declareVarsForObjLitValues(name, string, node, node2, node3.getChildBefore(node2), node3);
        }
        n += this.addStubsForUndeclaredProperties(name, string, node3, node2);
        if (bl && name.canEliminate()) {
            node2.removeChild(ref.node);
            if (!node2.hasChildren()) {
                node3.removeChild(node2);
            }
            ++n;
            ref.node = null;
        }
        if (n > 0) {
            this.compiler.reportCodeChange();
        }
    }

    private void updateFunctionDeclarationAtFunctionNode(GlobalNamespace.Name name) {
        GlobalNamespace.Ref ref = name.declaration;
        String string = ref.node.getString();
        this.addStubsForUndeclaredProperties(name, string, ref.node.getAncestor(2), ref.node.getParent());
    }

    private int declareVarsForObjLitValues(GlobalNamespace.Name name, String string, Node node, Node node2, Node node3, Node node4) {
        int n = 0;
        int n2 = 0;
        boolean bl = !name.shouldKeepKeys();
        Node node5 = node.getFirstChild();
        while (node5 != null) {
            GlobalNamespace.Name name2;
            Node node6 = node5.getFirstChild();
            Node node7 = node5.getNext();
            boolean bl2 = node5.getType() != 39 && TokenStream.isJSIdentifier(node5.getString());
            String string2 = bl2 ? node5.getString() : String.valueOf(++n2);
            String string3 = CollapseProperties.appendPropForAlias(string, string2);
            String string4 = name.fullName() + '.' + string2;
            Node node8 = null;
            if (bl) {
                node.removeChild(node5);
                node6.detachFromParent();
            } else {
                node8 = Node.newString(38, string3);
                if (node5.getBooleanProp(42)) {
                    node8.putBooleanProp(42, true);
                }
                node5.replaceChild(node6, node8);
            }
            Node node9 = Node.newString(38, string3);
            node9.addChildToFront(node6);
            if (node5.getBooleanProp(42)) {
                node9.putBooleanProp(42, true);
            }
            Node node10 = new Node(118, node9).copyInformationFromForTree(node5);
            if (node3 != null) {
                node4.addChildAfter(node10, node3);
            } else {
                node4.addChildBefore(node10, node2);
            }
            this.compiler.reportCodeChange();
            node3 = node10;
            if (bl2 && (name2 = this.nameMap.get(string4)) != null) {
                if (!bl) {
                    GlobalNamespace.Ref ref = name2.declaration.cloneAndReclassify(GlobalNamespace.Ref.Type.ALIASING_GET);
                    ref.node = node8;
                    name2.addRef(ref);
                }
                name2.declaration.node = node9;
                if (node6.getType() == 105) {
                    this.checkForHosedThisReferences(node6, node6.getJSDocInfo(), name2);
                }
            }
            ++n;
            node5 = node7;
        }
        return n;
    }

    private int addStubsForUndeclaredProperties(GlobalNamespace.Name name, String string, Node node, Node node2) {
        Preconditions.checkArgument((boolean)NodeUtil.isStatementBlock(node));
        Preconditions.checkNotNull((Object)node2);
        int n = 0;
        if (name.props != null) {
            for (GlobalNamespace.Name name2 : name.props) {
                if (!name2.needsToBeStubbed()) continue;
                String string2 = CollapseProperties.appendPropForAlias(string, name2.name);
                Node node3 = Node.newString(38, string2);
                Node node4 = new Node(118, node3).copyInformationFromForTree(node2);
                node.addChildAfter(node4, node2);
                node2 = node4;
                ++n;
                this.compiler.reportCodeChange();
                if (!name2.refs.get((int)0).node.getLastChild().getBooleanProp(42)) continue;
                node3.putBooleanProp(42, true);
            }
        }
        return n;
    }

    private static String appendPropForAlias(String string, String string2) {
        if (string2.indexOf(36) != -1) {
            string2 = string2.replaceAll("\\$", "\\$0");
        }
        return string + '$' + string2;
    }
}

