/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.grapher.graphviz;

import com.google.inject.Inject;
import com.google.inject.grapher.BindingEdge;
import com.google.inject.grapher.graphviz.ArrowType;
import com.google.inject.grapher.graphviz.EdgeStyle;
import com.google.inject.grapher.graphviz.GraphvizEdge;
import com.google.inject.grapher.graphviz.GraphvizRenderer;
import com.google.inject.internal.util.;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BindingEdgeFactory
implements BindingEdge.Factory<String, BindingEdge<String>> {
    private final GraphvizRenderer renderer;

    @Inject
    public BindingEdgeFactory(GraphvizRenderer renderer) {
        this.renderer = renderer;
    }

    @Override
    public BindingEdge<String> newBindingEdge(String fromId, String toId) {
        GraphvizEdge edge = new GraphvizEdge(fromId, toId);
        this.renderer.addEdge(edge);
        return this.newAdaptor(edge);
    }

    protected GraphvizEdgeAdaptor newAdaptor(GraphvizEdge edge) {
        return new GraphvizEdgeAdaptor(edge);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class GraphvizEdgeAdaptor
    implements BindingEdge<String> {
        protected final GraphvizEdge edge;

        public GraphvizEdgeAdaptor(GraphvizEdge edge) {
            this.edge = edge;
            this.edge.setStyle(EdgeStyle.DASHED);
        }

        @Override
        public void setType(BindingEdge.Type type) {
            switch (type) {
                case NORMAL: {
                    this.edge.setArrowHead((List<ArrowType>).ImmutableList.of((Object)((Object)ArrowType.NORMAL_OPEN)));
                    break;
                }
                case PROVIDER: {
                    this.edge.setArrowHead((List<ArrowType>).ImmutableList.of((Object)((Object)ArrowType.NORMAL_OPEN), (Object)((Object)ArrowType.NORMAL_OPEN)));
                    break;
                }
                case CONVERTED_CONSTANT: {
                    this.edge.setArrowHead((List<ArrowType>).ImmutableList.of((Object)((Object)ArrowType.NORMAL_OPEN), (Object)((Object)ArrowType.DOT_OPEN)));
                }
            }
        }
    }
}

