/*
 * Decompiled with CFR 0.152.
 */
package com.google.web.bindery.requestfactory.shared.impl;

class IdUtil {
    private static final String ANY_SEPARATOR_PATTERN = "@[012]@";
    private static final String EPHEMERAL_SEPARATOR = "@1@";
    private static final String TOKEN_SEPARATOR = "@0@";
    private static final String SYNTHETIC_SEPARATOR = "@2@";
    private static final int ID_TOKEN_INDEX = 0;
    private static final int TYPE_TOKEN_INDEX = 1;

    public static String ephemeralId(int clientId, String typeToken) {
        String string = String.valueOf(EPHEMERAL_SEPARATOR);
        return new StringBuilder(11 + String.valueOf(string).length() + String.valueOf(typeToken).length()).append(clientId).append(string).append(typeToken).toString();
    }

    public static int getClientId(String encodedId) {
        return Integer.valueOf(IdUtil.asEphemeral(encodedId)[0]);
    }

    public static String getServerId(String encodedId) {
        return IdUtil.asPersisted(encodedId)[0];
    }

    public static int getSyntheticId(String encodedId) {
        return Integer.valueOf(IdUtil.asSynthetic(encodedId)[0]);
    }

    public static String getTypeToken(String encodedId) {
        String[] split = IdUtil.asAny(encodedId);
        if (split.length == 2) {
            return split[1];
        }
        return null;
    }

    public static boolean isEphemeral(String encodedId) {
        return encodedId.contains(EPHEMERAL_SEPARATOR);
    }

    public static boolean isPersisted(String encodedId) {
        return encodedId.contains(TOKEN_SEPARATOR);
    }

    public static boolean isSynthetic(String encodedId) {
        return encodedId.contains(SYNTHETIC_SEPARATOR);
    }

    public static String persistedId(String serverId, String typeToken) {
        String string = String.valueOf(TOKEN_SEPARATOR);
        return new StringBuilder(0 + String.valueOf(serverId).length() + String.valueOf(string).length() + String.valueOf(typeToken).length()).append(serverId).append(string).append(typeToken).toString();
    }

    public static String syntheticId(int syntheticId, String historyToken) {
        String string = String.valueOf(SYNTHETIC_SEPARATOR);
        return new StringBuilder(11 + String.valueOf(string).length() + String.valueOf(historyToken).length()).append(syntheticId).append(string).append(historyToken).toString();
    }

    private static String[] asAny(String encodedId) {
        return encodedId.split(ANY_SEPARATOR_PATTERN);
    }

    private static String[] asEphemeral(String encodedId) {
        return encodedId.split(EPHEMERAL_SEPARATOR);
    }

    private static String[] asPersisted(String encodedId) {
        return encodedId.split(TOKEN_SEPARATOR);
    }

    private static String[] asSynthetic(String encodedId) {
        return encodedId.split(SYNTHETIC_SEPARATOR);
    }

    private IdUtil() {
    }
}

