/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.HTMLTable;

public class Grid
extends HTMLTable {
    protected int numColumns;
    protected int numRows;

    private static native void addRows(com.google.gwt.dom.client.Element var0, int var1, int var2);

    public Grid() {
        this.setCellFormatter(new HTMLTable.CellFormatter(this));
        this.setRowFormatter(new HTMLTable.RowFormatter(this));
        this.setColumnFormatter(new HTMLTable.ColumnFormatter(this));
    }

    public Grid(int rows, int columns) {
        this();
        this.resize(rows, columns);
    }

    @Override
    public boolean clearCell(int row, int column) {
        Element td = this.getCellFormatter().getElement(row, column);
        boolean b = this.internalClearCell((com.google.gwt.dom.client.Element)td, false);
        td.setInnerHTML("&nbsp;");
        return b;
    }

    @Override
    public int getCellCount(int row) {
        return this.numColumns;
    }

    public int getColumnCount() {
        return this.numColumns;
    }

    @Override
    public int getRowCount() {
        return this.numRows;
    }

    @Override
    public int insertRow(int beforeRow) {
        int index = super.insertRow(beforeRow);
        ++this.numRows;
        for (int i = 0; i < this.numColumns; ++i) {
            this.insertCell(index, i);
        }
        return index;
    }

    @Override
    public void removeRow(int row) {
        super.removeRow(row);
        --this.numRows;
    }

    public void resize(int rows, int columns) {
        this.resizeColumns(columns);
        this.resizeRows(rows);
    }

    public void resizeColumns(int columns) {
        if (this.numColumns == columns) {
            return;
        }
        if (columns < 0) {
            throw new IndexOutOfBoundsException(new StringBuilder(43).append("Cannot set number of columns to ").append(columns).toString());
        }
        if (this.numColumns > columns) {
            for (int i = 0; i < this.numRows; ++i) {
                for (int j = this.numColumns - 1; j >= columns; --j) {
                    this.removeCell(i, j);
                }
            }
        } else {
            for (int i = 0; i < this.numRows; ++i) {
                for (int j = this.numColumns; j < columns; ++j) {
                    this.insertCell(i, j);
                }
            }
        }
        this.numColumns = columns;
        this.getColumnFormatter().resizeColumnGroup(columns, false);
    }

    public void resizeRows(int rows) {
        if (this.numRows == rows) {
            return;
        }
        if (rows < 0) {
            throw new IndexOutOfBoundsException(new StringBuilder(40).append("Cannot set number of rows to ").append(rows).toString());
        }
        if (this.numRows < rows) {
            Grid.addRows(this.getBodyElement(), rows - this.numRows, this.numColumns);
            this.numRows = rows;
        } else {
            while (this.numRows > rows) {
                this.removeRow(this.numRows - 1);
            }
        }
    }

    @Override
    protected Element createCell() {
        Element td = super.createCell();
        td.setInnerHTML("&nbsp;");
        return DOM.asOld(td);
    }

    @Override
    protected void prepareCell(int row, int column) {
        this.prepareRow(row);
        if (column < 0) {
            throw new IndexOutOfBoundsException(new StringBuilder(57).append("Cannot access a column with a negative index: ").append(column).toString());
        }
        if (column >= this.numColumns) {
            int n = this.numColumns;
            throw new IndexOutOfBoundsException(new StringBuilder(51).append("Column index: ").append(column).append(", Column size: ").append(n).toString());
        }
    }

    @Override
    protected void prepareColumn(int column) {
        super.prepareColumn(column);
        if (column >= this.numColumns) {
            int n = this.numColumns;
            throw new IndexOutOfBoundsException(new StringBuilder(51).append("Column index: ").append(column).append(", Column size: ").append(n).toString());
        }
    }

    @Override
    protected void prepareRow(int row) {
        if (row < 0) {
            throw new IndexOutOfBoundsException(new StringBuilder(54).append("Cannot access a row with a negative index: ").append(row).toString());
        }
        if (row >= this.numRows) {
            int n = this.numRows;
            throw new IndexOutOfBoundsException(new StringBuilder(45).append("Row index: ").append(row).append(", Row size: ").append(n).toString());
        }
    }
}

