/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.rpc;

import com.google.gwt.user.client.rpc.InvocationException;

public class StatusCodeException
extends InvocationException {
    private final int statusCode;
    private final String statusText;
    private final String encodedResponse;

    public StatusCodeException(int statusCode, String encodedResponse) {
        super(new StringBuilder(12 + String.valueOf(encodedResponse).length()).append(statusCode).append(" ").append(encodedResponse).toString());
        this.statusCode = statusCode;
        this.statusText = null;
        this.encodedResponse = encodedResponse;
    }

    public StatusCodeException(int statusCode, String statusText, String encodedResponse) {
        super(new StringBuilder(13 + String.valueOf(statusText).length() + String.valueOf(encodedResponse).length()).append(statusCode).append(" ").append(statusText).append(" ").append(encodedResponse).toString());
        this.statusCode = statusCode;
        this.statusText = statusText;
        this.encodedResponse = encodedResponse;
    }

    public String getEncodedResponse() {
        return this.encodedResponse;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getStatusText() {
        return this.statusText;
    }
}

