/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.resources.converter;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.resources.converter.Css2GssConversionException;
import com.google.gwt.resources.css.ast.Context;
import com.google.gwt.resources.css.ast.CssProperty;
import com.google.gwt.resources.css.ast.CssRule;
import com.google.gwt.resources.css.ast.CssVisitor;
import com.google.gwt.thirdparty.guava.common.base.Preconditions;
import com.google.gwt.thirdparty.guava.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UndefinedConstantVisitor
extends CssVisitor {
    private final Set<String> gssContantNames;
    private final Pattern pattern = Pattern.compile("^[A-Z_][A-Z_0-9]+$");
    private final Set<String> propertyNamesToSkip = Sets.newHashSet("filter", "-ms-filter", "font-family");
    private final boolean lenient;
    private final TreeLogger treeLogger;

    public UndefinedConstantVisitor(Set<String> gssContantNames, boolean lenient, TreeLogger treeLogger) {
        this.gssContantNames = gssContantNames;
        this.lenient = lenient;
        this.treeLogger = treeLogger;
    }

    @Override
    public boolean visit(CssRule x, Context ctx) {
        List<CssProperty> properties = x.getProperties();
        for (CssProperty cssProperty : properties) {
            String cssPropertyName = cssProperty.getName();
            if (this.propertyNamesToSkip.contains(cssPropertyName)) continue;
            String selector = x.getSelectors().toString();
            CssProperty.ListValue listValue = this.visitListValue(cssProperty.getValues(), cssPropertyName, selector);
            cssProperty.setValue(listValue);
        }
        return false;
    }

    private CssProperty.ListValue visitListValue(CssProperty.ListValue values, String cssPropertyName, String selector) {
        Preconditions.checkNotNull(values, "values cannot be null");
        List<CssProperty.Value> cssPropertyValues = values.getValues();
        ArrayList<CssProperty.Value> newValues = new ArrayList<CssProperty.Value>(cssPropertyValues.size());
        for (CssProperty.Value value : cssPropertyValues) {
            if (value.isListValue() != null) {
                newValues.add(this.visitListValue(value.isListValue(), cssPropertyName, selector));
                continue;
            }
            if (value.isFunctionValue() != null) {
                CssProperty.FunctionValue functionValue = value.isFunctionValue();
                CssProperty.ListValue listValue = this.visitListValue(functionValue.getValues(), cssPropertyName, selector);
                newValues.add(new CssProperty.FunctionValue(functionValue.getName(), listValue));
                continue;
            }
            if (value.isIdentValue() != null) {
                newValues.add(this.visitIdentValue(value.isIdentValue(), cssPropertyName, selector));
                continue;
            }
            newValues.add(value);
        }
        return new CssProperty.ListValue(newValues);
    }

    private CssProperty.Value visitIdentValue(CssProperty.IdentValue identValue, String cssPropertyName, String selector) {
        String upperCaseString;
        Matcher matcher = this.pattern.matcher(identValue.getIdent());
        if (matcher.matches() && !this.gssContantNames.contains(upperCaseString = matcher.group())) {
            this.treeLogger.log(TreeLogger.Type.WARN, new StringBuilder(53 + String.valueOf(cssPropertyName).length() + String.valueOf(selector).length() + String.valueOf(upperCaseString).length()).append("Property '").append(cssPropertyName).append("' from rule '").append(selector).append("' uses an undefined constant: ").append(upperCaseString).toString());
            if (this.lenient) {
                this.treeLogger.log(TreeLogger.Type.WARN, new StringBuilder(87 + String.valueOf(upperCaseString).length()).append("turning '").append(upperCaseString).append("' to lower case. This is probably not what you wanted here in the ").append("first place!").toString());
                return new CssProperty.IdentValue(upperCaseString.toLowerCase(Locale.US));
            }
            throw new Css2GssConversionException(new StringBuilder(70 + String.valueOf(cssPropertyName).length() + String.valueOf(selector).length() + String.valueOf(upperCaseString).length()).append("Found undefined constant in input. ").append(cssPropertyName).append("' from rule '").append(selector).append("' undefined constant: ").append(upperCaseString).toString());
        }
        return identValue;
    }
}

