/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.i18n.client;

import com.google.gwt.core.client.JsArrayInteger;
import com.google.gwt.core.client.JsArrayString;
import com.google.gwt.i18n.client.TimeZoneInfo;
import java.util.Date;

public class TimeZone
implements com.google.gwt.i18n.shared.TimeZone {
    private static final int STD_SHORT_NAME = 0;
    private static final int STD_LONG_NAME = 1;
    private static final int DLT_SHORT_NAME = 2;
    private static final int DLT_LONG_NAME = 3;
    private String timezoneID;
    private int standardOffset;
    private String[] tzNames;
    private int[] transitionPoints;
    private int[] adjustments;

    public static TimeZone createTimeZone(int timeZoneOffsetInMinutes) {
        TimeZone tz = new TimeZone();
        tz.standardOffset = timeZoneOffsetInMinutes;
        tz.timezoneID = TimeZone.composePOSIXTimeZoneID(timeZoneOffsetInMinutes);
        tz.tzNames = new String[2];
        tz.tzNames[0] = TimeZone.composeUTCString(timeZoneOffsetInMinutes);
        tz.tzNames[1] = TimeZone.composeUTCString(timeZoneOffsetInMinutes);
        tz.transitionPoints = null;
        tz.adjustments = null;
        return tz;
    }

    public static TimeZone createTimeZone(String tzJSON) {
        TimeZoneInfo tzData = TimeZoneInfo.buildTimeZoneData(tzJSON);
        return TimeZone.createTimeZone(tzData);
    }

    public static TimeZone createTimeZone(TimeZoneInfo timezoneData) {
        TimeZone tz = new TimeZone();
        tz.timezoneID = timezoneData.getID();
        tz.standardOffset = -timezoneData.getStandardOffset();
        JsArrayString jsTimezoneNames = timezoneData.getNames();
        tz.tzNames = new String[jsTimezoneNames.length()];
        for (int i = 0; i < jsTimezoneNames.length(); ++i) {
            tz.tzNames[i] = jsTimezoneNames.get(i);
        }
        JsArrayInteger transitions = timezoneData.getTransitions();
        if (transitions == null || transitions.length() == 0) {
            tz.transitionPoints = null;
            tz.adjustments = null;
        } else {
            int transitionNum = transitions.length() / 2;
            tz.transitionPoints = new int[transitionNum];
            tz.adjustments = new int[transitionNum];
            for (int i = 0; i < transitionNum; ++i) {
                tz.transitionPoints[i] = transitions.get(i * 2);
                tz.adjustments[i] = transitions.get(i * 2 + 1);
            }
        }
        return tz;
    }

    private static String composeGMTString(int offset) {
        char[] data = new char[]{'G', 'M', 'T', '-', '0', '0', ':', '0', '0'};
        if (offset <= 0) {
            data[3] = 43;
            offset = -offset;
        }
        data[4] = (char)(data[4] + offset / 60 / 10);
        data[5] = (char)(data[5] + offset / 60 % 10);
        data[7] = (char)(data[7] + offset % 60 / 10);
        data[8] = (char)(data[8] + offset % 10);
        return new String(data);
    }

    private static String composePOSIXTimeZoneID(int offset) {
        String str;
        if (offset == 0) {
            return "Etc/GMT";
        }
        if (offset < 0) {
            offset = -offset;
            str = "Etc/GMT-";
        } else {
            str = "Etc/GMT+";
        }
        String string = String.valueOf(str);
        String string2 = String.valueOf(TimeZone.offsetDisplay(offset));
        return string2.length() != 0 ? string.concat(string2) : new String(string);
    }

    private static String composeUTCString(int offset) {
        String str;
        if (offset == 0) {
            return "UTC";
        }
        if (offset < 0) {
            offset = -offset;
            str = "UTC+";
        } else {
            str = "UTC-";
        }
        String string = String.valueOf(str);
        String string2 = String.valueOf(TimeZone.offsetDisplay(offset));
        return string2.length() != 0 ? string.concat(string2) : new String(string);
    }

    private static String offsetDisplay(int offset) {
        int hour = offset / 60;
        int mins = offset % 60;
        if (mins == 0) {
            return Integer.toString(hour);
        }
        String string = String.valueOf(Integer.toString(hour));
        String string2 = String.valueOf(Integer.toString(mins));
        return new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(":").append(string2).toString();
    }

    private TimeZone() {
    }

    @Override
    public int getDaylightAdjustment(Date date) {
        int index;
        if (this.transitionPoints == null) {
            return 0;
        }
        long timeInHours = date.getTime() / 1000L / 3600L;
        for (index = 0; index < this.transitionPoints.length && timeInHours >= (long)this.transitionPoints[index]; ++index) {
        }
        return index == 0 ? 0 : this.adjustments[index - 1];
    }

    @Override
    public String getGMTString(Date date) {
        return TimeZone.composeGMTString(this.getOffset(date));
    }

    @Override
    public String getID() {
        return this.timezoneID;
    }

    @Override
    public String getISOTimeZoneString(Date date) {
        int offset = -this.getOffset(date);
        char[] data = new char[]{'+', '0', '0', ':', '0', '0'};
        if (offset < 0) {
            data[0] = 45;
            offset = -offset;
        }
        data[1] = (char)(data[1] + offset / 60 / 10);
        data[2] = (char)(data[2] + offset / 60 % 10);
        data[4] = (char)(data[4] + offset % 60 / 10);
        data[5] = (char)(data[5] + offset % 10);
        return new String(data);
    }

    @Override
    public String getLongName(Date date) {
        return this.tzNames[this.isDaylightTime(date) ? 3 : 1];
    }

    @Override
    public int getOffset(Date date) {
        return this.standardOffset - this.getDaylightAdjustment(date);
    }

    @Override
    public String getRFCTimeZoneString(Date date) {
        int offset = -this.getOffset(date);
        char[] data = new char[]{'+', '0', '0', '0', '0'};
        if (offset < 0) {
            data[0] = 45;
            offset = -offset;
        }
        data[1] = (char)(data[1] + offset / 60 / 10);
        data[2] = (char)(data[2] + offset / 60 % 10);
        data[3] = (char)(data[3] + offset % 60 / 10);
        data[4] = (char)(data[4] + offset % 10);
        return new String(data);
    }

    @Override
    public String getShortName(Date date) {
        return this.tzNames[this.isDaylightTime(date) ? 2 : 0];
    }

    @Override
    public int getStandardOffset() {
        return this.standardOffset;
    }

    @Override
    public boolean isDaylightTime(Date date) {
        return this.getDaylightAdjustment(date) > 0;
    }
}

