/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.aria.client;

import com.google.gwt.dom.client.Element;

public abstract class Attribute<T> {
    protected final String name;
    protected String defaultValue;

    public Attribute(String name, String defaultValue) {
        assert (name != null) : "Name cannot be null";
        this.name = name;
        this.defaultValue = defaultValue;
    }

    public Attribute(String name) {
        this(name, null);
    }

    public String get(Element element) {
        assert (element != null) : "Element cannot be null.";
        return element.getAttribute(this.name);
    }

    public String getName() {
        return this.name;
    }

    public void remove(Element element) {
        assert (element != null) : "Element cannot be null.";
        element.removeAttribute(this.name);
    }

    public void set(Element element, T ... values) {
        assert (element != null) : "Element cannot be null.";
        assert (values.length > 0);
        element.setAttribute(this.name, this.getAriaValue(values));
    }

    public void setDefault(Element element) {
        assert (element != null) : "Element cannot be null.";
        assert (this.defaultValue != null && !this.defaultValue.isEmpty()) : "Default value cannot be null.";
        element.setAttribute(this.name, this.defaultValue);
    }

    protected abstract String getSingleValue(T var1);

    private String getAriaValue(T ... value) {
        StringBuilder buf = new StringBuilder();
        for (T item : value) {
            buf.append(this.getSingleValue(item)).append(" ");
        }
        return buf.toString().trim();
    }
}

