/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA:
//  cldrVersion=21.0
//  number=$Revision: 6546 $
//  type=root
//  date=$Date: 2012-02-07 13:32:35 -0500 (Tue, 07 Feb 2012) $


/**
 * Localized names for the "zu" locale.
 */
public class LocalizedNamesImpl_zu extends LocalizedNamesImpl {

  @Override
  public String[] loadLikelyRegionCodes() {
    return new String[] {
        "ZA",
    };
  }

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "BQ",
        "CW",
        "CG",
        "CD",
        "DG",
        "TF",
        "HK",
        "MM",
        "UM",
        "AF",
        "AX",
        "AL",
        "DZ",
        "AS",
        "AD",
        "AO",
        "AI",
        "AQ",
        "AG",
        "AR",
        "AM",
        "AW",
        "AC",
        "AU",
        "AT",
        "AZ",
        "BS",
        "BH",
        "BD",
        "BB",
        "BY",
        "BE",
        "BZ",
        "BJ",
        "BM",
        "BT",
        "BO",
        "BA",
        "BW",
        "BV",
        "BR",
        "IO",
        "VG",
        "BN",
        "BG",
        "BF",
        "BI",
        "KH",
        "CM",
        "CA",
        "IC",
        "CV",
        "KY",
        "CF",
        "TD",
        "CL",
        "CN",
        "CX",
        "CP",
        "CC",
        "CO",
        "KM",
        "CK",
        "CR",
        "CI",
        "HR",
        "CU",
        "EA",
        "CY",
        "CZ",
        "DK",
        "DJ",
        "DM",
        "DO",
        "EC",
        "EG",
        "SV",
        "GQ",
        "ER",
        "EE",
        "ET",
        "EU",
        "FK",
        "FO",
        "FJ",
        "FI",
        "FR",
        "PF",
        "GA",
        "GM",
        "GE",
        "DE",
        "GH",
        "GI",
        "GR",
        "GL",
        "GD",
        "GP",
        "GU",
        "GT",
        "GG",
        "GN",
        "GW",
        "GY",
        "HT",
        "HM",
        "HN",
        "HU",
        "IS",
        "IN",
        "ID",
        "IR",
        "IQ",
        "IE",
        "IM",
        "IL",
        "IT",
        "JM",
        "JP",
        "JO",
        "KZ",
        "KE",
        "KI",
        "KW",
        "KG",
        "LA",
        "LV",
        "LB",
        "LS",
        "LR",
        "LY",
        "LI",
        "LT",
        "LU",
        "MO",
        "MK",
        "MG",
        "MW",
        "MY",
        "MV",
        "ML",
        "MT",
        "MH",
        "MQ",
        "MR",
        "MU",
        "YT",
        "MX",
        "FM",
        "MD",
        "MC",
        "MN",
        "ME",
        "MS",
        "MA",
        "MZ",
        "NA",
        "NR",
        "NP",
        "NL",
        "AN",
        "NC",
        "NZ",
        "NI",
        "NE",
        "NG",
        "ZA",
        "NU",
        "NF",
        "MP",
        "KP",
        "NO",
        "OM",
        "QO",
        "PK",
        "PW",
        "PS",
        "PA",
        "PG",
        "PY",
        "PE",
        "PH",
        "PN",
        "PL",
        "PT",
        "PR",
        "QA",
        "RE",
        "RO",
        "RU",
        "RW",
        "BL",
        "SH",
        "KN",
        "LC",
        "MF",
        "PM",
        "VC",
        "WS",
        "SM",
        "ST",
        "SA",
        "SN",
        "RS",
        "SC",
        "SL",
        "GF",
        "JE",
        "SG",
        "SK",
        "SI",
        "SB",
        "SO",
        "GS",
        "KR",
        "ES",
        "LK",
        "SD",
        "SR",
        "SJ",
        "SZ",
        "SE",
        "CH",
        "SY",
        "TW",
        "TJ",
        "TZ",
        "TH",
        "TL",
        "TG",
        "TK",
        "TO",
        "TT",
        "TA",
        "TN",
        "TR",
        "TM",
        "TC",
        "TV",
        "VI",
        "UG",
        "UA",
        "AE",
        "GB",
        "US",
        "UY",
        "UZ",
        "VU",
        "VA",
        "VE",
        "VN",
        "WF",
        "EH",
        "YE",
        "ZM",
        "ZW",
        "SS",
        "SX",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("001", "Umhlaba");
    namesMap.put("002", "i-Africa");
    namesMap.put("003", "e-North America");
    namesMap.put("005", "i-South America");
    namesMap.put("009", "i-Oceania");
    namesMap.put("011", "e-Western Africa");
    namesMap.put("013", "i-Central America");
    namesMap.put("014", "e-Eastern Africa");
    namesMap.put("015", "e-Northern Africa");
    namesMap.put("017", "e-Middle Africa");
    namesMap.put("018", "e-Southern Africa");
    namesMap.put("021", "e-Northern America");
    namesMap.put("029", "i-Caribbean");
    namesMap.put("030", "e-Eastern Asia");
    namesMap.put("034", "e-Southern Asia");
    namesMap.put("035", "e-South-Eastern Asia");
    namesMap.put("039", "e-Southern Europe");
    namesMap.put("053", "i-Australia ne-New Zealand");
    namesMap.put("054", "i-Melanesia");
    namesMap.put("057", "e-Micronesian Region");
    namesMap.put("061", "i-Polynesia");
    namesMap.put("142", "i-Asia");
    namesMap.put("143", "i-Central Asia");
    namesMap.put("145", "e-Western Asia");
    namesMap.put("150", "i-Europe");
    namesMap.put("151", "e-Eastern Europe");
    namesMap.put("154", "e-Northern Europe");
    namesMap.put("155", "e-Western Europe");
    namesMap.put("419", "i-Latin America");
    namesMap.put("AC", "i-Ascension Island");
    namesMap.put("AD", "i-Andorra");
    namesMap.put("AE", "i-United Arab Emirates");
    namesMap.put("AF", "i-Afghanistan");
    namesMap.put("AG", "i-Antigua and Barbuda");
    namesMap.put("AI", "i-Anguilla");
    namesMap.put("AL", "i-Albania");
    namesMap.put("AM", "i-Armenia");
    namesMap.put("AN", "i-Netherlands Antilles");
    namesMap.put("AO", "i-Angola");
    namesMap.put("AQ", "i-Antarctica");
    namesMap.put("AR", "i-Argentina");
    namesMap.put("AS", "i-American Samoa");
    namesMap.put("AT", "i-Austria");
    namesMap.put("AU", "i-Australia");
    namesMap.put("AW", "i-Aruba");
    namesMap.put("AX", "i-Åland Islands");
    namesMap.put("AZ", "i-Azerbaijan");
    namesMap.put("BA", "i-Bosnia ne-Herzegovina");
    namesMap.put("BB", "i-Barbados");
    namesMap.put("BD", "i-Bangladesh");
    namesMap.put("BE", "i-Belgium");
    namesMap.put("BF", "i-Burkina Faso");
    namesMap.put("BG", "i-Bulgaria");
    namesMap.put("BH", "i-Bahrain");
    namesMap.put("BI", "i-Burundi");
    namesMap.put("BJ", "i-Benin");
    namesMap.put("BL", "i-Saint Barthélemy");
    namesMap.put("BM", "i-Bermuda");
    namesMap.put("BN", "i-Brunei");
    namesMap.put("BO", "i-Bolivia");
    namesMap.put("BR", "i-Brazil");
    namesMap.put("BS", "i-Bahamas");
    namesMap.put("BT", "i-Bhutan");
    namesMap.put("BV", "i-Bouvet Island");
    namesMap.put("BW", "i-Botswana");
    namesMap.put("BY", "i-Belarus");
    namesMap.put("BZ", "i-Belize");
    namesMap.put("CA", "i-Canada");
    namesMap.put("CC", "i-Cocos (Keeling) Islands");
    namesMap.put("CD", "e-Congo - Kinshasa");
    namesMap.put("CF", "i-Central African Republic");
    namesMap.put("CG", "e-Congo - Brazzaville");
    namesMap.put("CH", "i-Switzerland");
    namesMap.put("CI", "i-Côte d’Ivoire");
    namesMap.put("CK", "i-Cook Islands");
    namesMap.put("CL", "i-Chile");
    namesMap.put("CM", "i-Cameroon");
    namesMap.put("CN", "i-China");
    namesMap.put("CO", "i-Colombia");
    namesMap.put("CP", "i-Clipperton Island");
    namesMap.put("CR", "i-Costa Rica");
    namesMap.put("CU", "i-Cuba");
    namesMap.put("CV", "i-Cape Verde");
    namesMap.put("CX", "i-Christmas Island");
    namesMap.put("CY", "i-Cyprus");
    namesMap.put("CZ", "i-Czech Republic");
    namesMap.put("DE", "i-Germany");
    namesMap.put("DG", "e-Diego Garcia");
    namesMap.put("DJ", "i-Djibouti");
    namesMap.put("DK", "i-Denmark");
    namesMap.put("DM", "i-Dominica");
    namesMap.put("DO", "i-Dominican Republic");
    namesMap.put("DZ", "i-Algeria");
    namesMap.put("EA", "i-Cueta ne-Melilla");
    namesMap.put("EC", "i-Ecuador");
    namesMap.put("EE", "i-Estonia");
    namesMap.put("EG", "i-Egypt");
    namesMap.put("EH", "i-Western Sahara");
    namesMap.put("ER", "i-Eritrea");
    namesMap.put("ES", "i-Spain");
    namesMap.put("ET", "i-Ethiopia");
    namesMap.put("EU", "i-European Union");
    namesMap.put("FI", "i-Finland");
    namesMap.put("FJ", "i-Fiji");
    namesMap.put("FK", "i-Falkland Islands");
    namesMap.put("FM", "i-Micronesia");
    namesMap.put("FO", "i-Faroe Islands");
    namesMap.put("FR", "i-France");
    namesMap.put("GA", "i-Gabon");
    namesMap.put("GB", "i-United Kingdom");
    namesMap.put("GD", "i-Grenada");
    namesMap.put("GE", "i-Georgia");
    namesMap.put("GF", "isi-French Guiana");
    namesMap.put("GG", "I-Guernsey");
    namesMap.put("GH", "i-Ghana");
    namesMap.put("GI", "i-Gibraltar");
    namesMap.put("GL", "i-Greenland");
    namesMap.put("GM", "i-Gambia");
    namesMap.put("GN", "i-Guinea");
    namesMap.put("GP", "i-Guadeloupe");
    namesMap.put("GQ", "i-Equatorial Guinea");
    namesMap.put("GR", "i-Greece");
    namesMap.put("GS", "i-South Georgia ne-South Sandwich Islands");
    namesMap.put("GT", "i-Guatemala");
    namesMap.put("GU", "i-Guam");
    namesMap.put("GW", "i-Guinea-Bissau");
    namesMap.put("GY", "i-Guyana");
    namesMap.put("HK", "e-Hong Kong SAR China");
    namesMap.put("HM", "i-Heard Island ne-McDonald Islands");
    namesMap.put("HN", "i-Honduras");
    namesMap.put("HR", "i-Croatia");
    namesMap.put("HT", "i-Haiti");
    namesMap.put("HU", "i-Hungary");
    namesMap.put("IC", "i-Canary Islands");
    namesMap.put("ID", "i-Indonesia");
    namesMap.put("IE", "i-Ireland");
    namesMap.put("IL", "i-Israel");
    namesMap.put("IM", "i-Isle of Man");
    namesMap.put("IN", "i-India");
    namesMap.put("IO", "i-British Indian Ocean Territory");
    namesMap.put("IQ", "i-Iraq");
    namesMap.put("IR", "i-Iran");
    namesMap.put("IS", "i-Iceland");
    namesMap.put("IT", "i-Italy");
    namesMap.put("JE", "isi-Jersey");
    namesMap.put("JM", "i-Jamaica");
    namesMap.put("JO", "i-Jordan");
    namesMap.put("JP", "i-Japan");
    namesMap.put("KE", "i-Kenya");
    namesMap.put("KG", "i-Kyrgyzstan");
    namesMap.put("KH", "i-Cambodia");
    namesMap.put("KI", "i-Kiribati");
    namesMap.put("KM", "i-Comoros");
    namesMap.put("KN", "i-Saint Kitts ne-Nevis");
    namesMap.put("KP", "i-North Korea");
    namesMap.put("KR", "i-South Korea");
    namesMap.put("KW", "i-Kuwait");
    namesMap.put("KY", "i-Cayman Islands");
    namesMap.put("KZ", "i-Kazakhstan");
    namesMap.put("LA", "i-Laos");
    namesMap.put("LB", "i-Lebanon");
    namesMap.put("LC", "i-Saint Lucia");
    namesMap.put("LI", "i-Liechtenstein");
    namesMap.put("LK", "i-Sri Lanka");
    namesMap.put("LR", "i-Liberia");
    namesMap.put("LS", "i-Lesotho");
    namesMap.put("LT", "i-Lithuania");
    namesMap.put("LU", "i-Luxembourg");
    namesMap.put("LV", "i-Latvia");
    namesMap.put("LY", "i-Libya");
    namesMap.put("MA", "i-Morocco");
    namesMap.put("MC", "i-Monaco");
    namesMap.put("MD", "i-Moldova");
    namesMap.put("ME", "i-Montenegro");
    namesMap.put("MF", "i-Saint Martin");
    namesMap.put("MG", "i-Madagascar");
    namesMap.put("MH", "i-Marshall Islands");
    namesMap.put("MK", "I-Macedonia");
    namesMap.put("ML", "i-Mali");
    namesMap.put("MM", "e-Myanmar [Burma]");
    namesMap.put("MN", "i-Mongolia");
    namesMap.put("MO", "i-Macau SAR China");
    namesMap.put("MP", "i-Northern Mariana Islands");
    namesMap.put("MQ", "i-Martinique");
    namesMap.put("MR", "i-Mauritania");
    namesMap.put("MS", "i-Montserrat");
    namesMap.put("MT", "i-Malta");
    namesMap.put("MU", "i-Mauritius");
    namesMap.put("MV", "i-Maldives");
    namesMap.put("MW", "i-Malawi");
    namesMap.put("MX", "i-Mexico");
    namesMap.put("MY", "i-Malaysia");
    namesMap.put("MZ", "i-Mozambique");
    namesMap.put("NA", "i-Namibia");
    namesMap.put("NC", "i-New Caledonia");
    namesMap.put("NE", "i-Niger");
    namesMap.put("NF", "i-Norfolk Island");
    namesMap.put("NG", "i-Nigeria");
    namesMap.put("NI", "i-Nicaragua");
    namesMap.put("NL", "i-Netherlands");
    namesMap.put("NO", "i-Norway");
    namesMap.put("NP", "i-Nepal");
    namesMap.put("NR", "i-Nauru");
    namesMap.put("NU", "i-Niue");
    namesMap.put("NZ", "i-New Zealand");
    namesMap.put("OM", "i-Oman");
    namesMap.put("PA", "i-Panama");
    namesMap.put("PE", "i-Peru");
    namesMap.put("PF", "i-French Polynesia");
    namesMap.put("PG", "i-Papua New Guinea");
    namesMap.put("PH", "i-Philippines");
    namesMap.put("PK", "i-Pakistan");
    namesMap.put("PL", "i-Poland");
    namesMap.put("PM", "i-Saint Pierre kanye ne-Miquelon");
    namesMap.put("PN", "i-Pitcairn Islands");
    namesMap.put("PR", "i-Puerto Rico");
    namesMap.put("PS", "i-Palestinian Territories");
    namesMap.put("PT", "i-Portugal");
    namesMap.put("PW", "i-Palau");
    namesMap.put("PY", "i-Paraguay");
    namesMap.put("QA", "i-Qatar");
    namesMap.put("QO", "i-Outlying Oceania");
    namesMap.put("RE", "i-Réunion");
    namesMap.put("RO", "i-Romania");
    namesMap.put("RS", "i-Serbia");
    namesMap.put("RU", "i-Russia");
    namesMap.put("RW", "i-Rwanda");
    namesMap.put("SA", "i-Saudi Arabia");
    namesMap.put("SB", "i-Solomon Islands");
    namesMap.put("SC", "i-Seychelles");
    namesMap.put("SD", "i-Sudan");
    namesMap.put("SE", "i-Sweden");
    namesMap.put("SG", "i-Singapore");
    namesMap.put("SH", "i-Saint Helena");
    namesMap.put("SI", "i-Slovenia");
    namesMap.put("SJ", "I-Svalbard ne-Jan Mayen");
    namesMap.put("SK", "i-Slovakia");
    namesMap.put("SL", "i-Sierra Leone");
    namesMap.put("SM", "i-San Marino");
    namesMap.put("SN", "i-Senegal");
    namesMap.put("SO", "i-Somalia");
    namesMap.put("SR", "i-Suriname");
    namesMap.put("ST", "i-São Tomé kanye ne-Príncipe");
    namesMap.put("SV", "i-El Salvador");
    namesMap.put("SY", "i-Syria");
    namesMap.put("SZ", "i-Swaziland");
    namesMap.put("TA", "i-Tristan da Cunha");
    namesMap.put("TC", "i-Turks and Caicos Islands");
    namesMap.put("TD", "i-Chad");
    namesMap.put("TF", "e-French Southern Territories");
    namesMap.put("TG", "i-Togo");
    namesMap.put("TH", "i-Thailand");
    namesMap.put("TJ", "i-Tajikistan");
    namesMap.put("TK", "i-Tokelau");
    namesMap.put("TL", "i-Timor-Leste");
    namesMap.put("TM", "i-Turkmenistan");
    namesMap.put("TN", "i-Tunisia");
    namesMap.put("TO", "i-Tonga");
    namesMap.put("TR", "i-Turkey");
    namesMap.put("TT", "i-Trinidad ne-Tobago");
    namesMap.put("TV", "i-Tuvalu");
    namesMap.put("TW", "i-Taiwan");
    namesMap.put("TZ", "i-Tanzania");
    namesMap.put("UA", "i-Ukraine");
    namesMap.put("UG", "i-Uganda");
    namesMap.put("UM", "e-U.S. Minor Outlying Islands");
    namesMap.put("US", "i-United States");
    namesMap.put("UY", "i-Uruguay");
    namesMap.put("UZ", "i-Uzbekistan");
    namesMap.put("VA", "i-Vatican City");
    namesMap.put("VC", "i-Saint Vincent ne-Grenadines");
    namesMap.put("VE", "i-Venezuela");
    namesMap.put("VG", "i-British Virgin Islands");
    namesMap.put("VI", "i-U.S. Virgin Islands");
    namesMap.put("VN", "i-Vietnam");
    namesMap.put("VU", "i-Vanuatu");
    namesMap.put("WF", "i-Wallis ne-Futuna");
    namesMap.put("WS", "i-Samoa");
    namesMap.put("YE", "i-Yemen");
    namesMap.put("YT", "i-Mayotte");
    namesMap.put("ZA", "iNingizimu Afrika");
    namesMap.put("ZM", "i-Zambia");
    namesMap.put("ZW", "i-Zimbabwe");
    namesMap.put("ZZ", "Isifunda esingaziwa");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "001": "Umhlaba",
        "002": "i-Africa",
        "003": "e-North America",
        "005": "i-South America",
        "009": "i-Oceania",
        "011": "e-Western Africa",
        "013": "i-Central America",
        "014": "e-Eastern Africa",
        "015": "e-Northern Africa",
        "017": "e-Middle Africa",
        "018": "e-Southern Africa",
        "021": "e-Northern America",
        "029": "i-Caribbean",
        "030": "e-Eastern Asia",
        "034": "e-Southern Asia",
        "035": "e-South-Eastern Asia",
        "039": "e-Southern Europe",
        "053": "i-Australia ne-New Zealand",
        "054": "i-Melanesia",
        "057": "e-Micronesian Region",
        "061": "i-Polynesia",
        "142": "i-Asia",
        "143": "i-Central Asia",
        "145": "e-Western Asia",
        "150": "i-Europe",
        "151": "e-Eastern Europe",
        "154": "e-Northern Europe",
        "155": "e-Western Europe",
        "419": "i-Latin America",
        "AC": "i-Ascension Island",
        "AD": "i-Andorra",
        "AE": "i-United Arab Emirates",
        "AF": "i-Afghanistan",
        "AG": "i-Antigua and Barbuda",
        "AI": "i-Anguilla",
        "AL": "i-Albania",
        "AM": "i-Armenia",
        "AN": "i-Netherlands Antilles",
        "AO": "i-Angola",
        "AQ": "i-Antarctica",
        "AR": "i-Argentina",
        "AS": "i-American Samoa",
        "AT": "i-Austria",
        "AU": "i-Australia",
        "AW": "i-Aruba",
        "AX": "i-Åland Islands",
        "AZ": "i-Azerbaijan",
        "BA": "i-Bosnia ne-Herzegovina",
        "BB": "i-Barbados",
        "BD": "i-Bangladesh",
        "BE": "i-Belgium",
        "BF": "i-Burkina Faso",
        "BG": "i-Bulgaria",
        "BH": "i-Bahrain",
        "BI": "i-Burundi",
        "BJ": "i-Benin",
        "BL": "i-Saint Barthélemy",
        "BM": "i-Bermuda",
        "BN": "i-Brunei",
        "BO": "i-Bolivia",
        "BR": "i-Brazil",
        "BS": "i-Bahamas",
        "BT": "i-Bhutan",
        "BV": "i-Bouvet Island",
        "BW": "i-Botswana",
        "BY": "i-Belarus",
        "BZ": "i-Belize",
        "CA": "i-Canada",
        "CC": "i-Cocos (Keeling) Islands",
        "CD": "e-Congo - Kinshasa",
        "CF": "i-Central African Republic",
        "CG": "e-Congo - Brazzaville",
        "CH": "i-Switzerland",
        "CI": "i-Côte d’Ivoire",
        "CK": "i-Cook Islands",
        "CL": "i-Chile",
        "CM": "i-Cameroon",
        "CN": "i-China",
        "CO": "i-Colombia",
        "CP": "i-Clipperton Island",
        "CR": "i-Costa Rica",
        "CU": "i-Cuba",
        "CV": "i-Cape Verde",
        "CX": "i-Christmas Island",
        "CY": "i-Cyprus",
        "CZ": "i-Czech Republic",
        "DE": "i-Germany",
        "DG": "e-Diego Garcia",
        "DJ": "i-Djibouti",
        "DK": "i-Denmark",
        "DM": "i-Dominica",
        "DO": "i-Dominican Republic",
        "DZ": "i-Algeria",
        "EA": "i-Cueta ne-Melilla",
        "EC": "i-Ecuador",
        "EE": "i-Estonia",
        "EG": "i-Egypt",
        "EH": "i-Western Sahara",
        "ER": "i-Eritrea",
        "ES": "i-Spain",
        "ET": "i-Ethiopia",
        "EU": "i-European Union",
        "FI": "i-Finland",
        "FJ": "i-Fiji",
        "FK": "i-Falkland Islands",
        "FM": "i-Micronesia",
        "FO": "i-Faroe Islands",
        "FR": "i-France",
        "GA": "i-Gabon",
        "GB": "i-United Kingdom",
        "GD": "i-Grenada",
        "GE": "i-Georgia",
        "GF": "isi-French Guiana",
        "GG": "I-Guernsey",
        "GH": "i-Ghana",
        "GI": "i-Gibraltar",
        "GL": "i-Greenland",
        "GM": "i-Gambia",
        "GN": "i-Guinea",
        "GP": "i-Guadeloupe",
        "GQ": "i-Equatorial Guinea",
        "GR": "i-Greece",
        "GS": "i-South Georgia ne-South Sandwich Islands",
        "GT": "i-Guatemala",
        "GU": "i-Guam",
        "GW": "i-Guinea-Bissau",
        "GY": "i-Guyana",
        "HK": "e-Hong Kong SAR China",
        "HM": "i-Heard Island ne-McDonald Islands",
        "HN": "i-Honduras",
        "HR": "i-Croatia",
        "HT": "i-Haiti",
        "HU": "i-Hungary",
        "IC": "i-Canary Islands",
        "ID": "i-Indonesia",
        "IE": "i-Ireland",
        "IL": "i-Israel",
        "IM": "i-Isle of Man",
        "IN": "i-India",
        "IO": "i-British Indian Ocean Territory",
        "IQ": "i-Iraq",
        "IR": "i-Iran",
        "IS": "i-Iceland",
        "IT": "i-Italy",
        "JE": "isi-Jersey",
        "JM": "i-Jamaica",
        "JO": "i-Jordan",
        "JP": "i-Japan",
        "KE": "i-Kenya",
        "KG": "i-Kyrgyzstan",
        "KH": "i-Cambodia",
        "KI": "i-Kiribati",
        "KM": "i-Comoros",
        "KN": "i-Saint Kitts ne-Nevis",
        "KP": "i-North Korea",
        "KR": "i-South Korea",
        "KW": "i-Kuwait",
        "KY": "i-Cayman Islands",
        "KZ": "i-Kazakhstan",
        "LA": "i-Laos",
        "LB": "i-Lebanon",
        "LC": "i-Saint Lucia",
        "LI": "i-Liechtenstein",
        "LK": "i-Sri Lanka",
        "LR": "i-Liberia",
        "LS": "i-Lesotho",
        "LT": "i-Lithuania",
        "LU": "i-Luxembourg",
        "LV": "i-Latvia",
        "LY": "i-Libya",
        "MA": "i-Morocco",
        "MC": "i-Monaco",
        "MD": "i-Moldova",
        "ME": "i-Montenegro",
        "MF": "i-Saint Martin",
        "MG": "i-Madagascar",
        "MH": "i-Marshall Islands",
        "MK": "I-Macedonia",
        "ML": "i-Mali",
        "MM": "e-Myanmar [Burma]",
        "MN": "i-Mongolia",
        "MO": "i-Macau SAR China",
        "MP": "i-Northern Mariana Islands",
        "MQ": "i-Martinique",
        "MR": "i-Mauritania",
        "MS": "i-Montserrat",
        "MT": "i-Malta",
        "MU": "i-Mauritius",
        "MV": "i-Maldives",
        "MW": "i-Malawi",
        "MX": "i-Mexico",
        "MY": "i-Malaysia",
        "MZ": "i-Mozambique",
        "NA": "i-Namibia",
        "NC": "i-New Caledonia",
        "NE": "i-Niger",
        "NF": "i-Norfolk Island",
        "NG": "i-Nigeria",
        "NI": "i-Nicaragua",
        "NL": "i-Netherlands",
        "NO": "i-Norway",
        "NP": "i-Nepal",
        "NR": "i-Nauru",
        "NU": "i-Niue",
        "NZ": "i-New Zealand",
        "OM": "i-Oman",
        "PA": "i-Panama",
        "PE": "i-Peru",
        "PF": "i-French Polynesia",
        "PG": "i-Papua New Guinea",
        "PH": "i-Philippines",
        "PK": "i-Pakistan",
        "PL": "i-Poland",
        "PM": "i-Saint Pierre kanye ne-Miquelon",
        "PN": "i-Pitcairn Islands",
        "PR": "i-Puerto Rico",
        "PS": "i-Palestinian Territories",
        "PT": "i-Portugal",
        "PW": "i-Palau",
        "PY": "i-Paraguay",
        "QA": "i-Qatar",
        "QO": "i-Outlying Oceania",
        "RE": "i-Réunion",
        "RO": "i-Romania",
        "RS": "i-Serbia",
        "RU": "i-Russia",
        "RW": "i-Rwanda",
        "SA": "i-Saudi Arabia",
        "SB": "i-Solomon Islands",
        "SC": "i-Seychelles",
        "SD": "i-Sudan",
        "SE": "i-Sweden",
        "SG": "i-Singapore",
        "SH": "i-Saint Helena",
        "SI": "i-Slovenia",
        "SJ": "I-Svalbard ne-Jan Mayen",
        "SK": "i-Slovakia",
        "SL": "i-Sierra Leone",
        "SM": "i-San Marino",
        "SN": "i-Senegal",
        "SO": "i-Somalia",
        "SR": "i-Suriname",
        "ST": "i-São Tomé kanye ne-Príncipe",
        "SV": "i-El Salvador",
        "SY": "i-Syria",
        "SZ": "i-Swaziland",
        "TA": "i-Tristan da Cunha",
        "TC": "i-Turks and Caicos Islands",
        "TD": "i-Chad",
        "TF": "e-French Southern Territories",
        "TG": "i-Togo",
        "TH": "i-Thailand",
        "TJ": "i-Tajikistan",
        "TK": "i-Tokelau",
        "TL": "i-Timor-Leste",
        "TM": "i-Turkmenistan",
        "TN": "i-Tunisia",
        "TO": "i-Tonga",
        "TR": "i-Turkey",
        "TT": "i-Trinidad ne-Tobago",
        "TV": "i-Tuvalu",
        "TW": "i-Taiwan",
        "TZ": "i-Tanzania",
        "UA": "i-Ukraine",
        "UG": "i-Uganda",
        "UM": "e-U.S. Minor Outlying Islands",
        "US": "i-United States",
        "UY": "i-Uruguay",
        "UZ": "i-Uzbekistan",
        "VA": "i-Vatican City",
        "VC": "i-Saint Vincent ne-Grenadines",
        "VE": "i-Venezuela",
        "VG": "i-British Virgin Islands",
        "VI": "i-U.S. Virgin Islands",
        "VN": "i-Vietnam",
        "VU": "i-Vanuatu",
        "WF": "i-Wallis ne-Futuna",
        "WS": "i-Samoa",
        "YE": "i-Yemen",
        "YT": "i-Mayotte",
        "ZA": "iNingizimu Afrika",
        "ZM": "i-Zambia",
        "ZW": "i-Zimbabwe",
        "ZZ": "Isifunda esingaziwa"
    };
  }-*/;
}
