/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.event.dom.client;

import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.event.dom.client.HasNativeEvent;
import com.google.gwt.event.dom.client.PrivateMap;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.HasHandlers;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DomEvent<H extends EventHandler>
extends GwtEvent<H>
implements HasNativeEvent {
    private static PrivateMap<Type<?>> registered;
    private NativeEvent nativeEvent;
    private Element relativeElem;

    public static void fireNativeEvent(NativeEvent nativeEvent, HasHandlers handlerSource) {
        DomEvent.fireNativeEvent(nativeEvent, handlerSource, null);
    }

    public static void fireNativeEvent(NativeEvent nativeEvent, HasHandlers handlerSource, Element relativeElem) {
        Type<?> typeKey;
        assert (nativeEvent != null) : "nativeEvent must not be null";
        if (registered != null && (typeKey = registered.unsafeGet(nativeEvent.getType())) != null) {
            NativeEvent currentNative = ((Type)typeKey).flyweight.nativeEvent;
            Element currentRelativeElem = ((Type)typeKey).flyweight.relativeElem;
            ((Type)typeKey).flyweight.setNativeEvent(nativeEvent);
            ((Type)typeKey).flyweight.setRelativeElement(relativeElem);
            handlerSource.fireEvent(((Type)typeKey).flyweight);
            ((Type)typeKey).flyweight.setNativeEvent(currentNative);
            ((Type)typeKey).flyweight.setRelativeElement(currentRelativeElem);
        }
    }

    static void init() {
        registered = new PrivateMap();
    }

    @Override
    public abstract Type<H> getAssociatedType();

    @Override
    public final NativeEvent getNativeEvent() {
        this.assertLive();
        return this.nativeEvent;
    }

    public final Element getRelativeElement() {
        this.assertLive();
        return this.relativeElem;
    }

    public void preventDefault() {
        this.assertLive();
        this.nativeEvent.preventDefault();
    }

    public final void setNativeEvent(NativeEvent nativeEvent) {
        this.nativeEvent = nativeEvent;
    }

    public void setRelativeElement(Element relativeElem) {
        this.relativeElem = relativeElem;
    }

    public void stopPropagation() {
        this.assertLive();
        this.nativeEvent.stopPropagation();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Type<H extends EventHandler>
    extends GwtEvent.Type<H> {
        private DomEvent<H> flyweight;
        private String name;

        public Type(String eventName, DomEvent<H> flyweight) {
            this.flyweight = flyweight;
            if (registered == null) {
                DomEvent.init();
            }
            registered.unsafePut(eventName, this);
            this.name = eventName;
        }

        public String getName() {
            return this.name;
        }
    }
}

