/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.EventTarget;
import com.google.gwt.event.dom.client.BlurEvent;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.KeyDownEvent;
import com.google.gwt.event.dom.client.MouseUpEvent;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.CheckBox;

public class RadioButton
extends CheckBox {
    private Boolean oldValue;

    public RadioButton(String name) {
        super(DOM.createInputRadio(name));
        this.setStyleName("gwt-RadioButton");
        this.sinkEvents(Event.getTypeInt(ClickEvent.getType().getName()));
        this.sinkEvents(Event.getTypeInt(MouseUpEvent.getType().getName()));
        this.sinkEvents(Event.getTypeInt(BlurEvent.getType().getName()));
        this.sinkEvents(Event.getTypeInt(KeyDownEvent.getType().getName()));
    }

    public RadioButton(String name, String label) {
        this(name);
        this.setText(label);
    }

    public RadioButton(String name, String label, boolean asHTML) {
        this(name);
        if (asHTML) {
            this.setHTML(label);
        } else {
            this.setText(label);
        }
    }

    public void onBrowserEvent(Event event) {
        switch (DOM.eventGetType(event)) {
            case 8: 
            case 128: 
            case 4096: {
                this.oldValue = this.getValue();
                break;
            }
            case 1: {
                EventTarget target = event.getEventTarget();
                if (Element.is(target) && this.labelElem.isOrHasChild(Element.as(target))) {
                    this.oldValue = this.getValue();
                    return;
                }
                super.onBrowserEvent(event);
                ValueChangeEvent.fireIfNotEqual(this, this.oldValue, this.getValue());
                return;
            }
        }
        super.onBrowserEvent(event);
    }

    public void setName(String name) {
        super.replaceInputElement(DOM.createInputRadio(name));
    }

    public void sinkEvents(int eventBitsToAdd) {
        if (this.isOrWasAttached()) {
            Event.sinkEvents(this.inputElem, eventBitsToAdd | Event.getEventsSunk(this.inputElem));
            Event.sinkEvents(this.labelElem, eventBitsToAdd | Event.getEventsSunk(this.labelElem));
        } else {
            super.sinkEvents(eventBitsToAdd);
        }
    }

    protected void ensureDomEventHandlers() {
    }
}

