/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.HTMLTable;

public class Grid
extends HTMLTable {
    protected int numColumns;
    protected int numRows;

    private static native void addRows(Element var0, int var1, int var2);

    public Grid() {
        this.setCellFormatter(new HTMLTable.CellFormatter(this));
        this.setRowFormatter(new HTMLTable.RowFormatter(this));
        this.setColumnFormatter(new HTMLTable.ColumnFormatter(this));
    }

    public Grid(int rows, int columns) {
        this();
        this.resize(rows, columns);
    }

    public boolean clearCell(int row, int column) {
        Element td = this.getCellFormatter().getElement(row, column);
        boolean b = super.internalClearCell(td, false);
        DOM.setInnerHTML(td, "&nbsp;");
        return b;
    }

    public int getCellCount(int row) {
        return this.numColumns;
    }

    public int getColumnCount() {
        return this.numColumns;
    }

    public int getRowCount() {
        return this.numRows;
    }

    public int insertRow(int beforeRow) {
        int index = super.insertRow(beforeRow);
        ++this.numRows;
        for (int i = 0; i < this.numColumns; ++i) {
            this.insertCell(index, i);
        }
        return index;
    }

    public void removeRow(int row) {
        super.removeRow(row);
        --this.numRows;
    }

    public void resize(int rows, int columns) {
        this.resizeColumns(columns);
        this.resizeRows(rows);
    }

    public void resizeColumns(int columns) {
        if (this.numColumns == columns) {
            return;
        }
        if (columns < 0) {
            throw new IndexOutOfBoundsException("Cannot set number of columns to " + columns);
        }
        if (this.numColumns > columns) {
            for (int i = 0; i < this.numRows; ++i) {
                for (int j = this.numColumns - 1; j >= columns; --j) {
                    this.removeCell(i, j);
                }
            }
        } else {
            for (int i = 0; i < this.numRows; ++i) {
                for (int j = this.numColumns; j < columns; ++j) {
                    this.insertCell(i, j);
                }
            }
        }
        this.numColumns = columns;
    }

    public void resizeRows(int rows) {
        if (this.numRows == rows) {
            return;
        }
        if (rows < 0) {
            throw new IndexOutOfBoundsException("Cannot set number of rows to " + rows);
        }
        if (this.numRows < rows) {
            Grid.addRows(this.getBodyElement(), rows - this.numRows, this.numColumns);
            this.numRows = rows;
        } else {
            while (this.numRows > rows) {
                this.removeRow(this.numRows - 1);
            }
        }
    }

    protected Element createCell() {
        Element td = super.createCell();
        DOM.setInnerHTML(td, "&nbsp;");
        return td;
    }

    protected void prepareCell(int row, int column) {
        this.prepareRow(row);
        if (column < 0) {
            throw new IndexOutOfBoundsException("Cannot access a column with a negative index: " + column);
        }
        if (column >= this.numColumns) {
            throw new IndexOutOfBoundsException("Column index: " + column + ", Column size: " + this.numColumns);
        }
    }

    protected void prepareColumn(int column) {
        if (column < 0) {
            throw new IndexOutOfBoundsException("Cannot access a column with a negative index: " + column);
        }
        if (column >= this.numColumns) {
            throw new IndexOutOfBoundsException("Column index: " + column + ", Column size: " + this.numColumns);
        }
    }

    protected void prepareRow(int row) {
        if (row < 0) {
            throw new IndexOutOfBoundsException("Cannot access a row with a negative index: " + row);
        }
        if (row >= this.numRows) {
            throw new IndexOutOfBoundsException("Row index: " + row + ", Row size: " + this.numRows);
        }
    }
}

