/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.maven;

import java.util.regex.Matcher;

public class TestRunnerResults {
    private int totalTestsRun;
    private int totalTestsPassed;
    private int totalTestsFailed;
    private int totalTestsErrored;

    public TestRunnerResults(int totalTestsRun, int totalTestsPassed, int totalTestsFailed, int totalTestsErrored) {
        this.totalTestsRun = totalTestsRun;
        this.totalTestsPassed = totalTestsPassed;
        this.totalTestsFailed = totalTestsFailed;
        this.totalTestsErrored = totalTestsErrored;
    }

    public static TestRunnerResults buildResultsFromMatcher(Matcher matcher) {
        return new TestRunnerResults(Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)), Integer.parseInt(matcher.group(3)), Integer.parseInt(matcher.group(4)));
    }

    public boolean hasFailures() {
        return this.totalTestsFailed > 0 || this.totalTestsErrored > 0;
    }

    public int getTotalTestsRun() {
        return this.totalTestsRun;
    }

    public int getTotalTestsPassed() {
        return this.totalTestsPassed;
    }

    public int getTotalTestsFailed() {
        return this.totalTestsFailed;
    }

    public int getTotalTestsErrored() {
        return this.totalTestsErrored;
    }

    public String toString() {
        return "totalTestsRun " + this.totalTestsRun + ", totalTestsPassed " + this.totalTestsPassed + ", totalTestsFailed " + this.totalTestsFailed + ", totalTestsErrored" + this.totalTestsErrored;
    }
}

