/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.autoconfigure.parameter;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.cloud.parametermanager.v1.ParameterManagerClient;
import com.google.cloud.parametermanager.v1.ParameterManagerSettings;
import com.google.cloud.spring.autoconfigure.parameter.GcpParameterProperties;
import com.google.cloud.spring.autoconfigure.parameter.GoogleParameterPropertySourceLocator;
import com.google.cloud.spring.core.CredentialsSupplier;
import com.google.cloud.spring.core.DefaultCredentialsProvider;
import com.google.cloud.spring.core.DefaultGcpProjectIdProvider;
import com.google.cloud.spring.core.GcpProjectIdProvider;
import com.google.cloud.spring.core.UserAgentHeaderProvider;
import java.io.IOException;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@ConditionalOnProperty(prefix="spring.cloud.gcp.parameter", name={"enabled"}, havingValue="true")
@EnableConfigurationProperties(value={GcpParameterProperties.class})
public class GcpParameterBootstrapConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public ParameterManagerClient parameterManagerClient(GcpParameterProperties properties) throws IOException {
        ParameterManagerSettings.Builder settings = (ParameterManagerSettings.Builder)((ParameterManagerSettings.Builder)ParameterManagerSettings.newBuilder().setCredentialsProvider((CredentialsProvider)new DefaultCredentialsProvider((CredentialsSupplier)properties))).setHeaderProvider((HeaderProvider)new UserAgentHeaderProvider(GcpParameterBootstrapConfiguration.class));
        if (!properties.getLocation().equals("global")) {
            String apiEndpoint = String.format("parametermanager.%s.rep.googleapis.com:443", properties.getLocation());
            settings.setEndpoint(apiEndpoint);
        }
        return ParameterManagerClient.create((ParameterManagerSettings)settings.build());
    }

    @Bean
    @ConditionalOnMissingBean
    public GoogleParameterPropertySourceLocator googleConfigPropertySourceLocator(GcpParameterProperties parameterProperties, ParameterManagerClient parameterManagerClient) throws IOException {
        return new GoogleParameterPropertySourceLocator((GcpProjectIdProvider)new DefaultGcpProjectIdProvider(), (CredentialsProvider)new DefaultCredentialsProvider((CredentialsSupplier)parameterProperties), parameterProperties, parameterManagerClient);
    }
}

