/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.appengine;

import com.google.appengine.api.datastore.Cursor;
import com.google.appengine.api.datastore.Entity;
import java.util.List;
import java.util.Map;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ManagedConnection;
import org.datanucleus.ObjectManager;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.store.appengine.Utils;
import org.datanucleus.store.appengine.query.DatastoreQuery;
import org.datanucleus.store.query.AbstractJavaQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PojoDatastoreBridge {
    PojoDatastoreBridge() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> List<T> toPojoResult(final ObjectManager om, Class<T> cls, Iterable<Entity> queryResultIterable, Cursor endCursor) {
        final ClassLoaderResolver clr = om.getClassLoaderResolver();
        final AbstractClassMetaData acmd = om.getMetaDataManager().getMetaDataForClass(cls, clr);
        Utils.Function<Entity, Object> func = new Utils.Function<Entity, Object>(){

            @Override
            public Object apply(Entity from) {
                return DatastoreQuery.entityToPojo(from, acmd, clr, om, true, om.getFetchPlan().getCopy());
            }
        };
        DummyQuery query = new DummyQuery(om);
        ManagedConnection mconn = om.getStoreManager().getConnection(om);
        try {
            List<?> list = DatastoreQuery.newStreamingQueryResultForEntities(queryResultIterable, func, mconn, endCursor, query);
            return list;
        }
        finally {
            mconn.release();
        }
    }

    private static final class DummyQuery
    extends AbstractJavaQuery {
        private DummyQuery(ObjectManager om) {
            super(om);
        }

        public String getSingleStringQuery() {
            throw new UnsupportedOperationException();
        }

        protected void compileInternal(boolean forExecute, Map parameterValues) {
            throw new UnsupportedOperationException();
        }

        protected Object performExecute(Map parameters) {
            throw new UnsupportedOperationException();
        }
    }
}

