/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.blobstore.dev;

import com.google.appengine.api.NamespaceManager;
import com.google.appengine.api.blobstore.dev.BlobUploadSession;
import com.google.appengine.api.datastore.DatastoreService;
import com.google.appengine.api.datastore.DatastoreServiceFactory;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.EntityNotFoundException;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.KeyFactory;

public final class BlobUploadSessionStorage {
    static final String SUCCESS_PATH = "success_path";
    private final DatastoreService datastoreService = DatastoreServiceFactory.getDatastoreService();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createSession(BlobUploadSession session) {
        Entity entity;
        String namespace = NamespaceManager.get();
        try {
            NamespaceManager.set((String)"");
            entity = new Entity("__BlobUploadSession__");
        }
        finally {
            NamespaceManager.set((String)namespace);
        }
        entity.setProperty(SUCCESS_PATH, (Object)session.getSuccessPath());
        this.datastoreService.put(entity);
        return KeyFactory.keyToString((Key)entity.getKey());
    }

    public BlobUploadSession loadSession(String sessionId) {
        try {
            return this.convertFromEntity(this.datastoreService.get(this.getKeyForSession(sessionId)));
        }
        catch (EntityNotFoundException ex) {
            return null;
        }
    }

    public void deleteSession(String sessionId) {
        this.datastoreService.delete(new Key[]{this.getKeyForSession(sessionId)});
    }

    private BlobUploadSession convertFromEntity(Entity entity) {
        return new BlobUploadSession((String)entity.getProperty(SUCCESS_PATH));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Key getKeyForSession(String sessionId) {
        String namespace = NamespaceManager.get();
        try {
            NamespaceManager.set((String)"");
            Key key = KeyFactory.stringToKey((String)sessionId);
            return key;
        }
        finally {
            NamespaceManager.set((String)namespace);
        }
    }
}

