/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2018-10-25 at 08:23:19 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.analyticsreporting.v4.model;

/**
 * The main response class which holds the reports from the Reporting API `batchGet` call.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Analytics Reporting API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GetReportsResponse extends com.google.api.client.json.GenericJson {

  /**
   * The amount of resource quota tokens deducted to execute the query. Includes all responses.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer queryCost;

  /**
   * Responses corresponding to each of the request.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Report> reports;

  static {
    // hack to force ProGuard to consider Report used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(Report.class);
  }

  /**
   * The amount of resource quota remaining for the property.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ResourceQuotasRemaining resourceQuotasRemaining;

  /**
   * The amount of resource quota tokens deducted to execute the query. Includes all responses.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getQueryCost() {
    return queryCost;
  }

  /**
   * The amount of resource quota tokens deducted to execute the query. Includes all responses.
   * @param queryCost queryCost or {@code null} for none
   */
  public GetReportsResponse setQueryCost(java.lang.Integer queryCost) {
    this.queryCost = queryCost;
    return this;
  }

  /**
   * Responses corresponding to each of the request.
   * @return value or {@code null} for none
   */
  public java.util.List<Report> getReports() {
    return reports;
  }

  /**
   * Responses corresponding to each of the request.
   * @param reports reports or {@code null} for none
   */
  public GetReportsResponse setReports(java.util.List<Report> reports) {
    this.reports = reports;
    return this;
  }

  /**
   * The amount of resource quota remaining for the property.
   * @return value or {@code null} for none
   */
  public ResourceQuotasRemaining getResourceQuotasRemaining() {
    return resourceQuotasRemaining;
  }

  /**
   * The amount of resource quota remaining for the property.
   * @param resourceQuotasRemaining resourceQuotasRemaining or {@code null} for none
   */
  public GetReportsResponse setResourceQuotasRemaining(ResourceQuotasRemaining resourceQuotasRemaining) {
    this.resourceQuotasRemaining = resourceQuotasRemaining;
    return this;
  }

  @Override
  public GetReportsResponse set(String fieldName, Object value) {
    return (GetReportsResponse) super.set(fieldName, value);
  }

  @Override
  public GetReportsResponse clone() {
    return (GetReportsResponse) super.clone();
  }

}
