/*
 * Decompiled with CFR 0.152.
 */
package svg;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.bridge.UserAgentAdapter;
import org.apache.batik.dom.svg.SAXSVGDocumentFactory;
import org.apache.batik.ext.awt.RenderingHintsKeyExt;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.util.XMLResourceDescriptor;
import org.w3c.dom.Document;
import org.w3c.dom.svg.SVGDocument;

public final class SvgImage {
    private final GraphicsNode rootSvgNode;
    private final SVGDocument svgDocument;

    public SvgImage(URL url) throws IOException {
        String parser = XMLResourceDescriptor.getXMLParserClassName();
        SAXSVGDocumentFactory factory = new SAXSVGDocumentFactory(parser);
        this.svgDocument = (SVGDocument)factory.createDocument(url.toString());
        this.rootSvgNode = SvgImage.getRootNode(this.svgDocument);
    }

    private static GraphicsNode getRootNode(SVGDocument document) {
        UserAgentAdapter userAgentAdapter = new UserAgentAdapter();
        BridgeContext bridgeContext = new BridgeContext((UserAgent)userAgentAdapter);
        GVTBuilder builder = new GVTBuilder();
        return builder.build(bridgeContext, (Document)document);
    }

    public GraphicsNode getRootSvgNode() {
        return this.rootSvgNode;
    }

    public Image getImage(int width, int height) {
        double scaleX;
        double scaleY;
        Rectangle2D bounds = this.rootSvgNode.getPrimitiveBounds();
        if (width <= 0) {
            scaleX = scaleY = (double)height / bounds.getHeight();
            width = (int)(scaleX * bounds.getWidth());
        } else if (height <= 0) {
            scaleX = scaleY = (double)width / bounds.getWidth();
            height = (int)(scaleY * bounds.getHeight());
        } else {
            scaleX = (double)width / bounds.getWidth();
            scaleY = (double)height / bounds.getHeight();
        }
        BufferedImage bufferedImage = new BufferedImage(width, height, 2);
        Graphics2D g2d = (Graphics2D)bufferedImage.getGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2d.setRenderingHint(RenderingHintsKeyExt.KEY_TRANSCODING, "Printing");
        AffineTransform usr2dev = new AffineTransform(scaleX, 0.0, 0.0, scaleY, 0.0, 0.0);
        g2d.transform(usr2dev);
        this.rootSvgNode.paint(g2d);
        g2d.dispose();
        return bufferedImage;
    }
}

