/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler.expressions;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.ASTCssNodeType;
import com.github.sommeri.less4j.core.ast.ComparisonExpression;
import com.github.sommeri.less4j.core.ast.ComparisonExpressionOperator;
import com.github.sommeri.less4j.core.ast.ComposedExpression;
import com.github.sommeri.less4j.core.ast.CssString;
import com.github.sommeri.less4j.core.ast.EscapedValue;
import com.github.sommeri.less4j.core.ast.Expression;
import com.github.sommeri.less4j.core.ast.ExpressionOperator;
import com.github.sommeri.less4j.core.ast.FaultyExpression;
import com.github.sommeri.less4j.core.ast.FunctionExpression;
import com.github.sommeri.less4j.core.ast.Guard;
import com.github.sommeri.less4j.core.ast.GuardCondition;
import com.github.sommeri.less4j.core.ast.IdentifierExpression;
import com.github.sommeri.less4j.core.ast.IndirectVariable;
import com.github.sommeri.less4j.core.ast.NamedExpression;
import com.github.sommeri.less4j.core.ast.NumberExpression;
import com.github.sommeri.less4j.core.ast.ParenthesesExpression;
import com.github.sommeri.less4j.core.ast.ReusableStructure;
import com.github.sommeri.less4j.core.ast.SignedExpression;
import com.github.sommeri.less4j.core.ast.Variable;
import com.github.sommeri.less4j.core.compiler.expressions.ArithmeticCalculator;
import com.github.sommeri.less4j.core.compiler.expressions.ColorFunctions;
import com.github.sommeri.less4j.core.compiler.expressions.ColorsCalculator;
import com.github.sommeri.less4j.core.compiler.expressions.ExpressionComparator;
import com.github.sommeri.less4j.core.compiler.expressions.ExpressionFilter;
import com.github.sommeri.less4j.core.compiler.expressions.FunctionsPackage;
import com.github.sommeri.less4j.core.compiler.expressions.GuardsComparator;
import com.github.sommeri.less4j.core.compiler.expressions.ListCalculator;
import com.github.sommeri.less4j.core.compiler.expressions.MathFunctions;
import com.github.sommeri.less4j.core.compiler.expressions.MiscFunctions;
import com.github.sommeri.less4j.core.compiler.expressions.NullScope;
import com.github.sommeri.less4j.core.compiler.expressions.StringFunctions;
import com.github.sommeri.less4j.core.compiler.expressions.TypeFunctions;
import com.github.sommeri.less4j.core.compiler.expressions.UnknownFunction;
import com.github.sommeri.less4j.core.compiler.expressions.VariableCycleDetector;
import com.github.sommeri.less4j.core.compiler.expressions.strings.StringInterpolator;
import com.github.sommeri.less4j.core.compiler.scopes.IScope;
import com.github.sommeri.less4j.core.compiler.scopes.ScopeFactory;
import com.github.sommeri.less4j.core.problems.BugHappened;
import com.github.sommeri.less4j.core.problems.ProblemsHandler;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ExpressionEvaluator {
    private VariableCycleDetector cycleDetector = new VariableCycleDetector();
    private final IScope scope;
    private final ProblemsHandler problemsHandler;
    private ArithmeticCalculator arithmeticCalculator;
    private ListCalculator listCalculator = new ListCalculator();
    private ColorsCalculator colorsCalculator;
    private ExpressionComparator comparator = new GuardsComparator();
    private List<FunctionsPackage> functions = new ArrayList<FunctionsPackage>();
    private StringInterpolator stringInterpolator = new StringInterpolator();

    public ExpressionEvaluator(ProblemsHandler problemsHandler) {
        this(new NullScope(), problemsHandler);
    }

    public ExpressionEvaluator(IScope scope, ProblemsHandler problemsHandler) {
        this.scope = scope == null ? new NullScope() : scope;
        this.problemsHandler = problemsHandler;
        this.arithmeticCalculator = new ArithmeticCalculator(problemsHandler);
        this.colorsCalculator = new ColorsCalculator(problemsHandler);
        this.functions.add(new MathFunctions(problemsHandler));
        this.functions.add(new StringFunctions(problemsHandler));
        this.functions.add(new ColorFunctions(problemsHandler));
        this.functions.add(new MiscFunctions(problemsHandler));
        this.functions.add(new TypeFunctions(problemsHandler));
    }

    protected void addFunctionsPack(FunctionsPackage pack) {
        this.functions.add(pack);
    }

    public Expression joinAll(List<Expression> allArguments, ASTCssNode parent) {
        if (allArguments.isEmpty()) {
            return new IdentifierExpression(parent.getUnderlyingStructure(), "");
        }
        Iterator<Expression> iterator = allArguments.iterator();
        Expression result = iterator.next();
        while (iterator.hasNext()) {
            result = new ComposedExpression(parent.getUnderlyingStructure(), result, new ExpressionOperator(parent.getUnderlyingStructure()), iterator.next());
        }
        return result;
    }

    public List<Expression> evaluateAll(List<Expression> expressions) {
        ArrayList<Expression> values = new ArrayList<Expression>();
        for (Expression argument : expressions) {
            values.add(this.evaluate(argument));
        }
        return values;
    }

    public IScope evaluateValues(IScope scope) {
        IScope result = ScopeFactory.createDummyScope();
        result.addFilteredVariables(this.toEvaluationFilter(), scope);
        return result;
    }

    private ExpressionFilter toEvaluationFilter() {
        return new ExpressionFilter(){

            @Override
            public Expression apply(Expression input) {
                return ExpressionEvaluator.this.evaluate(input);
            }
        };
    }

    public Expression evaluate(CssString input) {
        String value = this.stringInterpolator.replaceIn(input.getValue(), this, input.getUnderlyingStructure());
        return new CssString(input.getUnderlyingStructure(), value, input.getQuoteType());
    }

    public Expression evaluate(EscapedValue input) {
        String value = this.stringInterpolator.replaceIn(input.getValue(), this, input.getUnderlyingStructure());
        return new EscapedValue(input.getUnderlyingStructure(), value);
    }

    public Expression evaluate(Variable input) {
        if (this.cycleDetector.wouldCycle(input)) {
            this.problemsHandler.variablesCycle(this.cycleDetector.getCycleFor(input));
            return new FaultyExpression(input);
        }
        Expression value = this.scope.getValue(input);
        if (value == null) {
            this.problemsHandler.undefinedVariable(input);
            return new FaultyExpression(input);
        }
        this.cycleDetector.enteringVariableValue(input);
        Expression result = this.evaluate(value);
        this.cycleDetector.leftVariableValue();
        return result;
    }

    public Expression evaluateIfPresent(Variable input) {
        Expression value = this.scope.getValue(input);
        if (value == null) {
            return null;
        }
        return this.evaluate(value);
    }

    public Expression evaluate(IndirectVariable input) {
        Expression value = this.scope.getValue(input);
        if (!(value instanceof CssString)) {
            this.problemsHandler.nonStringIndirection(input);
            return new FaultyExpression(input);
        }
        CssString realName = (CssString)value;
        String realVariableName = "@" + realName.getValue();
        value = this.scope.getValue(realVariableName);
        if (value == null) {
            this.problemsHandler.undefinedVariable(realVariableName, realName);
            return new FaultyExpression(realName.getUnderlyingStructure());
        }
        return this.evaluate(value);
    }

    public Expression evaluate(Expression input) {
        switch (input.getType()) {
            case FUNCTION: {
                return this.evaluate((FunctionExpression)input);
            }
            case COMPOSED_EXPRESSION: {
                return this.evaluate((ComposedExpression)input);
            }
            case INDIRECT_VARIABLE: {
                return this.evaluate((IndirectVariable)input);
            }
            case VARIABLE: {
                return this.evaluate((Variable)input);
            }
            case PARENTHESES_EXPRESSION: {
                return this.evaluate(((ParenthesesExpression)input).getEnclosedExpression());
            }
            case SIGNED_EXPRESSION: {
                return this.evaluate((SignedExpression)input);
            }
            case NAMED_EXPRESSION: {
                return this.evaluate((NamedExpression)input);
            }
            case STRING_EXPRESSION: {
                return this.evaluate((CssString)input);
            }
            case ESCAPED_VALUE: {
                return this.evaluate((EscapedValue)input);
            }
            case IDENTIFIER_EXPRESSION: 
            case COLOR_EXPRESSION: 
            case NUMBER: 
            case FAULTY_EXPRESSION: 
            case UNICODE_RANGE_EXPRESSION: 
            case EMPTY_EXPRESSION: {
                return input;
            }
        }
        throw new BugHappened("Unknown expression type", (ASTCssNode)input);
    }

    private boolean booleanEvalueate(Expression input) {
        if (input.getType() == ASTCssNodeType.COMPARISON_EXPRESSION) {
            return this.booleanEvalueate((ComparisonExpression)input);
        }
        Expression value = this.evaluate(input);
        if (value.getType() != ASTCssNodeType.IDENTIFIER_EXPRESSION) {
            return false;
        }
        IdentifierExpression identifier = (IdentifierExpression)value;
        return "true".equals(identifier.getValue());
    }

    public boolean booleanEvalueate(ComparisonExpression input) {
        Expression leftE = this.evaluate(input.getLeft());
        Expression rightE = this.evaluate(input.getRight());
        ComparisonExpressionOperator operator = input.getOperator();
        if (operator.getOperator() == ComparisonExpressionOperator.Operator.OPEQ) {
            return this.comparator.equal(leftE, rightE);
        }
        if (leftE.getType() != ASTCssNodeType.NUMBER) {
            this.problemsHandler.incompatibleComparisonOperand(leftE, operator);
            return false;
        }
        if (rightE.getType() != ASTCssNodeType.NUMBER) {
            this.problemsHandler.incompatibleComparisonOperand(rightE, operator);
            return false;
        }
        return this.compareNumbers((NumberExpression)leftE, (NumberExpression)rightE, operator);
    }

    private boolean compareNumbers(NumberExpression leftE, NumberExpression rightE, ComparisonExpressionOperator operator) {
        if (!this.canCompareDimensions(leftE.getDimension(), rightE.getDimension())) {
            return false;
        }
        Double left = leftE.getValueAsDouble();
        Double right = rightE.getValueAsDouble();
        switch (operator.getOperator()) {
            case GREATER: {
                return left.compareTo(right) > 0;
            }
            case GREATER_OR_EQUAL: {
                return left.compareTo(right) >= 0;
            }
            case LOWER_OR_EQUAL: {
                return left.compareTo(right) <= 0;
            }
            case LOWER: {
                return left.compareTo(right) < 0;
            }
        }
        throw new BugHappened("Unexpected comparison operator", (ASTCssNode)operator);
    }

    private boolean canCompareDimensions(NumberExpression.Dimension left, NumberExpression.Dimension right) {
        return true;
    }

    public Expression evaluate(FunctionExpression input) {
        Expression evaluatedParameter = this.evaluate(input.getParameter());
        List<Expression> splitParameters = evaluatedParameter.splitByComma();
        if (!input.isCssOnlyFunction()) {
            for (FunctionsPackage pack : this.functions) {
                if (!pack.canEvaluate(input, splitParameters)) continue;
                return pack.evaluate(input, splitParameters, evaluatedParameter);
            }
        }
        UnknownFunction unknownFunction = new UnknownFunction();
        return unknownFunction.evaluate(splitParameters, this.problemsHandler, input, evaluatedParameter);
    }

    public Expression evaluate(NamedExpression input) {
        return new NamedExpression(input.getUnderlyingStructure(), input.getName(), this.evaluate(input.getExpression()));
    }

    public Expression evaluate(SignedExpression input) {
        Expression evaluate = this.evaluate(input.getExpression());
        if (evaluate instanceof NumberExpression) {
            NumberExpression negation = ((NumberExpression)evaluate).clone();
            if (input.getSign() == SignedExpression.Sign.PLUS) {
                return negation;
            }
            negation.negate();
            negation.setOriginalString(null);
            negation.setExpliciteSign(false);
            return negation;
        }
        this.problemsHandler.nonNumberNegation(input);
        return new FaultyExpression(input);
    }

    public Expression evaluate(ComposedExpression input) {
        Expression leftValue = this.evaluate(input.getLeft());
        Expression rightValue = this.evaluate(input.getRight());
        if (leftValue.isFaulty() || rightValue.isFaulty()) {
            return new FaultyExpression(input);
        }
        if (this.arithmeticCalculator.accepts(input.getOperator(), leftValue, rightValue)) {
            return this.arithmeticCalculator.evalute(input, leftValue, rightValue);
        }
        if (this.colorsCalculator.accepts(input.getOperator(), leftValue, rightValue)) {
            return this.colorsCalculator.evalute(input, leftValue, rightValue);
        }
        if (this.listCalculator.accepts(input.getOperator())) {
            return this.listCalculator.evalute(input, leftValue, rightValue);
        }
        this.problemsHandler.cannotEvaluate(input);
        return new FaultyExpression(input);
    }

    public boolean guardsSatisfied(ReusableStructure mixin) {
        return this.evaluate(mixin.getGuards());
    }

    public boolean evaluate(List<Guard> guards) {
        if (guards == null || guards.isEmpty()) {
            return true;
        }
        for (Guard guard : guards) {
            if (!this.evaluate(guard)) continue;
            return true;
        }
        return false;
    }

    public boolean evaluate(Guard guard) {
        List<GuardCondition> conditions = guard.getConditions();
        if (conditions == null || conditions.isEmpty()) {
            return true;
        }
        for (GuardCondition condition : conditions) {
            if (this.evaluate(condition)) continue;
            return false;
        }
        return true;
    }

    private boolean evaluate(GuardCondition guardCondition) {
        Expression condition = guardCondition.getCondition();
        boolean conditionStatus = this.booleanEvalueate(condition);
        return guardCondition.isNegated() ? !conditionStatus : conditionStatus;
    }

    public boolean isRatioExpression(Expression expression) {
        if (!(expression instanceof ComposedExpression)) {
            return false;
        }
        ComposedExpression composed = (ComposedExpression)expression;
        if (composed.getOperator().getOperator() != ExpressionOperator.Operator.SOLIDUS) {
            return false;
        }
        if (composed.getLeft().getType() != ASTCssNodeType.NUMBER) {
            return false;
        }
        return composed.getRight().getType() == ASTCssNodeType.NUMBER;
    }
}

