/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.ast;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.ASTCssNodeType;
import com.github.sommeri.less4j.core.ast.Expression;
import com.github.sommeri.less4j.core.ast.MediaQuery;
import com.github.sommeri.less4j.core.parser.HiddenTokenAwareTree;
import com.github.sommeri.less4j.utils.ArraysUtils;
import java.util.ArrayList;
import java.util.List;

public class Import
extends ASTCssNode {
    private ImportKind kind = ImportKind.IMPORT;
    private Expression urlExpression;
    private List<MediaQuery> mediums = new ArrayList<MediaQuery>();

    public Import(HiddenTokenAwareTree underlyingStructure) {
        super(underlyingStructure);
    }

    public ImportKind getKind() {
        return this.kind;
    }

    public void setKind(ImportKind kind) {
        this.kind = kind;
    }

    public Expression getUrlExpression() {
        return this.urlExpression;
    }

    public void setUrlExpression(Expression urlExpression) {
        this.urlExpression = urlExpression;
    }

    public List<MediaQuery> getMediums() {
        return this.mediums;
    }

    public void setMediums(List<MediaQuery> mediums) {
        this.mediums = mediums;
    }

    public void add(MediaQuery medium) {
        this.mediums.add(medium);
    }

    public boolean hasMediums() {
        return !this.mediums.isEmpty();
    }

    @Override
    public List<? extends ASTCssNode> getChilds() {
        List<ASTCssNode> result = ArraysUtils.asNonNullList(this.urlExpression);
        result.addAll(this.mediums);
        return result;
    }

    @Override
    public Import clone() {
        Import result = (Import)super.clone();
        result.urlExpression = this.urlExpression == null ? null : this.urlExpression.clone();
        result.mediums = ArraysUtils.deeplyClonedList(this.mediums);
        result.configureParentToAllChilds();
        return result;
    }

    @Override
    public ASTCssNodeType getType() {
        return ASTCssNodeType.IMPORT;
    }

    public static enum ImportKind {
        IMPORT,
        IMPORT_ONCE,
        IMPORT_MULTIPLE;

    }
}

