/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.utils;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ArraysUtils {
    public static <T> T last(List<T> values) {
        if (values.isEmpty()) {
            return null;
        }
        return values.get(values.size() - 1);
    }

    public static <T> List<T> asNonNullList(T ... a) {
        ArrayList<T> result = new ArrayList<T>();
        for (T t : a) {
            if (t == null) continue;
            result.add(t);
        }
        return result;
    }

    public static <T extends ASTCssNode> List<T> deeplyClonedList(List<T> list) {
        ArrayList<ASTCssNode> result = new ArrayList<ASTCssNode>();
        for (ASTCssNode t : list) {
            result.add(t.clone());
        }
        return result;
    }

    public static <T> List<T> remaining(Iterator<T> iterator) {
        ArrayList<T> result = new ArrayList<T>();
        while (iterator.hasNext()) {
            result.add(iterator.next());
        }
        return result;
    }
}

